/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.entities.brain.frog;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;

public class WalkTowardsLand
extends Behavior<PathfinderMob> {
    private final int distance;
    private final float speedModifier;
    private long nextStartTime;

    public WalkTowardsLand(int distance, float speedModifier) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED));
        this.distance = distance;
        this.speedModifier = speedModifier;
    }

    protected void stop(ServerLevel level, PathfinderMob entity, long time) {
        this.nextStartTime = time + 60L;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, PathfinderMob entity) {
        return entity.f_19853_.m_6425_(entity.m_142538_()).m_205070_(FluidTags.f_13131_);
    }

    protected void start(ServerLevel level, PathfinderMob entity, long time) {
        if (time >= this.nextStartTime) {
            BlockPos pos = entity.m_142538_();
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            CollisionContext context = CollisionContext.m_82750_((Entity)entity);
            for (BlockPos position : BlockPos.m_121925_((BlockPos)pos, (int)this.distance, (int)this.distance, (int)this.distance)) {
                if (position.m_123341_() == pos.m_123341_() && position.m_123343_() == pos.m_123343_()) continue;
                BlockState state = level.m_8055_(position);
                BlockState landState = level.m_8055_((BlockPos)mutable.m_122159_((Vec3i)position, Direction.DOWN));
                if (state.m_60713_(Blocks.f_49990_) || !level.m_6425_(position).m_76178_() || !state.m_60742_((BlockGetter)level, position, context).m_83281_() || !landState.m_60783_((BlockGetter)level, (BlockPos)mutable, Direction.UP)) continue;
                this.nextStartTime = time + 60L;
                BehaviorUtils.m_22617_((LivingEntity)entity, (BlockPos)position.m_7949_(), (float)this.speedModifier, (int)1);
                return;
            }
        }
    }
}

