/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.entities.brain.warden;

import com.cursedcauldron.wildbackport.client.registry.WBSoundEvents;
import com.cursedcauldron.wildbackport.common.entities.Warden;
import com.cursedcauldron.wildbackport.common.entities.access.api.Poses;
import com.cursedcauldron.wildbackport.common.entities.brain.WardenBrain;
import com.cursedcauldron.wildbackport.common.registry.entity.WBMemoryModules;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class Roar
extends Behavior<Warden> {
    public Roar() {
        super((Map)ImmutableMap.of(WBMemoryModules.ROAR_TARGET.get(), (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_ABSENT, WBMemoryModules.ROAR_SOUND_COOLDOWN.get(), (Object)MemoryStatus.REGISTERED, WBMemoryModules.ROAR_SOUND_DELAY.get(), (Object)MemoryStatus.REGISTERED), WardenBrain.ROAR_DURATION);
    }

    protected void start(ServerLevel level, Warden warden, long time) {
        Brain<Warden> brain = warden.m_6274_();
        brain.m_21882_(WBMemoryModules.ROAR_SOUND_DELAY.get(), (Object)Unit.INSTANCE, 26L);
        brain.m_21936_(MemoryModuleType.f_26370_);
        LivingEntity target = (LivingEntity)warden.m_6274_().m_21952_(WBMemoryModules.ROAR_TARGET.get()).get();
        BehaviorUtils.m_22595_((LivingEntity)warden, (LivingEntity)target);
        warden.m_20124_(Poses.ROARING.get());
        warden.increaseAngerAt((Entity)target, 20, false);
    }

    protected boolean canStillUse(ServerLevel level, Warden warden, long time) {
        return true;
    }

    protected void tick(ServerLevel level, Warden warden, long time) {
        if (!warden.m_6274_().m_21874_(WBMemoryModules.ROAR_SOUND_DELAY.get()) && !warden.m_6274_().m_21874_(WBMemoryModules.ROAR_SOUND_COOLDOWN.get())) {
            warden.m_6274_().m_21882_(WBMemoryModules.ROAR_SOUND_COOLDOWN.get(), (Object)Unit.INSTANCE, (long)(WardenBrain.ROAR_DURATION - 25));
            warden.m_5496_(WBSoundEvents.WARDEN_ROAR, 3.0f, 1.0f);
        }
    }

    protected void stop(ServerLevel level, Warden warden, long time) {
        if (warden.hasPose(Poses.ROARING.get())) {
            warden.m_20124_(Pose.STANDING);
        }
        warden.m_6274_().m_21952_(WBMemoryModules.ROAR_TARGET.get()).ifPresent(warden::updateAttackTarget);
        warden.m_6274_().m_21936_(WBMemoryModules.ROAR_TARGET.get());
    }
}

