/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.registry;

import com.cursedcauldron.wildbackport.client.registry.WBSoundTypes;
import com.cursedcauldron.wildbackport.common.blocks.FrogspawnBlock;
import com.cursedcauldron.wildbackport.common.blocks.MangroveLeavesBlock;
import com.cursedcauldron.wildbackport.common.blocks.MangrovePropaguleBlock;
import com.cursedcauldron.wildbackport.common.blocks.MangroveRootsBlock;
import com.cursedcauldron.wildbackport.common.blocks.MudBlock;
import com.cursedcauldron.wildbackport.common.blocks.SculkBlock;
import com.cursedcauldron.wildbackport.common.blocks.SculkCatalystBlock;
import com.cursedcauldron.wildbackport.common.blocks.SculkShriekerBlock;
import com.cursedcauldron.wildbackport.common.blocks.SculkVeinBlock;
import com.cursedcauldron.wildbackport.common.blocks.StateProperties;
import com.cursedcauldron.wildbackport.common.registry.WBItems;
import com.cursedcauldron.wildbackport.core.api.CoreRegistry;
import com.cursedcauldron.wildbackport.core.api.WoodTypeRegistry;
import com.cursedcauldron.wildbackport.core.mixin.access.DoorBlockAccessor;
import com.cursedcauldron.wildbackport.core.mixin.access.PressurePlateBlockAccessor;
import com.cursedcauldron.wildbackport.core.mixin.access.StairBlockAccessor;
import com.cursedcauldron.wildbackport.core.mixin.access.TrapDoorBlockAccessor;
import com.cursedcauldron.wildbackport.core.mixin.access.WoodButtonBlockAccessor;
import com.mojang.datafixers.util.Pair;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.WaterLilyBlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;

public class WBBlocks {
    public static final CoreRegistry<Block> BLOCKS = CoreRegistry.create(Registry.f_122824_, "wildbackport");
    public static final Supplier<Block> SCULK = WBBlocks.create("sculk", () -> new SculkBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_164533_).m_60978_(0.6f).m_60918_(WBSoundTypes.SCULK)), CreativeModeTab.f_40750_);
    public static final Supplier<Block> SCULK_VEIN = WBBlocks.create("sculk_vein", () -> new SculkVeinBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_164533_).m_60910_().m_60978_(0.2f).m_60918_(WBSoundTypes.SCULK_VEIN)), CreativeModeTab.f_40750_);
    public static final Supplier<Block> SCULK_CATALYST = WBBlocks.create("sculk_catalyst", () -> new SculkCatalystBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_164533_).m_60999_().m_60978_(3.0f).m_60918_(WBSoundTypes.SCULK_CATALYST).m_60953_(value -> 6)), CreativeModeTab.f_40751_);
    public static final Supplier<Block> SCULK_SHRIEKER = WBBlocks.create("sculk_shrieker", () -> new SculkShriekerBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_164533_, (MaterialColor)MaterialColor.f_76365_).m_60978_(3.0f).m_60918_(WBSoundTypes.SCULK_SHRIEKER)), CreativeModeTab.f_40751_);
    public static final Supplier<Block> OCHRE_FROGLIGHT = WBBlocks.create("ochre_froglight", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60966_().m_60953_(value -> 15).m_60918_(WBSoundTypes.FROGLIGHT)), CreativeModeTab.f_40750_);
    public static final Supplier<Block> VERDANT_FROGLIGHT = WBBlocks.create("verdant_froglight", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60966_().m_60953_(value -> 15).m_60918_(WBSoundTypes.FROGLIGHT)), CreativeModeTab.f_40750_);
    public static final Supplier<Block> PEARLESCENT_FROGLIGHT = WBBlocks.create("pearlescent_froglight", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60966_().m_60953_(value -> 15).m_60918_(WBSoundTypes.FROGLIGHT)), CreativeModeTab.f_40750_);
    public static final Supplier<Block> FROGSPAWN = WBBlocks.create("frogspawn", () -> new FrogspawnBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76312_).m_60966_().m_60993_().m_60955_().m_60910_().m_60918_(WBSoundTypes.FROGSPAWN)), (Supplier<T> entry) -> new WaterLilyBlockItem((Block)entry.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40753_)));
    public static final Supplier<Block> MANGROVE_LOG = WBBlocks.create("mangrove_log", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60947_((Material)Material.f_76320_, state -> state.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y ? MaterialColor.f_76364_ : MaterialColor.f_76370_).m_60978_(2.0f).m_60918_(SoundType.f_56736_)), CreativeModeTab.f_40749_);
    public static final Supplier<Block> MANGROVE_WOOD = WBBlocks.create("mangrove_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76364_).m_60978_(2.0f).m_60918_(SoundType.f_56736_)), CreativeModeTab.f_40749_);
    public static final Supplier<Block> STRIPPED_MANGROVE_LOG = WBBlocks.create("stripped_mangrove_log", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76364_).m_60978_(2.0f).m_60918_(SoundType.f_56736_)), CreativeModeTab.f_40749_);
    public static final Supplier<Block> STRIPPED_MANGROVE_WOOD = WBBlocks.create("stripped_mangrove_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76364_).m_60978_(2.0f).m_60918_(SoundType.f_56736_)), CreativeModeTab.f_40749_);
    public static final Supplier<Block> MANGROVE_PLANKS = WBBlocks.create("mangrove_planks", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76364_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_)), CreativeModeTab.f_40749_);
    public static final Supplier<Block> MANGROVE_STAIRS = WBBlocks.create("mangrove_stairs", () -> StairBlockAccessor.createStairBlock(MANGROVE_PLANKS.get().m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)MANGROVE_PLANKS.get()))), CreativeModeTab.f_40749_);
    public static final Supplier<Block> MANGROVE_SLAB = WBBlocks.create("mangrove_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76364_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_)), CreativeModeTab.f_40749_);
    public static final Supplier<Block> MANGROVE_FENCE = WBBlocks.create("mangrove_fence", () -> new FenceBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MANGROVE_PLANKS.get().m_60590_()).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_)), CreativeModeTab.f_40750_);
    public static final Supplier<Block> MANGROVE_FENCE_GATE = WBBlocks.create("mangrove_fence_gate", () -> new FenceGateBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MANGROVE_PLANKS.get().m_60590_()).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_)), CreativeModeTab.f_40751_);
    public static final Supplier<Block> MANGROVE_DOOR = WBBlocks.create("mangrove_door", () -> DoorBlockAccessor.createDoorBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MANGROVE_PLANKS.get().m_60590_()).m_60978_(3.0f).m_60918_(SoundType.f_56736_).m_60955_()), CreativeModeTab.f_40751_);
    public static final Supplier<Block> MANGROVE_TRAPDOOR = WBBlocks.create("mangrove_trapdoor", () -> TrapDoorBlockAccessor.createTrapDoorBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76364_).m_60978_(3.0f).m_60918_(SoundType.f_56736_).m_60955_().m_60922_(StateProperties::never)), CreativeModeTab.f_40751_);
    public static final Supplier<Block> MANGROVE_PRESSURE_PLATE = WBBlocks.create("mangrove_pressure_plate", () -> PressurePlateBlockAccessor.createPressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MANGROVE_PLANKS.get().m_60590_()).m_60910_().m_60978_(0.5f).m_60918_(SoundType.f_56736_)), CreativeModeTab.f_40751_);
    public static final Supplier<Block> MANGROVE_BUTTON = WBBlocks.create("mangrove_button", () -> WoodButtonBlockAccessor.createWoodButtonBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_().m_60978_(0.5f).m_60918_(SoundType.f_56736_)), CreativeModeTab.f_40751_);
    public static final Supplier<Block> MANGROVE_LEAVES = WBBlocks.create("mangrove_leaves", () -> new MangroveLeavesBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76274_).m_60978_(0.2f).m_60977_().m_60918_(SoundType.f_56740_).m_60955_().m_60922_(StateProperties::ocelotOrParrot).m_60960_(StateProperties::never).m_60971_(StateProperties::never)), CreativeModeTab.f_40750_);
    public static final Supplier<Block> MANGROVE_PROPAGULE = WBBlocks.create("mangrove_propagule", () -> new MangrovePropaguleBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60910_().m_60977_().m_60966_().m_60918_(SoundType.f_56740_)), CreativeModeTab.f_40750_);
    public static final Supplier<Block> POTTED_MANGROVE_PROPAGULE = WBBlocks.create("potted_mangrove_propagule", () -> new FlowerPotBlock(MANGROVE_PROPAGULE.get(), BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60966_().m_60955_()));
    public static final Supplier<Block> MANGROVE_ROOTS = WBBlocks.create("mangrove_roots", () -> new MangroveRootsBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60978_(0.7f).m_60977_().m_60918_(WBSoundTypes.MANGROVE_ROOTS).m_60955_().m_60922_(StateProperties::ocelotOrParrot).m_60960_(StateProperties::never).m_60971_(StateProperties::never)), CreativeModeTab.f_40749_);
    public static final Supplier<Block> MUDDY_MANGROVE_ROOTS = WBBlocks.create("muddy_mangrove_roots", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76314_).m_60978_(0.7f).m_60918_(WBSoundTypes.MUDDY_MANGROVE_ROOTS)), CreativeModeTab.f_40749_);
    public static final Pair<Supplier<StandingSignBlock>, Supplier<WallSignBlock>> MANGROVE_SIGN = WBBlocks.create("mangrove", Material.f_76320_, MaterialColor.f_76364_);
    public static final Supplier<Block> MUD = WBBlocks.create("mud", () -> new MudBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50493_).m_155949_(MaterialColor.f_76381_).m_60922_(StateProperties::always).m_60924_(StateProperties::always).m_60971_(StateProperties::always).m_60960_(StateProperties::always).m_60918_(WBSoundTypes.MUD)), CreativeModeTab.f_40749_);
    public static final Supplier<Block> PACKED_MUD = WBBlocks.create("packed_mud", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50493_).m_60913_(1.0f, 3.0f).m_60918_(WBSoundTypes.PACKED_MUD)), CreativeModeTab.f_40749_);
    public static final Supplier<Block> MUD_BRICKS = WBBlocks.create("mud_bricks", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76420_).m_60999_().m_60913_(1.5f, 3.0f).m_60918_(WBSoundTypes.MUD_BRICKS)), CreativeModeTab.f_40749_);
    public static final Supplier<Block> MUD_BRICK_STAIRS = WBBlocks.create("mud_brick_stairs", () -> StairBlockAccessor.createStairBlock(MUD_BRICKS.get().m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)MUD_BRICKS.get()))), CreativeModeTab.f_40749_);
    public static final Supplier<Block> MUD_BRICK_SLAB = WBBlocks.create("mud_brick_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76362_).m_60999_().m_60913_(1.5f, 3.0f)), CreativeModeTab.f_40749_);
    public static final Supplier<Block> MUD_BRICK_WALL = WBBlocks.create("mud_brick_wall", () -> new WallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)MUD_BRICKS.get()))), CreativeModeTab.f_40750_);
    public static final Supplier<Block> REINFORCED_DEEPSLATE = WBBlocks.create("reinforced_deepslate", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_164534_).m_60918_(SoundType.f_154677_).m_60913_(55.0f, 1200.0f).m_60993_()), CreativeModeTab.f_40750_);

    private static <T extends Block> Supplier<T> create(String key, Supplier<T> block, CreativeModeTab tab) {
        return WBBlocks.create(key, block, (Supplier<T> entry) -> new BlockItem((Block)entry.get(), new Item.Properties().m_41491_(tab)));
    }

    private static <T extends Block> Supplier<T> create(String key, Supplier<T> block, Function<Supplier<T>, Item> item) {
        Supplier entry = WBBlocks.create(key, block);
        WBItems.ITEMS.register(key, () -> (Item)item.apply(entry));
        return entry;
    }

    private static <T extends Block> Supplier<T> create(String key, Supplier<T> block) {
        return BLOCKS.register(key, block);
    }

    public static Pair<Supplier<StandingSignBlock>, Supplier<WallSignBlock>> create(String key, Material material, MaterialColor color) {
        return WBBlocks.create(key, BlockBehaviour.Properties.m_60944_((Material)material, (MaterialColor)color).m_60910_().m_60978_(1.0f).m_60918_(SoundType.f_56736_), new Item.Properties().m_41487_(16).m_41491_(CreativeModeTab.f_40750_));
    }

    public static Pair<Supplier<StandingSignBlock>, Supplier<WallSignBlock>> create(String key, BlockBehaviour.Properties blocks, Item.Properties items) {
        WoodType woodType = WoodTypeRegistry.create(new ResourceLocation("wildbackport", key));
        Supplier<StandingSignBlock> standing = WBBlocks.create(key + "_sign", () -> new StandingSignBlock(blocks, woodType));
        Supplier<WallSignBlock> wall = WBBlocks.create(key + "_wall_sign", () -> new WallSignBlock(blocks.m_60916_((Block)standing.get()), woodType));
        WBItems.ITEMS.register(key + "_sign", () -> new SignItem(items, (Block)standing.get(), (Block)wall.get()));
        return Pair.of(standing, wall);
    }
}

