/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.registry;

import com.cursedcauldron.wildbackport.client.registry.WBSoundEvents;
import com.cursedcauldron.wildbackport.common.entities.access.api.BoatTypes;
import com.cursedcauldron.wildbackport.common.items.ChestBoatItem;
import com.cursedcauldron.wildbackport.common.items.DiscFragmentItem;
import com.cursedcauldron.wildbackport.common.items.TadpoleBucketItem;
import com.cursedcauldron.wildbackport.common.registry.entity.WBEntityTypes;
import com.cursedcauldron.wildbackport.common.registry.forge.WBItemsImpl;
import com.cursedcauldron.wildbackport.core.api.CoreRegistry;
import com.cursedcauldron.wildbackport.core.mixin.access.RecordItemAccessor;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class WBItems {
    public static final CoreRegistry<Item> ITEMS = CoreRegistry.create(Registry.f_122827_, "wildbackport");
    public static final Supplier<Item> ALLAY_SPAWN_EGG = WBItems.create("allay_spawn_egg", WBItems.spawnEgg(WBEntityTypes.ALLAY, 56063, 44543));
    public static final Supplier<Item> FROG_SPAWN_EGG = WBItems.create("frog_spawn_egg", WBItems.spawnEgg(WBEntityTypes.FROG, 13661252, 0xFFC77C));
    public static final Supplier<Item> TADPOLE_SPAWN_EGG = WBItems.create("tadpole_spawn_egg", WBItems.spawnEgg(WBEntityTypes.TADPOLE, 7164733, 1444352));
    public static final Supplier<Item> WARDEN_SPAWN_EGG = WBItems.create("warden_spawn_egg", WBItems.spawnEgg(WBEntityTypes.WARDEN, 1001033, 3790560));
    public static final Supplier<Item> TADPOLE_BUCKET = WBItems.create("tadpole_bucket", () -> new TadpoleBucketItem(WBEntityTypes.TADPOLE, (Fluid)Fluids.f_76193_, () -> WBSoundEvents.BUCKED_EMPTY_TADPOLE, new Item.Properties().m_41487_(1).m_41491_(CreativeModeTab.f_40753_)));
    public static final Supplier<Item> MANGROVE_BOAT = WBItems.create("mangrove_boat", WBItems.boat(false, BoatTypes.MANGROVE.get()));
    public static final Supplier<Item> OAK_CHEST_BOAT = WBItems.create("oak_chest_boat", WBItems.boat(true, Boat.Type.OAK));
    public static final Supplier<Item> SPRUCE_CHEST_BOAT = WBItems.create("spruce_chest_boat", WBItems.boat(true, Boat.Type.SPRUCE));
    public static final Supplier<Item> ACACIA_CHEST_BOAT = WBItems.create("acacia_chest_boat", WBItems.boat(true, Boat.Type.ACACIA));
    public static final Supplier<Item> BIRCH_CHEST_BOAT = WBItems.create("birch_chest_boat", WBItems.boat(true, Boat.Type.BIRCH));
    public static final Supplier<Item> JUNGLE_CHEST_BOAT = WBItems.create("jungle_chest_boat", WBItems.boat(true, Boat.Type.JUNGLE));
    public static final Supplier<Item> DARK_OAK_CHEST_BOAT = WBItems.create("dark_oak_chest_boat", WBItems.boat(true, Boat.Type.DARK_OAK));
    public static final Supplier<Item> MANGROVE_CHEST_BOAT = WBItems.create("mangrove_chest_boat", WBItems.boat(true, BoatTypes.MANGROVE.get()));
    public static final Supplier<Item> ECHO_SHARD = WBItems.create("echo_shard", () -> new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40753_)));
    public static final Supplier<Item> MUSIC_DISC_5 = WBItems.create("music_disc_5", () -> RecordItemAccessor.createRecordItem(15, WBSoundEvents.MUSIC_DISC_5, new Item.Properties().m_41487_(1).m_41491_(CreativeModeTab.f_40753_).m_41497_(Rarity.RARE)));
    public static final Supplier<Item> DISC_FRAGMENT_5 = WBItems.create("disc_fragment_5", () -> new DiscFragmentItem(new Item.Properties().m_41491_(CreativeModeTab.f_40753_)));

    private static <T extends Item> Supplier<T> create(String key, Supplier<T> item) {
        return ITEMS.register(key, item);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static Supplier<Item> spawnEgg(Supplier<? extends EntityType<? extends Mob>> mob, int background, int highlight) {
        void var2_2;
        void var1_1;
        return WBItemsImpl.spawnEgg(mob, (int)var1_1, (int)var2_2);
    }

    private static Supplier<Item> boat(boolean chested, Boat.Type type) {
        return () -> new ChestBoatItem(chested, type, new Item.Properties().m_41487_(1).m_41491_(CreativeModeTab.f_40752_));
    }
}

