/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.worldgen.features;

import com.cursedcauldron.wildbackport.common.blocks.SculkShriekerBlock;
import com.cursedcauldron.wildbackport.common.blocks.SculkSpreadManager;
import com.cursedcauldron.wildbackport.common.blocks.SculkSpreadable;
import com.cursedcauldron.wildbackport.common.registry.WBBlocks;
import com.cursedcauldron.wildbackport.common.utils.DirectionUtils;
import com.cursedcauldron.wildbackport.common.worldgen.features.SculkPatchConfiguration;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class SculkPatchFeature
extends Feature<SculkPatchConfiguration> {
    public SculkPatchFeature(Codec<SculkPatchConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<SculkPatchConfiguration> context) {
        BlockPos pos;
        WorldGenLevel level = context.m_159774_();
        if (!this.canSpreadFrom((LevelAccessor)level, pos = context.m_159777_())) {
            return false;
        }
        SculkPatchConfiguration config = (SculkPatchConfiguration)context.m_159778_();
        Random random = context.m_159776_();
        SculkSpreadManager spreader = SculkSpreadManager.createWorldGen();
        int rounds = config.spreadRounds() + config.growthRounds();
        for (int i = 0; i < rounds; ++i) {
            for (int count = 0; count < config.chargeCount(); ++count) {
                spreader.spread(pos, config.amountPerCharge());
            }
            boolean spreadable = i < config.spreadRounds();
            for (int attempts = 0; attempts < config.spreadAttempts(); ++attempts) {
                spreader.tick((LevelAccessor)level, pos, random, spreadable);
            }
            spreader.clearCursors();
        }
        BlockPos catalystPos = pos.m_7495_();
        if (random.nextFloat() <= config.catalystChance() && level.m_8055_(catalystPos).m_60838_((BlockGetter)level, catalystPos)) {
            level.m_7731_(pos, WBBlocks.SCULK_CATALYST.get().m_49966_(), 3);
        }
        int extraRareGrowths = config.extraRareGrowths().m_142270_(random);
        for (int i = 0; i < extraRareGrowths; ++i) {
            BlockPos shriekPos = pos.m_142082_(random.nextInt(5) - 2, 0, random.nextInt(5) - 2);
            if (!level.m_8055_(shriekPos).m_60795_() || !level.m_8055_(shriekPos.m_7495_()).m_60783_((BlockGetter)level, shriekPos.m_7495_(), Direction.UP)) continue;
            level.m_7731_(shriekPos, (BlockState)WBBlocks.SCULK_SHRIEKER.get().m_49966_().m_61124_((Property)SculkShriekerBlock.CAN_SUMMON, (Comparable)Boolean.valueOf(true)), 3);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean canSpreadFrom(LevelAccessor level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() instanceof SculkSpreadable) {
            return true;
        }
        if (!state.m_60795_()) {
            if (!state.m_60713_(Blocks.f_49990_)) return false;
            if (!state.m_60819_().m_76170_()) return false;
        }
        if (!DirectionUtils.stream().map(arg_0 -> ((BlockPos)pos).m_142300_(arg_0)).anyMatch(position -> level.m_8055_(position).m_60838_((BlockGetter)level, position))) return false;
        return true;
    }
}

