/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.worldgen.placers;

import com.cursedcauldron.wildbackport.common.registry.worldgen.RootPlacerType;
import com.cursedcauldron.wildbackport.common.worldgen.decorator.AboveRootPlacement;
import com.cursedcauldron.wildbackport.common.worldgen.decorator.MangroveRootPlacement;
import com.cursedcauldron.wildbackport.common.worldgen.features.RootedTreeConfig;
import com.cursedcauldron.wildbackport.common.worldgen.placers.RootPlacer;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class MangroveRootPlacer
extends RootPlacer {
    public static final Codec<MangroveRootPlacer> CODEC = RecordCodecBuilder.create(instance -> MangroveRootPlacer.codec(instance).and((App)MangroveRootPlacement.CODEC.fieldOf("mangrove_root_placement").forGetter(placer -> placer.mangroveRootPlacement)).apply((Applicative)instance, MangroveRootPlacer::new));
    private final MangroveRootPlacement mangroveRootPlacement;

    public MangroveRootPlacer(IntProvider trunkOffsetY, BlockStateProvider rootProvider, Optional<AboveRootPlacement> aboveRootPlacement, MangroveRootPlacement mangroveRootPlacement) {
        super(trunkOffsetY, rootProvider, aboveRootPlacement);
        this.mangroveRootPlacement = mangroveRootPlacement;
    }

    @Override
    public boolean generate(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> replacer, Random random, BlockPos pos, BlockPos origin, RootedTreeConfig config) {
        ArrayList positions = Lists.newArrayList();
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        while (mutable.m_123342_() < origin.m_123342_()) {
            if (!this.canGrowThrough(level, (BlockPos)mutable)) {
                return false;
            }
            mutable.m_122173_(Direction.UP);
        }
        positions.add(origin.m_7495_());
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            ArrayList offshootPositions;
            BlockPos position = origin.m_142300_(direction);
            if (!this.canGrow(level, random, position, direction, origin, offshootPositions = Lists.newArrayList(), 0)) {
                return false;
            }
            positions.addAll(offshootPositions);
            positions.add(origin.m_142300_(direction));
        }
        for (BlockPos position : positions) {
            this.placeRoots(level, replacer, random, position, config);
        }
        return true;
    }

    private boolean canGrow(LevelSimulatedReader level, Random random, BlockPos pos, Direction direction, BlockPos origin, List<BlockPos> offshootPositions, int rootLength) {
        int length = this.mangroveRootPlacement.maxRootLength();
        if (rootLength != length && offshootPositions.size() <= length) {
            for (BlockPos position : this.getOffshootPositions(pos, direction, random, origin)) {
                if (!this.canGrowThrough(level, position)) continue;
                offshootPositions.add(position);
                if (this.canGrow(level, random, position, direction, origin, offshootPositions, rootLength + 1)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected List<BlockPos> getOffshootPositions(BlockPos pos, Direction direction, Random random, BlockPos origin) {
        BlockPos below = pos.m_7495_();
        BlockPos offset = pos.m_142300_(direction);
        int distance = pos.m_123333_((Vec3i)origin);
        int rootWidth = this.mangroveRootPlacement.maxRootWidth();
        float chance = this.mangroveRootPlacement.randomSkewChance();
        if (distance > rootWidth - 3 && distance <= rootWidth) {
            return random.nextFloat() < chance ? List.of(below, offset.m_7495_()) : List.of(below);
        }
        if (distance > rootWidth) {
            return List.of(below);
        }
        if (random.nextFloat() < chance) {
            return List.of(below);
        }
        return random.nextBoolean() ? List.of(offset) : List.of(below);
    }

    @Override
    protected boolean canGrowThrough(LevelSimulatedReader level, BlockPos pos) {
        return super.canGrowThrough(level, pos) || level.m_7433_(pos, state -> state.m_204341_(this.mangroveRootPlacement.canGrowThrough()));
    }

    @Override
    protected void placeRoots(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> replacer, Random random, BlockPos pos, RootedTreeConfig config) {
        if (level.m_7433_(pos, state -> state.m_204341_(this.mangroveRootPlacement.muddyRootsIn()))) {
            BlockState state2 = this.mangroveRootPlacement.muddyRootsProvider().m_7112_(random, pos);
            replacer.accept(pos, this.applyWaterlogging(level, pos, state2));
        } else {
            super.placeRoots(level, replacer, random, pos, config);
        }
    }

    @Override
    protected RootPlacerType<?> getType() {
        return RootPlacerType.MANGROVE_ROOT_PLACER.get();
    }
}

