/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.wildbackport.common.worldgen.structure.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.Nullable;

public class BlockTagRotProcessor
extends StructureProcessor {
    public static final Codec<BlockTagRotProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryCodecs.m_206277_((ResourceKey)Registry.f_122901_).optionalFieldOf("rottable_blocks").forGetter(processor -> processor.rottableBlocks), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("integrity").forGetter(processor -> Float.valueOf(processor.integrity))).apply((Applicative)instance, BlockTagRotProcessor::new));
    private static final StructureProcessorType<BlockTagRotProcessor> BLOCK_TAG_ROT = (StructureProcessorType)Registry.m_122965_((Registry)Registry.f_122891_, (ResourceLocation)new ResourceLocation("block_rot"), () -> CODEC);
    private final Optional<HolderSet<Block>> rottableBlocks;
    private final float integrity;

    public BlockTagRotProcessor(TagKey<Block> rottableBlocks, float integrity) {
        this(Optional.of(Registry.f_122824_.m_203561_(rottableBlocks)), integrity);
    }

    public BlockTagRotProcessor(Optional<HolderSet<Block>> rottableBlocks, float integrity) {
        this.rottableBlocks = rottableBlocks;
        this.integrity = integrity;
    }

    @Nullable
    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader level, BlockPos from, BlockPos to, StructureTemplate.StructureBlockInfo pre, StructureTemplate.StructureBlockInfo post, StructurePlaceSettings settings) {
        return !(!this.rottableBlocks.isEmpty() && !pre.f_74676_.m_204341_(this.rottableBlocks.get()) || settings.m_74399_(post.f_74675_).nextFloat() <= this.integrity) ? null : post;
    }

    protected StructureProcessorType<?> m_6953_() {
        return BLOCK_TAG_ROT;
    }
}

