/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.mainwindow;

import de.keksuccino.fancymenu.FancyMenu;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;

public class MainWindowHandler {
    private static String windowtitle = null;
    private static File icondir = new File("config/fancymenu/minecraftwindow/icons");

    public static void init() {
        if (!icondir.exists()) {
            icondir.mkdirs();
        }
    }

    public static void handleForceFullscreen() {
        try {
            if (Minecraft.m_91087_() != null && Minecraft.m_91087_().m_91268_() != null) {
                if (((Boolean)FancyMenu.config.getOrDefault("forcefullscreen", (Object)false)).booleanValue() && !Minecraft.m_91087_().m_91268_().m_85440_()) {
                    Minecraft.m_91087_().m_91268_().m_85438_();
                    FancyMenu.LOGGER.info("[FANCYMENU] Forced window to fullscreen!");
                }
            } else {
                FancyMenu.LOGGER.error("[FANCYMENU] Force fullscreen failed! Instance or window was NULL!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateWindowIcon() {
        if (((Boolean)FancyMenu.config.getOrDefault("customwindowicon", (Object)false)).booleanValue()) {
            try {
                File i16 = new File(icondir.getPath() + "/icon16x16.png");
                File i32 = new File(icondir.getPath() + "/icon32x32.png");
                if (!i16.exists() || !i32.exists()) {
                    System.out.println("## ERROR ## [FANCYMENU] Unable to set custom icons: 'icon16x16.png' or 'icon32x32.png' missing!");
                    return;
                }
                BufferedImage i16buff = ImageIO.read(i16);
                if (i16buff.getHeight() != 16 || i16buff.getWidth() != 16) {
                    System.out.println("'## ERROR ## [FANCYMENU] Unable to set custom icons: 'icon16x16.png' not 16x16!");
                    return;
                }
                BufferedImage i32buff = ImageIO.read(i32);
                if (i32buff.getHeight() != 32 || i32buff.getWidth() != 32) {
                    System.out.println("'## ERROR ## [FANCYMENU] Unable to set custom icons: 'icon32x32.png' not 32x32!");
                    return;
                }
                FileInputStream icon16 = new FileInputStream(i16);
                FileInputStream icon32 = new FileInputStream(i32);
                Minecraft.m_91087_().m_91268_().m_85395_((InputStream)icon16, (InputStream)icon32);
                System.out.println("[FANCYMENU] Custom minecraft icon successfully loaded!");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void updateWindowTitle() {
        String s = (String)FancyMenu.config.getOrDefault("customwindowtitle", (Object)"");
        if (s != null && !s.equals("")) {
            windowtitle = s;
            MainWindowHandler.setWindowTitle();
        } else {
            windowtitle = null;
        }
    }

    private static void setWindowTitle() {
        if (windowtitle != null) {
            Minecraft.m_91087_().m_91268_().m_85422_(windowtitle);
        }
    }

    public static String getCustomWindowTitle() {
        return windowtitle;
    }

    public static int getWindowGuiWidth() {
        Screen s = Minecraft.m_91087_().f_91080_;
        if (s != null) {
            double mcScale = Minecraft.m_91087_().m_91268_().m_85385_((int)Minecraft.m_91087_().m_91268_().m_85449_(), Minecraft.m_91087_().f_91066_.f_92043_);
            float baseUIScale = 1.0f;
            float sc = (float)((double)baseUIScale * ((double)baseUIScale / mcScale));
            return (int)((float)s.f_96543_ / sc);
        }
        return 0;
    }

    public static int getWindowGuiHeight() {
        Screen s = Minecraft.m_91087_().f_91080_;
        if (s != null) {
            double mcScale = Minecraft.m_91087_().m_91268_().m_85385_((int)Minecraft.m_91087_().m_91268_().m_85449_(), Minecraft.m_91087_().f_91066_.f_92043_);
            float baseUIScale = 1.0f;
            float sc = (float)((double)baseUIScale * ((double)baseUIScale / mcScale));
            return (int)((float)s.f_96544_ / sc);
        }
        return 0;
    }
}

