/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper;

import com.google.common.io.Files;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.menu.animation.AdvancedAnimation;
import de.keksuccino.fancymenu.menu.animation.AnimationHandler;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.fancy.guicreator.CustomGuiBase;
import de.keksuccino.fancymenu.menu.fancy.guicreator.CustomGuiLoader;
import de.keksuccino.fancymenu.menu.fancy.helper.CustomizationHelperUI;
import de.keksuccino.fancymenu.menu.fancy.helper.MenuReloadedEvent;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.LayoutEditorScreen;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.PreloadedLayoutEditorScreen;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.content.button.buttonactions.ButtonActionScreen;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.content.visibilityrequirements.VisibilityRequirementsScreen;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.MenuHandlerRegistry;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.properties.PropertiesSerializer;
import de.keksuccino.konkrete.properties.PropertiesSet;
import de.keksuccino.konkrete.rendering.animation.IAnimationRenderer;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CustomizationHelper {
    public static List<Runnable> mainThreadTasks = new ArrayList<Runnable>();

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new CustomizationHelper());
        CustomizationHelperUI.init();
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onRenderPost(ScreenEvent.DrawScreenEvent.Post e) {
        ArrayList<Runnable> runs = new ArrayList<Runnable>();
        runs.addAll(mainThreadTasks);
        for (Runnable r : runs) {
            try {
                r.run();
                mainThreadTasks.remove(r);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (!(e.getScreen().getClass().getName().startsWith("de.keksuccino.spiffyhud.") || e.getScreen().getClass().getName().startsWith("de.keksuccino.drippyloadingscreen.") || e.getScreen().getClass().getName().startsWith("de.keksuccino.fmaudio.") || e.getScreen() instanceof ButtonActionScreen || e.getScreen() instanceof VisibilityRequirementsScreen)) {
            CustomizationHelperUI.render(e.getPoseStack(), e.getScreen());
        }
    }

    public static void updateUI() {
        CustomizationHelperUI.updateUI();
    }

    public static void reloadSystemAndMenu() {
        FancyMenu.updateConfig();
        MenuCustomization.resetSounds();
        MenuCustomization.stopSounds();
        AnimationHandler.resetAnimations();
        AnimationHandler.resetAnimationSounds();
        AnimationHandler.stopAnimationSounds();
        MenuCustomization.reload();
        MenuHandlerRegistry.setActiveHandler(null);
        CustomGuiLoader.loadCustomGuis();
        if (!((Boolean)FancyMenu.config.getOrDefault("showcustomizationbuttons", (Object)true)).booleanValue()) {
            CustomizationHelperUI.showButtonInfo = false;
            CustomizationHelperUI.showMenuInfo = false;
        }
        MinecraftForge.EVENT_BUS.post((Event)new MenuReloadedEvent(Minecraft.m_91087_().f_91080_));
        try {
            Minecraft.m_91087_().m_91152_(Minecraft.m_91087_().f_91080_);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void openFile(File f) {
        try {
            String url = f.toURI().toURL().toString();
            String s = System.getProperty("os.name").toLowerCase(Locale.ROOT);
            URL u = new URL(url);
            if (!Minecraft.f_91002_) {
                if (s.contains("win")) {
                    Runtime.getRuntime().exec(new String[]{"rundll32", "url.dll,FileProtocolHandler", url});
                } else {
                    if (u.getProtocol().equals("file")) {
                        url = url.replace("file:", "file://");
                    }
                    Runtime.getRuntime().exec(new String[]{"xdg-open", url});
                }
            } else {
                Runtime.getRuntime().exec(new String[]{"open", url});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void editLayout(Screen current, File layout) {
        try {
            if (layout != null && current != null && layout.exists() && layout.isFile()) {
                ArrayList<PropertiesSet> l = new ArrayList<PropertiesSet>();
                PropertiesSet set = PropertiesSerializer.getProperties((String)layout.getPath());
                l.add(set);
                List meta = set.getPropertiesOfType("customization-meta");
                if (meta.isEmpty()) {
                    meta = set.getPropertiesOfType("type-meta");
                }
                if (!meta.isEmpty()) {
                    ((PropertiesSection)meta.get(0)).addEntry("path", layout.getPath());
                    LayoutEditorScreen.isActive = true;
                    Minecraft.m_91087_().m_91152_((Screen)new PreloadedLayoutEditorScreen(current, l));
                    MenuCustomization.stopSounds();
                    MenuCustomization.resetSounds();
                    for (IAnimationRenderer r : AnimationHandler.getAnimations()) {
                        if (!(r instanceof AdvancedAnimation)) continue;
                        ((AdvancedAnimation)r).stopAudio();
                        if (!((AdvancedAnimation)r).replayIntro()) continue;
                        ((AdvancedAnimation)r).resetAnimation();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean saveLayoutTo(PropertiesSet layout, String to) {
        File f = new File(to);
        String s = Files.getFileExtension((String)to);
        if (s != null && !s.equals("")) {
            if (f.exists() && f.isFile()) {
                f.delete();
            }
            PropertiesSerializer.writeProperties((PropertiesSet)layout, (String)f.getPath());
            return true;
        }
        return false;
    }

    public static boolean saveLayoutTo(List<PropertiesSection> layout, String to) {
        PropertiesSet props = new PropertiesSet("menu");
        for (PropertiesSection sec : layout) {
            props.addProperties(sec);
        }
        return CustomizationHelper.saveLayoutTo(props, to);
    }

    public static boolean isScreenOverridden(Screen current) {
        return current != null && current instanceof CustomGuiBase && ((CustomGuiBase)current).getOverriddenScreen() != null;
    }

    public static void runTaskInMainThread(Runnable task) {
        mainThreadTasks.add(task);
    }
}

