/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.item.items.inputfield;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.api.item.CustomizationItem;
import de.keksuccino.fancymenu.api.item.CustomizationItemContainer;
import de.keksuccino.fancymenu.menu.variables.VariableHandler;
import de.keksuccino.konkrete.gui.content.AdvancedTextField;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;

public class InputFieldCustomizationItem
extends CustomizationItem {
    public String linkedVariable;
    public InputFieldType type = InputFieldType.TEXT;
    public int maxTextLength = 10000;
    public AdvancedTextField textField;
    public String lastValue = "";

    public InputFieldCustomizationItem(CustomizationItemContainer parentContainer, PropertiesSection item) {
        super(parentContainer, item);
        String var;
        String maxLengthString;
        InputFieldType t;
        this.linkedVariable = item.getEntryValue("linked_variable");
        String inputFieldTypeString = item.getEntryValue("input_field_type");
        if (inputFieldTypeString != null && (t = InputFieldType.getByName(inputFieldTypeString)) != null) {
            this.type = t;
        }
        if ((maxLengthString = item.getEntryValue("max_text_length")) != null && MathUtils.isInteger((String)maxLengthString)) {
            this.maxTextLength = Integer.parseInt(maxLengthString);
        }
        if (this.maxTextLength <= 0) {
            this.maxTextLength = 1;
        }
        Screen current = Minecraft.m_91087_().f_91080_;
        this.textField = new AdvancedTextField(Minecraft.m_91087_().f_91062_, this.getPosX(current), this.getPosY(current), this.width, this.height, true, this.type.filter);
        this.textField.m_94199_(this.maxTextLength);
        if (this.linkedVariable != null && (var = VariableHandler.getVariable(this.linkedVariable)) != null) {
            this.textField.m_94144_(var);
        }
    }

    @Override
    public void render(PoseStack matrix, Screen menu) throws IOException {
        if (this.shouldRender()) {
            RenderSystem.m_69478_();
            if (InputFieldCustomizationItem.isEditorActive()) {
                String var;
                this.textField.f_93623_ = false;
                this.textField.m_94186_(false);
                if (this.linkedVariable != null && (var = VariableHandler.getVariable(this.linkedVariable)) != null) {
                    this.textField.m_94144_(var);
                }
            }
            this.textField.f_93620_ = this.getPosX(menu);
            this.textField.f_93621_ = this.getPosY(menu);
            this.textField.m_93674_(this.width);
            this.textField.setHeight(this.height);
            this.textField.m_6305_(matrix, MouseInput.getMouseX(), MouseInput.getMouseY(), Minecraft.m_91087_().m_91297_());
            if (!InputFieldCustomizationItem.isEditorActive()) {
                if (this.linkedVariable != null) {
                    String val;
                    if (!this.lastValue.equals(this.textField.m_94155_())) {
                        VariableHandler.setVariable(this.linkedVariable, this.textField.m_94155_());
                    }
                    if ((val = VariableHandler.getVariable(this.linkedVariable)) != null && !this.textField.m_94155_().equals(val)) {
                        this.textField.m_94144_(val);
                    }
                }
                this.lastValue = this.textField.m_94155_();
            }
        }
    }

    public static enum InputFieldType {
        INTEGER_ONLY("integer", CharacterFilter.getIntegerCharacterFiler()),
        DECIMAL_ONLY("decimal", CharacterFilter.getDoubleCharacterFiler()),
        URL("url", CharacterFilter.getUrlCharacterFilter()),
        TEXT("text", null);

        String name;
        CharacterFilter filter;

        private InputFieldType(String name, CharacterFilter filter) {
            this.name = name;
            this.filter = filter;
        }

        public String getName() {
            return this.name;
        }

        public CharacterFilter getFilter() {
            return this.filter;
        }

        public static InputFieldType getByName(String name) {
            for (InputFieldType i : InputFieldType.values()) {
                if (!i.getName().equals(name)) continue;
                return i;
            }
            return null;
        }
    }
}

