/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.command;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public class RegistryArgument<T>
implements ArgumentType<T> {
    public static final DynamicCommandExceptionType BAD_ID = new DynamicCommandExceptionType(pair -> new TranslatableComponent("argument.kiwi.registry.id.invalid", new Object[]{((Pair)pair).getLeft(), ((Pair)pair).getRight()}));
    private final Registry<T> registry;
    private Collection<String> examples;

    public RegistryArgument(Registry<T> registry) {
        this.registry = registry;
    }

    public T parse(StringReader reader) throws CommandSyntaxException {
        int i = reader.getCursor();
        ResourceLocation resourcelocation = ResourceLocation.m_135818_((StringReader)reader);
        if (this.registry.m_7804_(resourcelocation)) {
            return (T)this.registry.m_7745_(resourcelocation);
        }
        reader.setCursor(i);
        throw BAD_ID.createWithContext((ImmutableStringReader)reader, (Object)Pair.of((Object)this.registry.m_123023_().m_135782_().m_135815_(), (Object)resourcelocation));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82926_((Iterable)this.registry.m_6566_(), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        if (this.examples == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            int count = 0;
            for (ResourceLocation key : this.registry.m_6566_()) {
                builder.add((Object)key.toString());
                if (++count != 3) continue;
                break;
            }
            this.examples = builder.build();
        }
        return this.examples;
    }

    public static class Serializer
    implements ArgumentSerializer<RegistryArgument<?>> {
        public void serializeToNetwork(RegistryArgument<?> argument, FriendlyByteBuf buffer) {
            buffer.m_130085_(argument.registry.m_123023_().m_135782_());
        }

        public RegistryArgument<?> deserializeFromNetwork(FriendlyByteBuf buffer) {
            return new RegistryArgument((Registry)Registry.f_122897_.m_7745_(buffer.m_130281_()));
        }

        public void serializeToJson(RegistryArgument<?> argument, JsonObject json) {
            json.addProperty("registry", argument.registry.m_123023_().m_135782_().toString());
        }
    }
}

