/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.datagen.provider;

import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagKey;
import snownee.kiwi.mixin.TagsProviderAccess;

public final class TagsProviderHelper<T> {
    private final TagsProviderAccess<T> tagsProvider;
    private final String modId;
    private final Registry<T> registry;

    public TagsProviderHelper(TagsProvider<T> tagsProvider) {
        this.tagsProvider = (TagsProviderAccess)tagsProvider;
        this.modId = this.tagsProvider.getModId();
        this.registry = this.tagsProvider.getRegistry();
    }

    public void optional(TagKey<T> tag, Supplier<? extends T> ... blocks) {
        Tag.Builder builder = this.tagsProvider.callGetOrCreateRawBuilder(tag);
        for (Supplier<T> supplier : blocks) {
            builder.m_144379_(this.registry.m_7981_(supplier.get()), this.modId);
        }
    }

    public void add(TagKey<T> tag, Supplier<? extends T> ... blocks) {
        Tag.Builder builder = this.tagsProvider.callGetOrCreateRawBuilder(tag);
        for (Supplier<T> supplier : blocks) {
            builder.m_13327_(this.registry.m_7981_(supplier.get()), this.modId);
        }
    }

    public Stream<T> getModEntries() {
        return this.registry.m_123024_().filter($ -> this.registry.m_7981_($).m_135827_().equals(this.modId));
    }
}

