/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.network;

import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.network.IPacketHandler;
import snownee.kiwi.network.KiwiPacket;
import snownee.kiwi.network.PacketHandler;

public final class Networking {
    private static final String protocol = Integer.toString(1);
    private static final SimpleChannel channel;
    private static final Map<ResourceLocation, IPacketHandler> handlers;
    public static final PacketDistributor<ServerPlayer> ALL_EXCEPT;

    private Networking() {
    }

    private static void encode(FriendlyByteBuf msg, FriendlyByteBuf buf) {
        buf.writeBytes((ByteBuf)msg);
    }

    private static FriendlyByteBuf decode(FriendlyByteBuf buf) {
        return buf;
    }

    private static void handle(FriendlyByteBuf msg, Supplier<NetworkEvent.Context> ctx) {
        ResourceLocation id = msg.m_130281_();
        IPacketHandler handler = handlers.get(id);
        if (handler == null) {
            ctx.get().getNetworkManager().m_129507_((Component)new TextComponent("Illegal packet received, terminating connection"));
            throw new IllegalStateException("Invalid packet received, aborting connection");
        }
        KiwiPacket.Direction direction = handler.getDirection();
        if (direction != null) {
            NetworkHooks.validatePacketDirection((NetworkDirection)ctx.get().getDirection(), Optional.of(direction.value), (Connection)ctx.get().getNetworkManager());
        }
        handler.receive($ -> ((NetworkEvent.Context)ctx.get()).enqueueWork($).thenApply($$ -> null), msg, ctx.get().getSender());
        ctx.get().setPacketHandled(true);
    }

    public static synchronized void registerHandler(ResourceLocation id, IPacketHandler handler) {
        handlers.put(id, handler);
    }

    public static void send(PacketDistributor.PacketTarget target, FriendlyByteBuf buf) {
        channel.send(target, (Object)buf);
    }

    public static void sendToServer(FriendlyByteBuf buf) {
        channel.sendToServer((Object)buf);
    }

    public static void sendToPlayer(ServerPlayer player, FriendlyByteBuf buf) {
        Networking.send(PacketDistributor.PLAYER.with(() -> player), buf);
    }

    public static void processClass(String className, String modId) throws Exception {
        Class<?> clazz = Class.forName(className);
        PacketHandler handler = (PacketHandler)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        handler.setModId(modId);
        Networking.registerHandler(handler.id, handler);
        try {
            Field field = clazz.getDeclaredField("I");
            field.set(null, handler);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void lambda$static$5(Supplier player, Packet p) {
        Platform.getServer().m_6846_().m_11314_().forEach(arg_0 -> Networking.lambda$static$4((Supplier)player, p, arg_0));
    }

    private static /* synthetic */ void lambda$static$4(Supplier player, Packet p, ServerPlayer player2) {
        if (player.get() != player2) {
            player2.f_8906_.f_9742_.m_129512_(p);
        }
    }

    static {
        handlers = Maps.newHashMap();
        channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("kiwi", "main")).clientAcceptedVersions(protocol::equals).serverAcceptedVersions(protocol::equals).networkProtocolVersion(() -> protocol).simpleChannel();
        channel.registerMessage(0, FriendlyByteBuf.class, Networking::encode, Networking::decode, Networking::handle);
        ALL_EXCEPT = new PacketDistributor((dist, player) -> arg_0 -> Networking.lambda$static$5((Supplier)player, arg_0), NetworkDirection.PLAY_TO_CLIENT);
    }
}

