/*
 * Decompiled with CFR 0.152.
 */
package me.cominixo.betterf3.config;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.file.FileConfig;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import me.cominixo.betterf3.config.GeneralOptions;
import me.cominixo.betterf3.modules.BaseModule;
import me.cominixo.betterf3.modules.CoordsModule;
import me.cominixo.betterf3.modules.EmptyModule;
import me.cominixo.betterf3.modules.FpsModule;
import me.cominixo.betterf3.utils.DebugLine;
import net.minecraft.network.chat.TextColor;

public final class ModConfigFile {
    private static FileType storedFileType;
    public static final Runnable saveRunnable;

    private ModConfigFile() {
    }

    public static void load(FileType filetype) {
        Config general;
        storedFileType = filetype;
        File file = new File(storedFileType == FileType.JSON ? "config/betterf3.json" : "config/betterf3.toml");
        if (!file.exists()) {
            return;
        }
        FileConfig config = FileConfig.builder((File)file).concurrent().autosave().build();
        config.load();
        Config allModulesConfig = (Config)config.getOrElse("modules", () -> null);
        if (allModulesConfig != null) {
            for (BaseModule module : BaseModule.allModules) {
                String moduleName = module.id;
                Config moduleConfig = (Config)allModulesConfig.getOrElse(moduleName, () -> null);
                if (moduleConfig == null) continue;
                Config lines = (Config)moduleConfig.getOrElse("lines", () -> null);
                if (lines != null) {
                    for (Config.Entry e : lines.entrySet()) {
                        DebugLine line = module.line(e.getKey());
                        if (line == null) continue;
                        line.enabled = (Boolean)e.getValue();
                    }
                }
                if (module.defaultNameColor != null) {
                    module.nameColor = TextColor.m_131266_((int)((Integer)moduleConfig.getOrElse("name_color", (Object)module.defaultNameColor.m_131265_())));
                }
                if (module.defaultValueColor != null) {
                    module.valueColor = TextColor.m_131266_((int)((Integer)moduleConfig.getOrElse("value_color", (Object)module.defaultValueColor.m_131265_())));
                }
                if (module instanceof CoordsModule) {
                    CoordsModule coordsModule = (CoordsModule)module;
                    if (coordsModule.defaultColorX != null) {
                        coordsModule.colorX = TextColor.m_131266_((int)((Integer)moduleConfig.getOrElse("color_x", (Object)coordsModule.defaultColorX.m_131265_())));
                    }
                    if (coordsModule.defaultColorY != null) {
                        coordsModule.colorY = TextColor.m_131266_((int)((Integer)moduleConfig.getOrElse("color_y", (Object)coordsModule.defaultColorY.m_131265_())));
                    }
                    if (coordsModule.defaultColorZ != null) {
                        coordsModule.colorZ = TextColor.m_131266_((int)((Integer)moduleConfig.getOrElse("color_z", (Object)coordsModule.defaultColorZ.m_131265_())));
                    }
                }
                module.enabled = (Boolean)moduleConfig.getOrElse("enabled", (Object)true);
            }
        } else {
            List modulesRightConfig;
            ArrayList<BaseModule> modulesLeft = new ArrayList<BaseModule>();
            ArrayList<BaseModule> modulesRight = new ArrayList<BaseModule>();
            List modulesLeftConfig = (List)config.getOrElse("modules_left", () -> null);
            if (modulesLeftConfig != null) {
                for (Object moduleConfig : modulesLeftConfig) {
                    String moduleName = (String)moduleConfig.getOrElse("name", null);
                    if (moduleName == null) continue;
                    BaseModule baseModule = ModConfigFile.loadModule((Config)moduleConfig);
                    modulesLeft.add(baseModule);
                }
            }
            if (!modulesLeft.isEmpty()) {
                BaseModule.modules = modulesLeft;
            }
            if ((modulesRightConfig = (List)config.getOrElse("modules_right", () -> null)) != null) {
                for (Config moduleConfig : modulesRightConfig) {
                    String moduleName = (String)moduleConfig.getOrElse("name", () -> null);
                    if (moduleName == null) continue;
                    BaseModule baseModule = ModConfigFile.loadModule(moduleConfig);
                    modulesRight.add(baseModule);
                }
            }
            if (!modulesRight.isEmpty()) {
                BaseModule.modulesRight = modulesRight;
            }
        }
        if ((general = (Config)config.getOrElse("general", () -> null)) != null) {
            if (allModulesConfig != null) {
                BaseModule baseModule;
                ArrayList<BaseModule> modulesLeft = new ArrayList<BaseModule>();
                ArrayList<BaseModule> modulesRight = new ArrayList<BaseModule>();
                for (Object s : (ArrayList)general.getOrElse("modules_left_order", new ArrayList())) {
                    baseModule = BaseModule.moduleById(s.toString());
                    if (baseModule == null) continue;
                    modulesLeft.add(baseModule);
                }
                if (!modulesLeft.isEmpty()) {
                    BaseModule.modules = modulesLeft;
                }
                for (Object s : (ArrayList)general.getOrElse("modules_right_order", new ArrayList())) {
                    baseModule = BaseModule.moduleById(s.toString());
                    if (baseModule == null) continue;
                    modulesRight.add(baseModule);
                }
                if (!modulesRight.isEmpty()) {
                    BaseModule.modulesRight = modulesRight;
                }
            }
            GeneralOptions.disableMod = (Boolean)general.getOrElse("disable_mod", (Object)false);
            GeneralOptions.spaceEveryModule = (Boolean)general.getOrElse("space_modules", (Object)false);
            GeneralOptions.shadowText = (Boolean)general.getOrElse("shadow_text", (Object)true);
            GeneralOptions.enableAnimations = (Boolean)general.getOrElse("animations", (Object)true);
            GeneralOptions.animationSpeed = (Double)general.getOrElse("animationSpeed", (Object)1.0);
            GeneralOptions.fontScale = (Double)general.getOrElse("fontScale", (Object)1.0);
            GeneralOptions.backgroundColor = (Integer)general.getOrElse("background_color", (Object)1867534416);
        }
        config.close();
    }

    private static BaseModule loadModule(Config moduleConfig) {
        BaseModule baseModule;
        String moduleName = (String)moduleConfig.getOrElse("name", null);
        try {
            baseModule = (BaseModule)BaseModule.moduleById(moduleName).getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | NullPointerException | InvocationTargetException e) {
            baseModule = new EmptyModule(false);
        }
        Config lines = (Config)moduleConfig.getOrElse("lines", () -> null);
        if (lines != null) {
            for (Config.Entry e : lines.entrySet()) {
                DebugLine line = baseModule.line(e.getKey());
                if (line == null) continue;
                line.enabled = (Boolean)e.getValue();
            }
        }
        if (baseModule.defaultNameColor != null) {
            baseModule.nameColor = TextColor.m_131266_((int)((Integer)moduleConfig.getOrElse("name_color", (Object)baseModule.defaultNameColor.m_131265_())));
        }
        if (baseModule.defaultValueColor != null) {
            baseModule.valueColor = TextColor.m_131266_((int)((Integer)moduleConfig.getOrElse("value_color", (Object)baseModule.defaultValueColor.m_131265_())));
        }
        if (baseModule instanceof CoordsModule) {
            CoordsModule coordsModule = (CoordsModule)baseModule;
            if (coordsModule.defaultColorX != null) {
                coordsModule.colorX = TextColor.m_131266_((int)((Integer)moduleConfig.getOrElse("color_x", (Object)coordsModule.defaultColorX.m_131265_())));
            }
            if (coordsModule.defaultColorY != null) {
                coordsModule.colorY = TextColor.m_131266_((int)((Integer)moduleConfig.getOrElse("color_y", (Object)coordsModule.defaultColorY.m_131265_())));
            }
            if (coordsModule.defaultColorZ != null) {
                coordsModule.colorZ = TextColor.m_131266_((int)((Integer)moduleConfig.getOrElse("color_z", (Object)coordsModule.defaultColorZ.m_131265_())));
            }
        }
        if (baseModule instanceof FpsModule) {
            FpsModule fpsModule = (FpsModule)baseModule;
            if (fpsModule.defaultColorHigh != null) {
                fpsModule.colorHigh = TextColor.m_131266_((int)((Integer)moduleConfig.getOrElse("color_high", (Object)fpsModule.defaultColorHigh.m_131265_())));
            }
            if (fpsModule.defaultColorMed != null) {
                fpsModule.colorMed = TextColor.m_131266_((int)((Integer)moduleConfig.getOrElse("color_med", (Object)fpsModule.defaultColorMed.m_131265_())));
            }
            if (fpsModule.defaultColorLow != null) {
                fpsModule.colorLow = TextColor.m_131266_((int)((Integer)moduleConfig.getOrElse("color_low", (Object)fpsModule.defaultColorLow.m_131265_())));
            }
        }
        if (baseModule instanceof EmptyModule) {
            EmptyModule emptyModule = (EmptyModule)baseModule;
            emptyModule.emptyLines = (Integer)moduleConfig.getOrElse("empty_lines", (Object)1);
        }
        baseModule.enabled = (Boolean)moduleConfig.getOrElse("enabled", (Object)true);
        return baseModule;
    }

    private static Config saveModule(BaseModule module) {
        Config moduleConfig = Config.inMemory();
        Config lines = Config.inMemory();
        for (DebugLine line : module.lines()) {
            String lineId = line.id();
            lines.set(lineId, (Object)line.enabled);
        }
        moduleConfig.set("name", (Object)module.id);
        if (module.nameColor != null) {
            moduleConfig.set("name_color", (Object)module.nameColor.m_131265_());
        }
        if (module.valueColor != null) {
            moduleConfig.set("value_color", (Object)module.valueColor.m_131265_());
        }
        if (module instanceof CoordsModule) {
            CoordsModule coordsModule = (CoordsModule)module;
            if (coordsModule.colorX != null) {
                moduleConfig.set("color_x", (Object)coordsModule.colorX.m_131265_());
            }
            if (coordsModule.colorY != null) {
                moduleConfig.set("color_y", (Object)coordsModule.colorY.m_131265_());
            }
            if (coordsModule.colorZ != null) {
                moduleConfig.set("color_z", (Object)coordsModule.colorZ.m_131265_());
            }
        }
        if (module instanceof FpsModule) {
            FpsModule fpsModule = (FpsModule)module;
            if (fpsModule.colorHigh != null) {
                moduleConfig.set("color_high", (Object)fpsModule.colorHigh.m_131265_());
            }
            if (fpsModule.colorMed != null) {
                moduleConfig.set("color_med", (Object)fpsModule.colorMed.m_131265_());
            }
            if (fpsModule.colorLow != null) {
                moduleConfig.set("color_low", (Object)fpsModule.colorLow.m_131265_());
            }
        }
        if (module instanceof EmptyModule) {
            EmptyModule emptyModule = (EmptyModule)module;
            moduleConfig.set("empty_lines", (Object)emptyModule.emptyLines);
        }
        moduleConfig.set("enabled", (Object)module.enabled);
        moduleConfig.set("lines", (Object)lines);
        return moduleConfig;
    }

    static {
        saveRunnable = () -> {
            FileConfig config = FileConfig.builder((Path)Paths.get(storedFileType == FileType.JSON ? "config/betterf3.json" : "config/betterf3.toml", new String[0])).concurrent().autosave().build();
            Config general = Config.inMemory();
            general.set("disable_mod", (Object)GeneralOptions.disableMod);
            general.set("space_modules", (Object)GeneralOptions.spaceEveryModule);
            general.set("shadow_text", (Object)GeneralOptions.shadowText);
            general.set("animations", (Object)GeneralOptions.enableAnimations);
            general.set("animationSpeed", (Object)GeneralOptions.animationSpeed);
            general.set("fontScale", (Object)GeneralOptions.fontScale);
            general.set("background_color", (Object)GeneralOptions.backgroundColor);
            ArrayList<Config> configsLeft = new ArrayList<Config>();
            for (BaseModule module : BaseModule.modules) {
                Config moduleConfig = ModConfigFile.saveModule(module);
                configsLeft.add(moduleConfig);
            }
            ArrayList<Config> configsRight = new ArrayList<Config>();
            for (BaseModule module : BaseModule.modulesRight) {
                Config moduleConfig = ModConfigFile.saveModule(module);
                configsRight.add(moduleConfig);
            }
            config.set("modules_left", configsLeft);
            config.set("modules_right", configsRight);
            config.set("general", (Object)general);
            config.close();
        };
    }

    public static enum FileType {
        JSON,
        TOML;

    }
}

