/*
 * Decompiled with CFR 0.152.
 */
package team.creative.playerrevive.server;

import java.io.IOException;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.StoredUserEntry;
import net.minecraft.server.players.UserBanListEntry;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.playerrevive.PlayerRevive;
import team.creative.playerrevive.api.CombatTrackerClone;
import team.creative.playerrevive.api.IBleeding;
import team.creative.playerrevive.api.event.PlayerBleedOutEvent;
import team.creative.playerrevive.api.event.PlayerRevivedEvent;
import team.creative.playerrevive.cap.Bleeding;
import team.creative.playerrevive.packet.HelperPacket;
import team.creative.playerrevive.packet.ReviveUpdatePacket;

public class PlayerReviveServer {
    public static boolean isBleeding(Player player) {
        return PlayerReviveServer.getBleeding(player).isBleeding();
    }

    public static int timeLeft(Player player) {
        return PlayerReviveServer.getBleeding(player).timeLeft();
    }

    public static int downedTime(Player player) {
        return PlayerReviveServer.getBleeding(player).downedTime();
    }

    public static IBleeding getBleeding(Player player) {
        return (IBleeding)player.getCapability(PlayerRevive.BLEEDING).orElseGet(Bleeding::new);
    }

    public static void sendUpdatePacket(Player player) {
        ReviveUpdatePacket packet = new ReviveUpdatePacket(player);
        PlayerRevive.NETWORK.sendToClientTracking((CreativePacket)packet, (Entity)player);
        PlayerRevive.NETWORK.sendToClient((CreativePacket)packet, (ServerPlayer)player);
    }

    public static void startBleeding(Player player, DamageSource source) {
        PlayerReviveServer.getBleeding(player).knockOut(player, source);
        PlayerReviveServer.sendUpdatePacket(player);
    }

    private static void resetPlayer(Player player, IBleeding revive) {
        for (Player helper : revive.revivingPlayers()) {
            PlayerRevive.NETWORK.sendToClient((CreativePacket)new HelperPacket(null, false), (ServerPlayer)helper);
        }
        revive.revivingPlayers().clear();
        PlayerReviveServer.sendUpdatePacket(player);
    }

    public static void revive(Player player) {
        IBleeding revive = PlayerReviveServer.getBleeding(player);
        revive.revive();
        if (PlayerRevive.CONFIG.revive.hasRevivedMobEffect) {
            player.m_7292_(PlayerRevive.CONFIG.revive.revivedMobEffect.create());
        }
        PlayerReviveServer.resetPlayer(player, revive);
        player.m_21153_((float)PlayerRevive.CONFIG.revive.healthAfter);
        PlayerRevive.CONFIG.sounds.revived.play((Entity)player, SoundSource.PLAYERS);
        MinecraftForge.EVENT_BUS.post((Event)new PlayerRevivedEvent(player, revive));
        PlayerReviveServer.sendUpdatePacket(player);
    }

    public static void kill(Player player) {
        IBleeding revive = PlayerReviveServer.getBleeding(player);
        MinecraftForge.EVENT_BUS.post((Event)new PlayerBleedOutEvent(player, revive));
        DamageSource source = revive.getSource();
        CombatTrackerClone trackerClone = revive.getTrackerClone();
        if (trackerClone != null) {
            trackerClone.overwriteTracker(player.m_21231_());
        }
        player.m_21153_(0.0f);
        revive.forceBledOut();
        player.m_6667_(source);
        PlayerReviveServer.resetPlayer(player, revive);
        revive.revive();
        PlayerRevive.CONFIG.sounds.death.play((Entity)player, SoundSource.PLAYERS);
        if (PlayerRevive.CONFIG.banPlayerAfterDeath) {
            try {
                player.m_20194_().m_6846_().m_11295_().m_11381_((StoredUserEntry)new UserBanListEntry(player.m_36316_()));
                player.m_20194_().m_6846_().m_11295_().m_11398_();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        PlayerReviveServer.sendUpdatePacket(player);
    }

    public static void removePlayerAsHelper(Player player) {
        for (ServerPlayer member : player.m_20194_().m_6846_().m_11314_()) {
            IBleeding revive = PlayerReviveServer.getBleeding((Player)member);
            revive.revivingPlayers().remove(player);
        }
    }
}

