/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.unvotedandshelved.client.entity.models;

import com.cursedcauldron.unvotedandshelved.client.entity.CopperGolemAnimations;
import com.cursedcauldron.unvotedandshelved.client.entity.models.ModelModifier;
import com.cursedcauldron.unvotedandshelved.entities.CopperGolemEntity;
import com.cursedcauldron.unvotedandshelved.util.Animation;
import com.cursedcauldron.unvotedandshelved.util.AnimationHelper;
import com.cursedcauldron.unvotedandshelved.util.AnimationState;
import com.mojang.math.Vector3f;
import net.minecraft.Util;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CopperGolemModel<T extends CopperGolemEntity>
extends HierarchicalModel<T> {
    private static final Vector3f ANIMATION_PROGRESS = new Vector3f();
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart root;

    public CopperGolemModel(ModelPart root) {
        this.root = root;
        this.body = root.m_171324_("body");
        this.head = this.body.m_171324_("head");
    }

    public static LayerDefinition getLayerDefinition() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition part = mesh.m_171576_();
        PartDefinition body = part.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 21).m_171488_(-6.0f, -4.0f, -4.0f, 12.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-7.0f, -9.0f, -6.0f, 14.0f, 9.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-2.0f, -5.0f, -8.0f, 4.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)0.0f));
        head.m_171599_("antenna", CubeListBuilder.m_171558_().m_171514_(0, 21).m_171488_(-1.0f, -16.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(32, 21).m_171488_(-2.0f, -20.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.0f));
        body.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(36, 33).m_171488_(-2.0f, 0.0f, -2.0f, 5.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.5f, (float)4.0f, (float)0.0f));
        body.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(36, 33).m_171480_().m_171488_(-3.0f, 0.0f, -2.0f, 5.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)3.5f, (float)4.0f, (float)0.0f));
        body.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(0, 37).m_171480_().m_171488_(-1.5f, -1.0f, -1.5f, 4.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)7.5f, (float)-4.0f, (float)0.0f));
        body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(0, 37).m_171488_(-2.5f, -1.0f, -1.5f, 4.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-7.5f, (float)-4.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    public void setupAnim(T entity, float angle, float distance, float animationProgress, float yaw, float pitch) {
        this.m_142109_().m_171331_().forEach(ModelModifier::resetPose);
        long time = Util.m_137550_();
        this.head.f_104204_ = yaw * ((float)Math.PI / 180);
        this.runAnimation(((CopperGolemEntity)((Object)entity)).walkingAnimation, CopperGolemAnimations.walkingAnimation(((CopperGolemEntity)((Object)entity)).getStage()), time);
        this.runAnimation(((CopperGolemEntity)((Object)entity)).headSpinAnimation, CopperGolemAnimations.HEAD_SPIN, time);
        this.runAnimation(((CopperGolemEntity)((Object)entity)).headSpinSlowerAnimation, CopperGolemAnimations.HEAD_SPIN_SLOWER, time);
        this.runAnimation(((CopperGolemEntity)((Object)entity)).headSpinSlowestAnimation, CopperGolemAnimations.HEAD_SPIN_SLOWEST, time);
        this.runAnimation(((CopperGolemEntity)((Object)entity)).buttonAnimation, CopperGolemAnimations.BUTTON_PRESS, time);
        this.runSlowerAnimation(((CopperGolemEntity)((Object)entity)).buttonSlowerAnimation, CopperGolemAnimations.BUTTON_PRESS, time);
        this.runSlowestAnimation(((CopperGolemEntity)((Object)entity)).buttonSlowestAnimation, CopperGolemAnimations.BUTTON_PRESS, time);
        this.runAnimation(((CopperGolemEntity)((Object)entity)).buttonUpAnimation, CopperGolemAnimations.BUTTON_PRESS_UP, time);
        this.runSlowerAnimation(((CopperGolemEntity)((Object)entity)).buttonUpSlowerAnimation, CopperGolemAnimations.BUTTON_PRESS_UP, time);
        this.runSlowestAnimation(((CopperGolemEntity)((Object)entity)).buttonUpSlowestAnimation, CopperGolemAnimations.BUTTON_PRESS_UP, time);
        this.runAnimation(((CopperGolemEntity)((Object)entity)).buttonDownAnimation, CopperGolemAnimations.BUTTON_PRESS_DOWN, time);
        this.runSlowerAnimation(((CopperGolemEntity)((Object)entity)).buttonDownSlowerAnimation, CopperGolemAnimations.BUTTON_PRESS_DOWN, time);
        this.runSlowestAnimation(((CopperGolemEntity)((Object)entity)).buttonDownSlowestAnimation, CopperGolemAnimations.BUTTON_PRESS_DOWN, time);
    }

    private void runAnimation(AnimationState animationState, Animation animation, long time) {
        animationState.run(state -> AnimationHelper.animate(this, animation, time - state.getStartTime(), 1.0f, ANIMATION_PROGRESS));
    }

    private void runSlowerAnimation(AnimationState animationState, Animation animation, long time) {
        animationState.run(state -> AnimationHelper.animate(this, animation, time - state.getStartTime(), 0.75f, ANIMATION_PROGRESS));
    }

    private void runSlowestAnimation(AnimationState animationState, Animation animation, long time) {
        animationState.run(state -> AnimationHelper.animate(this, animation, time - state.getStartTime(), 0.5f, ANIMATION_PROGRESS));
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

