/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.unvotedandshelved.entities;

import com.cursedcauldron.unvotedandshelved.entities.FrozenCopperGolemEntity;
import com.cursedcauldron.unvotedandshelved.entities.ai.copper_golem.CopperGolemBrain;
import com.cursedcauldron.unvotedandshelved.init.USEntityTypes;
import com.cursedcauldron.unvotedandshelved.init.USMemoryModules;
import com.cursedcauldron.unvotedandshelved.init.USPoses;
import com.cursedcauldron.unvotedandshelved.init.USSoundEvents;
import com.cursedcauldron.unvotedandshelved.util.AnimationState;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class CopperGolemEntity
extends AbstractGolem {
    protected static final ImmutableList<SensorType<? extends Sensor<? super CopperGolemEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26814_);
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26377_, (Object)((MemoryModuleType)USMemoryModules.COPPER_BUTTON_COOLDOWN_TICKS.get()), (Object)((MemoryModuleType)USMemoryModules.COPPER_GOLEM_HEADSPIN_TICKS.get()), (Object)((MemoryModuleType)USMemoryModules.COPPER_BUTTON.get()));
    private static final EntityDataAccessor<Integer> STAGE = SynchedEntityData.m_135353_(CopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> WAXED = SynchedEntityData.m_135353_(CopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final AnimationState walkingAnimation = new AnimationState();
    public final AnimationState headSpinAnimation = new AnimationState();
    public final AnimationState headSpinSlowerAnimation = new AnimationState();
    public final AnimationState headSpinSlowestAnimation = new AnimationState();
    public final AnimationState buttonAnimation = new AnimationState();
    public final AnimationState buttonSlowerAnimation = new AnimationState();
    public final AnimationState buttonSlowestAnimation = new AnimationState();
    public final AnimationState buttonUpAnimation = new AnimationState();
    public final AnimationState buttonUpSlowerAnimation = new AnimationState();
    public final AnimationState buttonUpSlowestAnimation = new AnimationState();
    public final AnimationState buttonDownAnimation = new AnimationState();
    public final AnimationState buttonDownSlowerAnimation = new AnimationState();
    public final AnimationState buttonDownSlowestAnimation = new AnimationState();

    public CopperGolemEntity(EntityType<? extends AbstractGolem> type, Level world) {
        super(type, world);
        this.f_19793_ = 1.0f;
    }

    protected Brain.Provider<CopperGolemEntity> m_5490_() {
        return Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected Brain<?> m_8075_(Dynamic<?> dynamic) {
        return CopperGolemBrain.create((Brain<CopperGolemEntity>)this.m_5490_().m_22073_(dynamic));
    }

    public Brain<CopperGolemEntity> m_6274_() {
        return super.m_6274_();
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return entityDimensions.f_20378_ * (this.m_6162_() ? 0.3f : 0.6f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STAGE, (Object)0);
        this.f_19804_.m_135372_(WAXED, (Object)false);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setStage(Stage.BY_ID[tag.m_128451_("Stage")]);
        this.setWaxed(tag.m_128471_("Waxed"));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Stage", this.getStage().getId());
        tag.m_128379_("Waxed", this.isWaxed());
    }

    protected void m_8024_() {
        this.f_19853_.m_46473_().m_6180_("copperGolemBrain");
        this.m_6274_().m_21865_((ServerLevel)this.f_19853_, (LivingEntity)this);
        this.f_19853_.m_46473_().m_7238_();
        this.f_19853_.m_46473_().m_6180_("copperGolemActivityUpdate");
        CopperGolemBrain.updateActivity(this);
        this.f_19853_.m_46473_().m_7238_();
        super.m_8024_();
    }

    public void m_7350_(EntityDataAccessor<?> data) {
        if (f_19806_.equals(data)) {
            this.m_20089_();
            if (this.getStage() == Stage.UNAFFECTED) {
                if (this.isInPose(USPoses.HEAD_SPIN.get())) {
                    this.headSpinAnimation.start();
                } else {
                    this.headSpinAnimation.stop();
                    this.headSpinSlowerAnimation.stop();
                    this.headSpinSlowestAnimation.stop();
                }
                if (this.isInPose(USPoses.PRESS_BUTTON.get())) {
                    this.buttonAnimation.start();
                } else {
                    this.buttonAnimation.stop();
                    this.buttonSlowerAnimation.stop();
                    this.buttonSlowestAnimation.stop();
                }
                if (this.isInPose(USPoses.PRESS_BUTTON_UP.get())) {
                    this.buttonUpAnimation.start();
                } else {
                    this.buttonUpAnimation.stop();
                    this.buttonUpSlowerAnimation.stop();
                    this.buttonUpSlowestAnimation.stop();
                }
                if (this.isInPose(USPoses.PRESS_BUTTON_DOWN.get())) {
                    this.buttonDownAnimation.start();
                } else {
                    this.buttonDownAnimation.stop();
                    this.buttonDownSlowerAnimation.stop();
                    this.buttonDownSlowestAnimation.stop();
                }
            } else if (this.getStage() == Stage.EXPOSED) {
                if (this.isInPose(USPoses.HEAD_SPIN.get())) {
                    this.headSpinSlowerAnimation.start();
                } else {
                    this.headSpinAnimation.stop();
                    this.headSpinSlowerAnimation.stop();
                    this.headSpinSlowestAnimation.stop();
                }
                if (this.isInPose(USPoses.PRESS_BUTTON.get())) {
                    this.buttonSlowerAnimation.start();
                } else {
                    this.buttonAnimation.stop();
                    this.buttonSlowerAnimation.stop();
                    this.buttonSlowestAnimation.stop();
                }
                if (this.isInPose(USPoses.PRESS_BUTTON_UP.get())) {
                    this.buttonUpSlowerAnimation.start();
                } else {
                    this.buttonUpAnimation.stop();
                    this.buttonUpSlowerAnimation.stop();
                    this.buttonUpSlowestAnimation.stop();
                }
                if (this.isInPose(USPoses.PRESS_BUTTON_DOWN.get())) {
                    this.buttonDownSlowerAnimation.start();
                } else {
                    this.buttonDownAnimation.stop();
                    this.buttonDownSlowerAnimation.stop();
                    this.buttonDownSlowestAnimation.stop();
                }
            } else {
                if (this.isInPose(USPoses.HEAD_SPIN.get())) {
                    this.headSpinSlowestAnimation.start();
                } else {
                    this.headSpinAnimation.stop();
                    this.headSpinSlowerAnimation.stop();
                    this.headSpinSlowestAnimation.stop();
                }
                if (this.isInPose(USPoses.PRESS_BUTTON.get())) {
                    this.buttonSlowestAnimation.start();
                } else {
                    this.buttonAnimation.stop();
                    this.buttonSlowerAnimation.stop();
                    this.buttonSlowestAnimation.stop();
                }
                if (this.isInPose(USPoses.PRESS_BUTTON_UP.get())) {
                    this.buttonUpSlowestAnimation.start();
                } else {
                    this.buttonUpAnimation.stop();
                    this.buttonUpSlowerAnimation.stop();
                    this.buttonUpSlowestAnimation.stop();
                }
                if (this.isInPose(USPoses.PRESS_BUTTON_DOWN.get())) {
                    this.buttonDownSlowestAnimation.start();
                } else {
                    this.buttonDownAnimation.stop();
                    this.buttonDownSlowerAnimation.stop();
                    this.buttonDownSlowestAnimation.stop();
                }
            }
        }
        super.m_7350_(data);
    }

    private boolean isInPose(Pose pose) {
        return this.m_20089_() == pose;
    }

    public Stage getStage() {
        return Stage.BY_ID[(Integer)this.f_19804_.m_135370_(STAGE)];
    }

    public void setStage(Stage stage) {
        this.f_19804_.m_135381_(STAGE, (Object)stage.getId());
        switch (stage) {
            case UNAFFECTED: {
                this.m_21051_(Attributes.f_22279_).m_22100_(0.5);
                break;
            }
            case EXPOSED: {
                this.m_21051_(Attributes.f_22279_).m_22100_(0.375);
                break;
            }
            case WEATHERED: {
                this.m_21051_(Attributes.f_22279_).m_22100_(0.25);
            }
        }
    }

    public boolean isWaxed() {
        return (Boolean)this.f_19804_.m_135370_(WAXED);
    }

    public void setWaxed(boolean waxed) {
        this.f_19804_.m_135381_(WAXED, (Object)waxed);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22278_, 1.0);
    }

    private boolean shouldWalk() {
        return this.f_19861_ && this.m_20184_().m_165925_() > 1.0E-6 && !this.m_20072_();
    }

    protected int m_7302_(int i) {
        return i;
    }

    public void m_8119_() {
        if (this.f_19853_.m_5776_()) {
            if (this.shouldWalk()) {
                this.walkingAnimation.startIfNotRunning();
            } else {
                this.walkingAnimation.stop();
            }
        }
        super.m_8119_();
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_(Items.f_42784_) && !this.isWaxed()) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            this.setWaxed(true);
            this.f_19853_.m_5898_(player, 3003, this.m_142538_(), 0);
            this.m_146852_(GameEvent.f_157771_, (Entity)this);
            return InteractionResult.SUCCESS;
        }
        if (stack.m_41720_() instanceof AxeItem) {
            if (this.isWaxed()) {
                this.setWaxed(false);
                this.f_19853_.m_5594_(player, this.m_142538_(), SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.f_19853_.m_5898_(player, 3004, this.m_142538_(), 0);
                this.m_146852_(GameEvent.f_157771_, (Entity)this);
            } else if (this.getStage() != Stage.UNAFFECTED) {
                stack.m_41622_(1, (LivingEntity)player, e -> e.m_21190_(hand));
                this.setStage(Stage.values()[this.getStage().getId() - 1]);
                this.f_19853_.m_5594_(player, this.m_142538_(), SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.f_19853_.m_5898_(player, 3005, this.m_142538_(), 0);
                this.m_146852_(GameEvent.f_157771_, (Entity)this);
            } else {
                return InteractionResult.PASS;
            }
            return InteractionResult.SUCCESS;
        }
        if (this.m_21223_() < this.m_21233_() && stack.m_150930_(Items.f_151052_)) {
            this.m_5634_(5.0f);
            float f1 = 1.4f + (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f;
            this.m_5496_((SoundEvent)USSoundEvents.COPPER_GOLEM_REPAIR.get(), 0.5f, f1);
            this.m_146852_(GameEvent.f_157771_, (Entity)this);
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.m_5776_());
        }
        return super.m_6071_(player, hand);
    }

    public <T extends Mob> void convertToFrozen(EntityType<T> entityType, boolean bl) {
        if (!this.m_146910_()) {
            FrozenCopperGolemEntity mob = (FrozenCopperGolemEntity)entityType.m_20615_(this.f_19853_);
            assert (mob != null);
            mob.m_20359_((Entity)this);
            mob.m_7618_(EntityAnchorArgument.Anchor.EYES, this.m_20154_());
            mob.m_5618_(this.m_146908_());
            mob.m_5616_(this.m_6080_());
            if (this.m_8077_()) {
                mob.m_6593_(this.m_7770_());
            }
            if (this.m_21532_()) {
                mob.m_21530_();
            }
            mob.m_20331_(this.m_20147_());
            if (bl) {
                mob.m_21553_(this.m_21531_());
                for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                    ItemStack itemStack = this.m_6844_(equipmentSlot);
                    if (itemStack.m_41619_()) continue;
                    mob.m_8061_(equipmentSlot, itemStack.m_41777_());
                    mob.m_21409_(equipmentSlot, this.m_21519_(equipmentSlot));
                    itemStack.m_41764_(0);
                }
            }
            this.f_19853_.m_7967_((Entity)mob);
            if (this.m_20159_()) {
                Entity entity = this.m_20202_();
                this.m_8127_();
                if (entity != null) {
                    mob.m_7998_(entity, true);
                }
            }
            this.m_146870_();
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.m_5776_()) {
            float randomChance;
            float chance = this.f_19796_.nextFloat();
            if (chance < 3.4290553E-11f) {
                this.m_5496_((SoundEvent)USSoundEvents.CHINESE_RIP_OFF_WINNIE_THE_POOH.get(), 1.0f, 1.0f);
            }
            if (this.getStage() == Stage.OXIDIZED) {
                this.convertToFrozen((EntityType)USEntityTypes.FROZEN_COPPER_GOLEM.get(), true);
            }
            if (!this.isWaxed() && this.getStage() != Stage.OXIDIZED && (randomChance = this.f_19796_.nextFloat()) < 3.429055E-5f && this.getStage() != Stage.OXIDIZED) {
                this.setStage(Stage.values()[this.getStage().getId() + 1]);
            }
        }
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)USSoundEvents.COPPER_GOLEM_HIT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)USSoundEvents.COPPER_GOLEM_DEATH.get();
    }

    protected SoundEvent getStepSound() {
        return (SoundEvent)USSoundEvents.COPPER_GOLEM_WALK.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(this.getStepSound(), 0.5f, 1.0f);
    }

    public static enum Stage {
        UNAFFECTED(0, "unaffected", (SoundEvent)USSoundEvents.HEAD_SPIN.get()),
        EXPOSED(1, "exposed", (SoundEvent)USSoundEvents.HEAD_SPIN_SLOWER.get()),
        WEATHERED(2, "weathered", (SoundEvent)USSoundEvents.HEAD_SPIN_SLOWEST.get()),
        OXIDIZED(3, "oxidized", null);

        public static final Stage[] BY_ID;
        private final int id;
        private final String name;
        private final SoundEvent soundEvent;

        private Stage(int id, String name, SoundEvent soundEvent) {
            this.id = id;
            this.name = name;
            this.soundEvent = soundEvent;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public SoundEvent getSoundEvent() {
            return this.soundEvent;
        }

        static {
            BY_ID = (Stage[])Arrays.stream(Stage.values()).sorted(Comparator.comparingInt(Stage::getId)).toArray(Stage[]::new);
        }
    }
}

