/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.unvotedandshelved.entities.ai.copper_golem.task;

import com.cursedcauldron.unvotedandshelved.entities.CopperGolemEntity;
import com.cursedcauldron.unvotedandshelved.init.USGameEvents;
import com.cursedcauldron.unvotedandshelved.init.USMemoryModules;
import com.cursedcauldron.unvotedandshelved.init.USPoses;
import com.cursedcauldron.unvotedandshelved.init.USSoundEvents;
import com.cursedcauldron.unvotedandshelved.util.PoseUtil;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class SpinHeadTask
extends Behavior<CopperGolemEntity> {
    private int spinningTicks;

    public SpinHeadTask() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)USMemoryModules.COPPER_GOLEM_HEADSPIN_TICKS.get()), (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel world, CopperGolemEntity entity) {
        return entity.m_6274_().m_21952_(MemoryModuleType.f_26370_).isEmpty() && entity.m_6274_().m_21952_((MemoryModuleType)USMemoryModules.COPPER_GOLEM_HEADSPIN_TICKS.get()).isEmpty();
    }

    protected boolean canStillUse(ServerLevel world, CopperGolemEntity entity, long p_22547_) {
        return entity.m_6274_().m_21952_(MemoryModuleType.f_26370_).isEmpty() && entity.m_6274_().m_21952_((MemoryModuleType)USMemoryModules.COPPER_GOLEM_HEADSPIN_TICKS.get()).isEmpty();
    }

    protected void tick(ServerLevel world, CopperGolemEntity entity, long p_22553_) {
        int timeLimit = 40 + entity.getStage().getId() * 10;
        int playSoundFrame = 20 + entity.getStage().getId() * 5;
        if (this.spinningTicks < timeLimit) {
            ++this.spinningTicks;
        } else {
            entity.m_6274_().m_21879_((MemoryModuleType)USMemoryModules.COPPER_GOLEM_HEADSPIN_TICKS.get(), (Object)UniformInt.m_146622_((int)120, (int)200).m_142270_(world.m_5822_()));
        }
        if (this.spinningTicks == playSoundFrame) {
            entity.m_5496_(switch (entity.getStage()) {
                case CopperGolemEntity.Stage.UNAFFECTED -> (SoundEvent)USSoundEvents.HEAD_SPIN.get();
                case CopperGolemEntity.Stage.EXPOSED -> (SoundEvent)USSoundEvents.HEAD_SPIN_SLOWER.get();
                default -> (SoundEvent)USSoundEvents.HEAD_SPIN_SLOWEST.get();
            }, 1.0f, 1.0f);
            entity.m_146850_(USGameEvents.SPIN_HEAD);
            PoseUtil.setModPose(USPoses.HEAD_SPIN, entity);
        }
    }

    protected void start(ServerLevel level, CopperGolemEntity entity, long p_22542_) {
        entity.m_21573_().m_26573_();
        entity.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        entity.m_6274_().m_21936_(MemoryModuleType.f_26371_);
    }

    protected void stop(ServerLevel serverLevel, CopperGolemEntity livingEntity, long l) {
        if (this.spinningTicks >= 1) {
            this.spinningTicks = 0;
            livingEntity.m_20124_(Pose.STANDING);
        }
    }
}

