/*
 * Decompiled with CFR 0.152.
 */
package com.cursedcauldron.unvotedandshelved.mixin;

import com.cursedcauldron.unvotedandshelved.api.LightningRodAccess;
import com.cursedcauldron.unvotedandshelved.entities.CopperGolemEntity;
import com.cursedcauldron.unvotedandshelved.init.USEntityTypes;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={LightningRodBlock.class})
public class LightningRodBlockMixin
extends Block
implements LightningRodAccess {
    @Nullable
    private BlockPattern copperGolemPattern;
    @Nullable
    private BlockPattern copperGolemDispenserPattern;
    private static final Predicate<BlockState> IS_GOLEM_HEAD_PREDICATE = state -> state != null && (state.m_60713_(Blocks.f_50143_) || state.m_60713_(Blocks.f_50144_));
    private static final Predicate<BlockState> IS_GOLEM_HEAD_TIP_PREDICATE = state -> state != null && state == Blocks.f_152587_.m_49966_().m_61124_((Property)LightningRodBlock.f_52588_, (Comparable)Direction.UP);

    public LightningRodBlockMixin(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (!oldState.m_60713_(state.m_60734_())) {
            this.trySpawnEntity(world, pos);
        }
    }

    public void trySpawnEntity(Level world, BlockPos pos) {
        BlockPattern.BlockPatternMatch result = this.getCopperGolemPattern().m_61184_((LevelReader)world, pos);
        if (result != null) {
            for (int i = 0; i < this.getCopperGolemPattern().m_61202_(); ++i) {
                BlockInWorld cachedBlockPosition = result.m_61229_(0, i, 0);
                world.m_7731_(cachedBlockPosition.m_61176_(), Blocks.f_50016_.m_49966_(), 2);
                world.m_46796_(2001, cachedBlockPosition.m_61176_(), Block.m_49956_((BlockState)cachedBlockPosition.m_61168_()));
            }
            CopperGolemEntity e = (CopperGolemEntity)((EntityType)USEntityTypes.COPPER_GOLEM.get()).m_20615_(world);
            BlockPos cachedBlockPosition = result.m_61229_(0, 2, 0).m_61176_();
            e.m_7678_((double)cachedBlockPosition.m_123341_() + 0.5, (double)cachedBlockPosition.m_123342_() + 0.05, (double)cachedBlockPosition.m_123343_() + 0.5, 0.0f, 0.0f);
            world.m_7967_((Entity)e);
            for (ServerPlayer serverPlayerEntity : world.m_45976_(ServerPlayer.class, e.m_142469_().m_82400_(5.0))) {
                CriteriaTriggers.f_10580_.m_68256_(serverPlayerEntity, (Entity)e);
            }
            for (int j = 0; j < this.getCopperGolemPattern().m_61202_(); ++j) {
                BlockInWorld position = result.m_61229_(0, j, 0);
                world.m_6289_(position.m_61176_(), Blocks.f_50016_);
            }
        }
    }

    private BlockPattern getCopperGolemDispenserPattern() {
        if (this.copperGolemDispenserPattern == null) {
            this.copperGolemDispenserPattern = BlockPatternBuilder.m_61243_().m_61247_(new String[]{" ", "^", "#"}).m_61244_('^', BlockInWorld.m_61169_(IS_GOLEM_HEAD_PREDICATE)).m_61244_('#', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)Blocks.f_152504_))).m_61249_();
        }
        return this.copperGolemDispenserPattern;
    }

    private BlockPattern getCopperGolemPattern() {
        if (this.copperGolemPattern == null) {
            this.copperGolemPattern = BlockPatternBuilder.m_61243_().m_61247_(new String[]{"^", "*", "#"}).m_61244_('^', BlockInWorld.m_61169_(IS_GOLEM_HEAD_TIP_PREDICATE)).m_61244_('*', BlockInWorld.m_61169_(IS_GOLEM_HEAD_PREDICATE)).m_61244_('#', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)Blocks.f_152504_))).m_61249_();
        }
        return this.copperGolemPattern;
    }

    @Override
    public boolean canDispense(LevelReader worldView, BlockPos pos) {
        return this.getCopperGolemDispenserPattern().m_61184_(worldView, pos) != null;
    }
}

