/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.VoiceChatScreenBase;
import de.maxhenkel.voicechat.gui.VoiceChatSettingsScreen;
import de.maxhenkel.voicechat.gui.group.GroupScreen;
import de.maxhenkel.voicechat.gui.group.JoinGroupScreen;
import de.maxhenkel.voicechat.gui.tooltips.DisableTooltipSupplier;
import de.maxhenkel.voicechat.gui.tooltips.HideTooltipSupplier;
import de.maxhenkel.voicechat.gui.tooltips.MuteTooltipSupplier;
import de.maxhenkel.voicechat.gui.tooltips.RecordingTooltipSupplier;
import de.maxhenkel.voicechat.gui.volume.AdjustVolumesScreen;
import de.maxhenkel.voicechat.gui.widgets.ImageButton;
import de.maxhenkel.voicechat.gui.widgets.ToggleImageButton;
import de.maxhenkel.voicechat.intercompatibility.ClientCompatibilityManager;
import de.maxhenkel.voicechat.voice.client.AudioRecorder;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientPlayerStateManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.KeyEvents;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class VoiceChatScreen
extends VoiceChatScreenBase {
    private static final ResourceLocation TEXTURE = new ResourceLocation("voicechat", "textures/gui/gui_voicechat.png");
    private static final ResourceLocation MICROPHONE = new ResourceLocation("voicechat", "textures/icons/microphone_button.png");
    private static final ResourceLocation HIDE = new ResourceLocation("voicechat", "textures/icons/hide_button.png");
    private static final ResourceLocation VOLUMES = new ResourceLocation("voicechat", "textures/icons/adjust_volumes.png");
    private static final ResourceLocation SPEAKER = new ResourceLocation("voicechat", "textures/icons/speaker_button.png");
    private static final ResourceLocation RECORD = new ResourceLocation("voicechat", "textures/icons/record_button.png");
    private static final Component TITLE = new TranslatableComponent("gui.voicechat.voice_chat.title");
    private static final Component SETTINGS = new TranslatableComponent("message.voicechat.settings");
    private static final Component GROUP = new TranslatableComponent("message.voicechat.group");
    private static final Component ADJUST_PLAYER_VOLUMES = new TranslatableComponent("message.voicechat.adjust_volumes");
    private ToggleImageButton mute;
    private ToggleImageButton disable;
    private VoiceChatScreenBase.HoverArea recordingHoverArea;
    private ClientPlayerStateManager stateManager = ClientManager.getPlayerStateManager();

    public VoiceChatScreen() {
        super(TITLE, 195, 76);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        ClientVoicechat client = ClientManager.getClient();
        this.mute = new ToggleImageButton(this.guiLeft + 6, this.guiTop + this.ySize - 6 - 20, MICROPHONE, this.stateManager::isMuted, button -> this.stateManager.setMuted(!this.stateManager.isMuted()), new MuteTooltipSupplier(this, this.stateManager));
        this.m_142416_((GuiEventListener)this.mute);
        this.disable = new ToggleImageButton(this.guiLeft + 6 + 20 + 2, this.guiTop + this.ySize - 6 - 20, SPEAKER, this.stateManager::isDisabled, button -> this.stateManager.setDisabled(!this.stateManager.isDisabled()), new DisableTooltipSupplier(this, this.stateManager));
        this.m_142416_((GuiEventListener)this.disable);
        ImageButton volumes = new ImageButton(this.guiLeft + 6 + 20 + 2 + 20 + 2, this.guiTop + this.ySize - 6 - 20, VOLUMES, button -> this.f_96541_.m_91152_((Screen)new AdjustVolumesScreen()), (button, matrices, mouseX, mouseY) -> this.m_96602_(matrices, ADJUST_PLAYER_VOLUMES, mouseX, mouseY));
        this.m_142416_((GuiEventListener)volumes);
        if (client != null && VoicechatClient.CLIENT_CONFIG.useNatives.get().booleanValue() && (client.getRecorder() != null || client.getConnection() != null && client.getConnection().getData().allowRecording())) {
            ToggleImageButton record = new ToggleImageButton(this.guiLeft + this.xSize - 6 - 20 - 2 - 20, this.guiTop + this.ySize - 6 - 20, RECORD, () -> ClientManager.getClient() != null && ClientManager.getClient().getRecorder() != null, button -> this.toggleRecording(), new RecordingTooltipSupplier(this));
            this.m_142416_((GuiEventListener)record);
        }
        ToggleImageButton hide = new ToggleImageButton(this.guiLeft + this.xSize - 6 - 20, this.guiTop + this.ySize - 6 - 20, HIDE, VoicechatClient.CLIENT_CONFIG.hideIcons::get, button -> VoicechatClient.CLIENT_CONFIG.hideIcons.set(VoicechatClient.CLIENT_CONFIG.hideIcons.get() == false).save(), new HideTooltipSupplier(this));
        this.m_142416_((GuiEventListener)hide);
        Button settings = new Button(this.guiLeft + 6, this.guiTop + 6 + 15, 75, 20, SETTINGS, button -> this.f_96541_.m_91152_((Screen)new VoiceChatSettingsScreen()));
        this.m_142416_((GuiEventListener)settings);
        Button group = new Button(this.guiLeft + this.xSize - 6 - 75 + 1, this.guiTop + 6 + 15, 75, 20, GROUP, button -> {
            if (this.stateManager.isInGroup()) {
                this.f_96541_.m_91152_((Screen)new GroupScreen(this.stateManager.getGroup()));
            } else {
                this.f_96541_.m_91152_((Screen)new JoinGroupScreen());
            }
        });
        this.m_142416_((GuiEventListener)group);
        group.f_93623_ = client != null && client.getConnection() != null && client.getConnection().getData().groupsEnabled();
        this.recordingHoverArea = new VoiceChatScreenBase.HoverArea(72, this.ySize - 6 - 20, this.xSize - 122, 20);
        this.checkButtons();
    }

    public void m_96624_() {
        super.m_96624_();
        this.checkButtons();
    }

    private void checkButtons() {
        this.mute.f_93623_ = MuteTooltipSupplier.canMuteMic();
        this.disable.f_93623_ = this.stateManager.canEnable();
    }

    private void toggleRecording() {
        ClientVoicechat c = ClientManager.getClient();
        if (c == null) {
            return;
        }
        c.toggleRecording();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == ClientCompatibilityManager.INSTANCE.getBoundKeyOf(KeyEvents.KEY_VOICE_CHAT).m_84873_()) {
            this.f_96541_.m_91152_(null);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    @Override
    public void renderBackground(PoseStack poseStack, int mouseX, int mouseY, float delta) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        this.m_93228_(poseStack, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
    }

    @Override
    public void renderForeground(PoseStack poseStack, int mouseX, int mouseY, float delta) {
        int titleWidth = this.f_96547_.m_92852_((FormattedText)TITLE);
        this.f_96547_.m_92877_(poseStack, TITLE.m_7532_(), (float)(this.guiLeft + (this.xSize - titleWidth) / 2), (float)(this.guiTop + 7), 0x404040);
        ClientVoicechat client = ClientManager.getClient();
        if (client != null && client.getRecorder() != null) {
            AudioRecorder recorder = client.getRecorder();
            TextComponent time = new TextComponent(recorder.getDuration());
            MutableComponent mutableComponent = time.m_130940_(ChatFormatting.DARK_RED);
            float f = (float)(this.guiLeft + this.recordingHoverArea.getPosX()) + (float)this.recordingHoverArea.getWidth() / 2.0f - (float)this.f_96547_.m_92852_((FormattedText)time) / 2.0f;
            float f2 = (float)(this.guiTop + this.recordingHoverArea.getPosY()) + (float)this.recordingHoverArea.getHeight() / 2.0f;
            Objects.requireNonNull(this.f_96547_);
            this.f_96547_.m_92889_(poseStack, (Component)mutableComponent, f, f2 - 9.0f / 2.0f, 0);
            if (this.recordingHoverArea.isHovered(this.guiLeft, this.guiTop, mouseX, mouseY)) {
                this.m_96602_(poseStack, (Component)new TranslatableComponent("message.voicechat.storage_size", new Object[]{recorder.getStorage()}), mouseX, mouseY);
            }
        }
    }
}

