/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client;

import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.client.SubTile;
import hunternif.mc.impl.atlas.client.TextureSet;
import hunternif.mc.impl.atlas.client.TextureSetMap;
import hunternif.mc.impl.atlas.client.texture.ITexture;
import hunternif.mc.impl.atlas.core.scaning.TileHeightType;
import hunternif.mc.impl.atlas.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TileTextureMap {
    private static final TileTextureMap INSTANCE = new TileTextureMap();
    public static final ResourceLocation DEFAULT_TEXTURE = AntiqueAtlasMod.id("test");
    private final Map<ResourceLocation, TextureSet> textureMap = new HashMap<ResourceLocation, TextureSet>();

    public static TileTextureMap instance() {
        return INSTANCE;
    }

    public void setTexture(ResourceLocation tileId, TextureSet textureSet) {
        if (tileId == null) {
            return;
        }
        if (textureSet == null) {
            if (this.textureMap.remove(tileId) != null) {
                Log.warn("Removing old texture for %d", tileId);
            }
            return;
        }
        this.textureMap.put(tileId, textureSet);
    }

    public void setAllTextures(ResourceLocation tileId, TextureSet textureSet) {
        this.setTexture(tileId, textureSet);
        for (TileHeightType layer : TileHeightType.values()) {
            this.setTexture(ResourceLocation.m_135820_((String)(tileId + "_" + layer)), textureSet);
        }
    }

    public TextureSet getDefaultTexture() {
        return TextureSetMap.instance().getByName(DEFAULT_TEXTURE);
    }

    public void autoRegister(ResourceLocation id, Biome biome) {
        ResourceLocation texture_set;
        if (biome == null) {
            Log.error("Given biome is null. Cannot autodetect a suitable texture set for that.", new Object[0]);
            return;
        }
        switch (biome.m_47567_()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case SWAMP: {
                ResourceLocation resourceLocation = AntiqueAtlasMod.id("swamp");
                break;
            }
            case OCEAN: 
            case RIVER: {
                ResourceLocation resourceLocation;
                if (biome.m_47530_() == Biome.Precipitation.SNOW) {
                    resourceLocation = AntiqueAtlasMod.id("ice");
                    break;
                }
                resourceLocation = AntiqueAtlasMod.id("water");
                break;
            }
            case BEACH: {
                ResourceLocation resourceLocation = AntiqueAtlasMod.id("shore");
                break;
            }
            case JUNGLE: {
                ResourceLocation resourceLocation = AntiqueAtlasMod.id("jungle");
                break;
            }
            case SAVANNA: {
                ResourceLocation resourceLocation = AntiqueAtlasMod.id("savanna");
                break;
            }
            case MESA: {
                ResourceLocation resourceLocation = AntiqueAtlasMod.id("plateau_mesa");
                break;
            }
            case FOREST: {
                ResourceLocation resourceLocation;
                if (biome.m_47530_() == Biome.Precipitation.SNOW) {
                    resourceLocation = AntiqueAtlasMod.id("snow_pines");
                    break;
                }
                resourceLocation = AntiqueAtlasMod.id("forest");
                break;
            }
            case PLAINS: {
                ResourceLocation resourceLocation;
                if (biome.m_47530_() == Biome.Precipitation.SNOW) {
                    resourceLocation = AntiqueAtlasMod.id("snow");
                    break;
                }
                resourceLocation = AntiqueAtlasMod.id("plains");
                break;
            }
            case ICY: {
                ResourceLocation resourceLocation = AntiqueAtlasMod.id("ice_spikes");
                break;
            }
            case DESERT: {
                ResourceLocation resourceLocation = AntiqueAtlasMod.id("desert");
                break;
            }
            case TAIGA: {
                ResourceLocation resourceLocation = AntiqueAtlasMod.id("snow");
                break;
            }
            case EXTREME_HILLS: {
                ResourceLocation resourceLocation = AntiqueAtlasMod.id("hills");
                break;
            }
            case MOUNTAIN: {
                ResourceLocation resourceLocation = AntiqueAtlasMod.id("mountains");
                break;
            }
            case THEEND: {
                ResourceLocation resourceLocation;
                List features = biome.m_47536_().m_47818_();
                PlacedFeature chorus_plant_feature = (PlacedFeature)BuiltinRegistries.f_194653_.m_7745_(new ResourceLocation("chorus_plant"));
                assert (chorus_plant_feature != null);
                boolean has_chorus_plant = features.stream().anyMatch(entries -> entries.m_203614_().anyMatch(feature -> feature.m_203334_() == chorus_plant_feature));
                if (has_chorus_plant) {
                    resourceLocation = AntiqueAtlasMod.id("end_island_plants");
                    break;
                }
                resourceLocation = AntiqueAtlasMod.id("end_island");
                break;
            }
            case MUSHROOM: {
                ResourceLocation resourceLocation = AntiqueAtlasMod.id("mushroom");
                break;
            }
            case NETHER: {
                ResourceLocation resourceLocation = AntiqueAtlasMod.id("soul_sand_valley");
                break;
            }
            case NONE: {
                ResourceLocation resourceLocation = AntiqueAtlasMod.id("end_void");
                break;
            }
            case UNDERGROUND: {
                Log.warn("Underground biomes aren't supported yet.", new Object[0]);
                ResourceLocation resourceLocation = texture_set = null;
            }
        }
        if (texture_set != null) {
            this.setAllTextures(id, TextureSetMap.instance().getByName(texture_set));
            Log.info("Auto-registered standard texture set for biome %s: %s", id, texture_set);
        } else {
            Log.error("Failed to auto-register a standard texture set for the biome '%s'. This is most likely caused by errors in the TextureSet configurations, check your resource packs first before reporting it as an issue!", id.toString());
            this.setAllTextures(id, this.getDefaultTexture());
        }
    }

    public void checkRegistration(ResourceLocation id, Biome biome) {
        if (!this.isRegistered(id)) {
            this.autoRegister(id, biome);
        }
    }

    private void checkRegistration(ResourceLocation id) {
        if (!this.isRegistered(id)) {
            this.setTexture(id, this.getDefaultTexture());
        }
    }

    public boolean isRegistered(ResourceLocation id) {
        return this.textureMap.containsKey(id);
    }

    public TextureSet getTextureSet(ResourceLocation tile) {
        if (tile == null) {
            return this.getDefaultTexture();
        }
        Biome biome = (Biome)BuiltinRegistries.f_123865_.m_7745_(tile);
        if (biome != null) {
            this.checkRegistration(tile, biome);
        } else {
            this.checkRegistration(tile);
        }
        return this.textureMap.getOrDefault(tile, this.getDefaultTexture());
    }

    public ITexture getTexture(SubTile subTile) {
        return this.getTextureSet(subTile.tile).getTexture(subTile.variationNumber);
    }

    public List<ResourceLocation> getAllTextures() {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        for (Map.Entry<ResourceLocation, TextureSet> entry : this.textureMap.entrySet()) {
            Arrays.stream(entry.getValue().textures).forEach(iTexture -> list.add(iTexture.getTexture()));
        }
        return list;
    }
}

