/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.core.scaning;

import hunternif.mc.impl.atlas.core.TileIdMap;
import hunternif.mc.impl.atlas.core.scaning.ITileDetector;
import hunternif.mc.impl.atlas.core.scaning.TileDetectorBase;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;

public class TileDetectorNether
extends TileDetectorBase
implements ITileDetector {
    private static final int airProbeLevel = 50;
    private static final int lavaSeaLevel = 31;
    private static final int priorityLava = 1;

    @Override
    public ResourceLocation getBiomeID(Level world, ChunkAccess chunk) {
        HashMap<ResourceLocation, Integer> biomeOccurrences = new HashMap<ResourceLocation, Integer>(BuiltinRegistries.f_123865_.m_6566_().size());
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                Biome biome = (Biome)chunk.m_203495_(x, 31, z).m_203334_();
                if (biome.m_47567_() == Biome.BiomeCategory.NETHER) {
                    Block seaLevelBlock = chunk.m_8055_(new BlockPos(x, 31, z)).m_60734_();
                    if (seaLevelBlock == Blocks.f_49991_) {
                        TileDetectorNether.updateOccurrencesMap(biomeOccurrences, TileIdMap.TILE_LAVA, 1);
                        continue;
                    }
                    BlockState airProbeBlock = chunk.m_8055_(new BlockPos(x, 50, z));
                    if (airProbeBlock.m_60795_()) {
                        TileDetectorNether.updateOccurrencesMap(biomeOccurrences, TileIdMap.TILE_LAVA_SHORE, 1);
                        continue;
                    }
                    TileDetectorNether.updateOccurrencesMap(biomeOccurrences, TileDetectorNether.getBiomeIdentifier(world, biome), 2);
                    continue;
                }
                TileDetectorNether.updateOccurrencesMap(biomeOccurrences, TileDetectorNether.getBiomeIdentifier(world, biome), this.priorityForBiome(TileDetectorNether.getBiomeIdentifier(world, biome)));
            }
        }
        if (biomeOccurrences.isEmpty()) {
            return null;
        }
        Map.Entry meanBiome = Collections.max(biomeOccurrences.entrySet(), Comparator.comparingInt(Map.Entry::getValue));
        return (ResourceLocation)meanBiome.getKey();
    }

    @Override
    public int getScanRadius() {
        return Math.min(super.getScanRadius(), 6);
    }
}

