/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.network.packet.c2s.play;

import dev.architectury.networking.NetworkManager;
import hunternif.mc.api.AtlasAPI;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.network.packet.c2s.C2SPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class PutMarkerC2SPacket
extends C2SPacket {
    public static final ResourceLocation ID = AntiqueAtlasMod.id("packet", "c2s", "marker", "put");

    public PutMarkerC2SPacket(int atlasID, ResourceLocation markerType, int x, int z, boolean visibleBeforeDiscovery, Component label) {
        this.m_130130_(atlasID);
        this.m_130085_(markerType);
        this.m_130130_(x);
        this.m_130130_(z);
        this.writeBoolean(visibleBeforeDiscovery);
        this.m_130083_(label);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    public static void apply(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        int atlasID = buf.m_130242_();
        ResourceLocation markerType = buf.m_130281_();
        int x = buf.m_130242_();
        int z = buf.m_130242_();
        boolean visibleBeforeDiscovery = buf.readBoolean();
        Component label = buf.m_130238_();
        context.queue(() -> {
            if (!AtlasAPI.getPlayerAtlases(context.getPlayer()).contains(atlasID)) {
                AntiqueAtlasMod.LOG.warn("Player {} attempted to put marker into someone else's Atlas #{}}", (Object)context.getPlayer().m_7755_(), (Object)atlasID);
                return;
            }
            AtlasAPI.getMarkerAPI().putMarker(context.getPlayer().m_20193_(), visibleBeforeDiscovery, atlasID, markerType, label, x, z);
        });
    }
}

