/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.client.event;

import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.valhelsia.valhelsia_core.client.model.BeanieModel;
import net.valhelsia.valhelsia_core.client.model.CauldronBackpackModel;
import net.valhelsia.valhelsia_core.client.model.ScarfModel;
import net.valhelsia.valhelsia_core.client.model.ValhelsiaCapeModel;
import net.valhelsia.valhelsia_core.client.model.WitchHatModel;
import net.valhelsia.valhelsia_core.client.model.WitchsBroomModel;
import net.valhelsia.valhelsia_core.client.model.WitchsWandModel;
import net.valhelsia.valhelsia_core.client.renderer.CosmeticsBackLayer;
import net.valhelsia.valhelsia_core.client.renderer.CosmeticsFaceLayer;
import net.valhelsia.valhelsia_core.client.renderer.CosmeticsHandLayer;
import net.valhelsia.valhelsia_core.client.renderer.CosmeticsHatLayer;
import net.valhelsia.valhelsia_core.client.renderer.CosmeticsSpecialLayer;
import net.valhelsia.valhelsia_core.client.renderer.ValhelsiaCapeLayer;
import net.valhelsia.valhelsia_core.core.init.ValhelsiaBlockEntities;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class EntityRendererEvents {
    public static EntityModelSet modelSet;

    @SubscribeEvent
    public static void onRegisterLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ValhelsiaCapeModel.VALHELSIA_CAPE, ValhelsiaCapeModel::createLayer);
        event.registerLayerDefinition(WitchHatModel.LAYER_LOCATION, WitchHatModel::createBodyLayer);
        event.registerLayerDefinition(WitchsWandModel.LAYER_LOCATION, WitchsWandModel::createBodyLayer);
        event.registerLayerDefinition(WitchsBroomModel.LAYER_LOCATION, WitchsBroomModel::createBodyLayer);
        event.registerLayerDefinition(CauldronBackpackModel.LAYER_LOCATION, CauldronBackpackModel::createBodyLayer);
        event.registerLayerDefinition(BeanieModel.LAYER_LOCATION, BeanieModel::createBodyLayer);
        event.registerLayerDefinition(ScarfModel.LAYER_LOCATION, ScarfModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void onAddLayers(EntityRenderersEvent.AddLayers event) {
        EntityRendererEvents.addLayerToPlayerSkin(event, "default");
        EntityRendererEvents.addLayerToPlayerSkin(event, "slim");
        modelSet = event.getEntityModels();
    }

    private static void addLayerToPlayerSkin(EntityRenderersEvent.AddLayers event, String skinName) {
        LivingEntityRenderer render = event.getSkin(skinName);
        if (render instanceof LivingEntityRenderer) {
            LivingEntityRenderer livingRenderer = render;
            livingRenderer.m_115326_(new ValhelsiaCapeLayer(livingRenderer, event.getEntityModels()));
            livingRenderer.m_115326_(new CosmeticsHatLayer(livingRenderer, event.getEntityModels()));
            livingRenderer.m_115326_(new CosmeticsHandLayer(livingRenderer, event.getEntityModels()));
            livingRenderer.m_115326_(new CosmeticsBackLayer(livingRenderer, event.getEntityModels()));
            livingRenderer.m_115326_(new CosmeticsFaceLayer(livingRenderer, event.getEntityModels()));
            livingRenderer.m_115326_(new CosmeticsSpecialLayer(livingRenderer, event.getEntityModels()));
        }
    }

    @SubscribeEvent
    public static void onRegisterRenders(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)ValhelsiaBlockEntities.SIGN.get(), SignRenderer::new);
    }
}

