/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.core.mixin.client;

import java.util.List;
import java.util.UUID;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.valhelsia.valhelsia_core.client.cosmetics.Cosmetic;
import net.valhelsia.valhelsia_core.client.cosmetics.CosmeticsCategory;
import net.valhelsia.valhelsia_core.client.cosmetics.CosmeticsManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ElytraLayer.class})
public class ElytraLayerMixin<T extends LivingEntity> {
    @Inject(at={@At(value="HEAD")}, method={"getElytraTexture"}, remap=false, cancellable=true)
    private void valhelsia_getElytraTexture(ItemStack stack, T entity, CallbackInfoReturnable<ResourceLocation> cir) {
        ResourceLocation texture;
        CosmeticsManager cosmeticsManager = CosmeticsManager.getInstance();
        UUID uuid = entity.m_142081_();
        List<Cosmetic> cosmetics = cosmeticsManager.getCosmeticsForPlayer(uuid, CosmeticsCategory.BACK);
        Cosmetic activeCosmetic = cosmeticsManager.getActiveCosmeticForPlayer(uuid, CosmeticsCategory.BACK);
        if (activeCosmetic != null && activeCosmetic.getName().contains("cape") && cosmetics.contains(activeCosmetic) && (texture = cosmeticsManager.getCosmeticTexture(new Cosmetic(activeCosmetic.getName().substring(0, activeCosmetic.getName().length() - 4).concat("elytra"), CosmeticsCategory.BACK))) != null) {
            cir.setReturnValue((Object)texture);
        }
    }
}

