/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.creeperoverhaul.common.entity.base;

import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.Animation;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import tech.thatgravyboat.creeperoverhaul.common.entity.base.CreeperType;
import tech.thatgravyboat.creeperoverhaul.common.entity.goals.CreeperAvoidEntitiesGoal;
import tech.thatgravyboat.creeperoverhaul.common.entity.goals.CreeperMeleeAttackGoal;
import tech.thatgravyboat.creeperoverhaul.common.entity.goals.CreeperSwellGoal;
import tech.thatgravyboat.creeperoverhaul.common.registry.ModItems;

public class BaseCreeper
extends Monster
implements PowerableMob,
IAnimatable {
    private static final EntityDataAccessor<Integer> DATA_SWELL_DIRECTION = SynchedEntityData.m_135353_(BaseCreeper.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_IS_POWERED = SynchedEntityData.m_135353_(BaseCreeper.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_IS_IGNITED = SynchedEntityData.m_135353_(BaseCreeper.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_IS_ATTACKING = SynchedEntityData.m_135353_(BaseCreeper.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_IS_SHEARED = SynchedEntityData.m_135353_(BaseCreeper.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int explosionRadius = 3;
    private int maxSwell = 30;
    private int swell;
    private int oldSwell;
    private int droppedSkulls;
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private final CreeperType type;

    public BaseCreeper(EntityType<? extends BaseCreeper> entityType, Level level, CreeperType type) {
        super(entityType, level);
        this.type = type;
        if (!level.f_46443_) {
            this.type.entities().forEach(e -> this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, e, true)));
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new CreeperSwellGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new CreeperAvoidEntitiesGoal(this, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(4, (Goal)new CreeperMeleeAttackGoal(this, 1.0, false));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.registerNearestAttackableTargetGoal();
        if (this.shouldRevenge()) {
            this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        }
    }

    protected void registerNearestAttackableTargetGoal() {
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected boolean shouldRevenge() {
        return true;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IS_POWERED, (Object)false);
        this.f_19804_.m_135372_(DATA_SWELL_DIRECTION, (Object)-1);
        this.f_19804_.m_135372_(DATA_IS_IGNITED, (Object)false);
        this.f_19804_.m_135372_(DATA_IS_ATTACKING, (Object)false);
        this.f_19804_.m_135372_(DATA_IS_SHEARED, (Object)false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Creeper.m_32318_().m_22268_((Attribute)ForgeMod.REACH_DISTANCE.get(), 0.0);
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        if (((Boolean)this.f_19804_.m_135370_(DATA_IS_POWERED)).booleanValue()) {
            compound.m_128379_("Powered", true);
        }
        compound.m_128376_("Fuse", (short)this.maxSwell);
        compound.m_128344_("ExplosionRadius", (byte)this.explosionRadius);
        if (((Boolean)this.f_19804_.m_135370_(DATA_IS_IGNITED)).booleanValue()) {
            compound.m_128379_("ignited", true);
        }
        if (((Boolean)this.f_19804_.m_135370_(DATA_IS_SHEARED)).booleanValue()) {
            compound.m_128379_("Sheared", true);
        }
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(DATA_IS_POWERED, (Object)compound.m_128471_("Powered"));
        if (compound.m_128425_("Fuse", 99)) {
            this.maxSwell = compound.m_128448_("Fuse");
        }
        if (compound.m_128425_("ExplosionRadius", 99)) {
            this.explosionRadius = compound.m_128445_("ExplosionRadius");
        }
        this.f_19804_.m_135381_(DATA_IS_IGNITED, (Object)compound.m_128471_("ignited"));
        this.f_19804_.m_135381_(DATA_IS_SHEARED, (Object)compound.m_128471_("Sheared"));
    }

    @NotNull
    protected InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.type.melee() == 0 && itemstack.m_150930_(Items.f_42409_)) {
            this.f_19853_.m_5594_(player, this.m_142538_(), SoundEvents.f_11942_, this.m_5720_(), 1.0f, this.f_19796_.nextFloat() * 0.4f + 0.8f);
            if (!this.f_19853_.f_46443_) {
                this.f_19804_.m_135381_(DATA_IS_IGNITED, (Object)true);
                itemstack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        if (this.type.shearable() && !this.isSheared() && itemstack.m_150930_(Items.f_42574_)) {
            this.f_19853_.m_5594_(player, this.m_142538_(), SoundEvents.f_12480_, this.m_5720_(), 1.0f, this.f_19796_.nextFloat() * 0.4f + 0.8f);
            if (!this.f_19853_.f_46443_) {
                this.f_19804_.m_135381_(DATA_IS_SHEARED, (Object)true);
                itemstack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                this.m_5552_(new ItemStack((ItemLike)ModItems.TINY_CACTUS.get()), 1.7f);
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public boolean isSheared() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_SHEARED);
    }

    public void m_8119_() {
        if (this.m_6084_()) {
            if (this.getSwellDirection() > 0 && this.swell == 0) {
                this.m_5496_(SoundEvents.f_11837_, 1.0f, 0.5f);
                this.m_146850_(GameEvent.f_157776_);
            }
            this.updateSwell(Math.max(this.swell + this.getSwellDirection(), 0));
            if (this.swell >= this.maxSwell) {
                this.updateSwell(this.maxSwell);
                this.explode();
            }
        }
        super.m_8119_();
    }

    public void explode() {
        if (!this.f_19853_.f_46443_) {
            Explosion.BlockInteraction interaction = ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this) ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE;
            this.f_20890_ = true;
            Explosion explosion = this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), (float)this.explosionRadius * (this.m_7090_() ? 2.0f : 1.0f), interaction);
            this.m_146870_();
            if (!this.type.inflictingPotions().isEmpty()) {
                explosion.m_46078_().keySet().forEach(player -> {
                    List<MobEffectInstance> inflictingPotions = this.type.inflictingPotions().stream().map(MobEffectInstance::new).toList();
                    inflictingPotions.forEach(arg_0 -> ((Player)player).m_7292_(arg_0));
                });
            }
            if (this.type.dirtReplacement() != null) {
                Block replacement = this.type.dirtReplacement().get();
                explosion.m_46081_().stream().map(BlockPos::m_7495_).filter(pos -> {
                    BlockState state = this.f_19853_.m_8055_(pos);
                    return (state.m_60713_(Blocks.f_50440_) || state.m_60713_(Blocks.f_50493_)) && this.f_19796_.nextInt(3) == 0;
                }).forEach(pos -> this.f_19853_.m_7731_(pos, replacement.m_49966_(), 3));
            }
            List<MobEffectInstance> collection = this.m_21220_().stream().map(MobEffectInstance::new).toList();
            this.summonCloudWithEffects(collection);
            this.summonCloudWithEffects(this.getCreeperType().potionsWhenDead().stream().map(MobEffectInstance::new).toList());
        }
    }

    private void summonCloudWithEffects(Collection<MobEffectInstance> effects) {
        if (!effects.isEmpty()) {
            AreaEffectCloud cloud = new AreaEffectCloud(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
            cloud.m_19712_(2.5f);
            cloud.m_19732_(-0.5f);
            cloud.m_19740_(10);
            cloud.m_19734_(cloud.m_19748_() / 2);
            cloud.m_19738_(-cloud.m_19743_() / (float)cloud.m_19748_());
            effects.forEach(arg_0 -> ((AreaEffectCloud)cloud).m_19716_(arg_0));
            this.f_19853_.m_7967_((Entity)cloud);
        }
    }

    public void m_8038_(@NotNull ServerLevel level, @NotNull LightningBolt bolt) {
        super.m_8038_(level, bolt);
        this.f_19804_.m_135381_(DATA_IS_POWERED, (Object)true);
    }

    public double m_21133_(@NotNull Attribute attribute) {
        double val = super.m_21133_(attribute);
        return attribute.equals(Attributes.f_22281_) && this.m_7090_() ? val * 10.0 : val;
    }

    public boolean m_7327_(@NotNull Entity entity) {
        return this.type.melee() == 0 || super.m_7327_(entity);
    }

    public CreeperType getCreeperType() {
        return this.type;
    }

    public float m_6113_() {
        if (!this.m_7090_()) {
            return super.m_6113_();
        }
        return super.m_6113_() * 1.5f;
    }

    public boolean isAfraidOf(Entity entity) {
        return this.type.entitiesAfraidOf().contains(entity.m_6095_());
    }

    public void setAttack(boolean attack) {
        this.f_19804_.m_135381_(DATA_IS_ATTACKING, (Object)attack);
    }

    public boolean m_7090_() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_POWERED);
    }

    public boolean activated() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_IGNITED);
    }

    public int getSwellDirection() {
        return (Integer)this.f_19804_.m_135370_(DATA_SWELL_DIRECTION);
    }

    public void changeSwellDirection(int direction) {
        this.f_19804_.m_135381_(DATA_SWELL_DIRECTION, (Object)direction);
    }

    public void updateSwell(int amount) {
        this.oldSwell = this.swell;
        this.swell = amount;
    }

    public float getSwelling(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.oldSwell, (float)this.swell) / (float)(this.maxSwell - 2);
    }

    public boolean canSwell() {
        return this.type.melee() == 0;
    }

    public boolean canDropMobsSkull() {
        return this.m_7090_() && this.droppedSkulls < 1;
    }

    public void increaseDroppedSkulls() {
        ++this.droppedSkulls;
    }

    private <E extends IAnimatable> PlayState idle(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.creeper.idle", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState action(AnimationEvent<E> event) {
        Animation animation = event.getController().getCurrentAnimation();
        if (((Boolean)this.f_19804_.m_135370_(DATA_IS_ATTACKING)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.creeper.attack", Boolean.valueOf(false)));
            return PlayState.CONTINUE;
        }
        if (animation != null && animation.animationName.equals("animation.creeper.attack") && event.getController().getAnimationState().equals((Object)AnimationState.Running)) {
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.creeper.walk", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        event.getController().markNeedsReload();
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "action_controller", 3.0f, this::action));
        data.addAnimationController(new AnimationController((IAnimatable)this, "idle_controller", 0.0f, this::idle));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

