/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.client.model;

import com.starfish_studios.naturalist.entity.Rhino;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

@OnlyIn(value=Dist.CLIENT)
public class RhinoModel
extends AnimatedGeoModel<Rhino> {
    public ResourceLocation getModelLocation(Rhino rhino) {
        return new ResourceLocation("naturalist", "geo/rhino.geo.json");
    }

    public ResourceLocation getTextureLocation(Rhino rhino) {
        return new ResourceLocation("naturalist", "textures/entity/rhino.png");
    }

    public ResourceLocation getAnimationFileLocation(Rhino rhino) {
        return new ResourceLocation("naturalist", "animations/rhino.animation.json");
    }

    public void setLivingAnimations(Rhino rhino, Integer uniqueID, @Nullable AnimationEvent customPredicate) {
        super.setLivingAnimations((IAnimatable)rhino, uniqueID, customPredicate);
        if (customPredicate == null) {
            return;
        }
        List extraDataOfType = customPredicate.getExtraDataOfType(EntityModelData.class);
        IBone head = this.getAnimationProcessor().getBone("head");
        IBone bigHorn = this.getAnimationProcessor().getBone("big_horn");
        IBone smallHorn = this.getAnimationProcessor().getBone("small_horn");
        IBone babyHorn = this.getAnimationProcessor().getBone("baby_horn");
        if (rhino.m_6162_()) {
            head.setScaleX(1.75f);
            head.setScaleY(1.75f);
            head.setScaleZ(1.75f);
        }
        if (!rhino.m_20142_()) {
            head.setRotationY(((EntityModelData)extraDataOfType.get((int)0)).netHeadYaw * ((float)Math.PI / 180));
        }
        bigHorn.setHidden(rhino.m_6162_());
        smallHorn.setHidden(rhino.m_6162_());
        babyHorn.setHidden(!rhino.m_6162_());
    }
}

