/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.entity;

import com.starfish_studios.naturalist.block.ChrysalisBlock;
import com.starfish_studios.naturalist.entity.ClimbingAnimal;
import com.starfish_studios.naturalist.registry.NaturalistBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class Caterpillar
extends ClimbingAnimal
implements IAnimatable {
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public Caterpillar(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 5.0).m_22268_(Attributes.f_22279_, (double)0.1f);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new CocoonGoal(this, 1.0, 5, 2));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @javax.annotation.Nullable SpawnGroupData pSpawnData, @javax.annotation.Nullable CompoundTag pDataTag) {
        this.m_146762_(0);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        return null;
    }

    @Override
    protected float getClimbSpeedMultiplier() {
        return 0.5f;
    }

    public boolean m_6898_(ItemStack pStack) {
        return this.m_6162_() && pStack.m_204117_(ItemTags.f_13149_);
    }

    public float m_6134_() {
        return 1.0f;
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    protected void m_7840_(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (!(event.getLimbSwingAmount() > -0.05f) || !(event.getLimbSwingAmount() < 0.05f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("caterpillar.move", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        event.getController().markNeedsReload();
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.setResetSpeedInTicks(5.0);
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    private static class CocoonGoal
    extends MoveToBlockGoal {
        private final Caterpillar caterpillar;
        private Direction facing = Direction.NORTH;
        private BlockPos logPos = BlockPos.f_121853_;

        public CocoonGoal(Caterpillar pMob, double pSpeedModifier, int pSearchRange, int pVerticalSearchRange) {
            super((PathfinderMob)pMob, pSpeedModifier, pSearchRange, pVerticalSearchRange);
            this.caterpillar = pMob;
        }

        public boolean m_8036_() {
            return !this.caterpillar.m_6162_() && super.m_8036_();
        }

        protected boolean m_6465_(LevelReader pLevel, BlockPos pPos) {
            if (pLevel.m_8055_(pPos).m_60795_()) {
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    if (!pLevel.m_8055_(pPos.m_142300_(direction)).m_204336_(BlockTags.f_13106_) || !pLevel.m_8055_(pPos.m_142300_(direction).m_7495_()).m_204336_(BlockTags.f_13106_)) continue;
                    this.facing = direction;
                    this.logPos = pPos.m_142300_(direction);
                    return true;
                }
                return false;
            }
            return false;
        }

        public void m_8037_() {
            BlockPos targetPos = this.m_6669_();
            if (!targetPos.m_203195_((Position)this.caterpillar.m_20182_(), this.m_8052_())) {
                ++this.f_25601_;
                if (this.m_8064_()) {
                    this.caterpillar.m_21573_().m_26519_((double)targetPos.m_123341_() + 0.5, (double)targetPos.m_123342_(), (double)targetPos.m_123343_() + 0.5, this.f_25599_);
                }
            } else {
                --this.f_25601_;
            }
            this.caterpillar.m_21563_().m_24950_((double)this.logPos.m_123341_() + 0.5, (double)(this.logPos.m_123342_() + 1), (double)this.logPos.m_123343_() + 0.5, 10.0f, (float)this.caterpillar.m_8132_());
            Level level = this.caterpillar.f_19853_;
            if (this.m_6465_((LevelReader)level, this.caterpillar.m_142538_())) {
                if (!level.f_46443_) {
                    ((ServerLevel)level).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, NaturalistBlocks.CHRYSALIS.get().m_49966_()), this.caterpillar.m_20185_(), this.caterpillar.m_20186_(), this.caterpillar.m_20189_(), 50, (double)(this.caterpillar.m_20205_() / 4.0f), (double)(this.caterpillar.m_20206_() / 4.0f), (double)(this.caterpillar.m_20205_() / 4.0f), 0.05);
                }
                this.caterpillar.m_146870_();
                level.m_46597_(this.caterpillar.m_142538_(), (BlockState)NaturalistBlocks.CHRYSALIS.get().m_49966_().m_61124_((Property)ChrysalisBlock.f_54117_, (Comparable)this.facing));
                level.m_5594_(null, this.caterpillar.m_142538_(), SoundEvents.f_11991_, SoundSource.BLOCKS, 0.7f, 0.9f + level.f_46441_.nextFloat() * 0.2f);
            }
        }

        protected void m_25624_() {
            this.caterpillar.m_21573_().m_26519_((double)this.logPos.m_123341_() + 0.5, (double)this.logPos.m_123342_() + 1.0, (double)this.logPos.m_123343_() + 0.5, this.f_25599_);
        }

        protected BlockPos m_6669_() {
            return this.logPos.m_7494_();
        }
    }
}

