/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.entity;

import com.starfish_studios.naturalist.registry.NaturalistEntityTypes;
import com.starfish_studios.naturalist.registry.NaturalistSoundEvents;
import com.starfish_studios.naturalist.registry.NaturalistTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class Giraffe
extends Animal
implements IAnimatable {
    private static final Ingredient FOOD_ITEMS = Ingredient.m_204132_(NaturalistTags.ItemTags.GIRAFFE_FOOD_ITEMS);
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private static final EntityDataAccessor<Integer> TAME_TICKS = SynchedEntityData.m_135353_(Giraffe.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public Giraffe(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.f_19793_ = 1.0f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 24.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.5));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.7));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public boolean m_6898_(ItemStack stack) {
        return FOOD_ITEMS.test(stack);
    }

    public void m_8024_() {
        if (this.m_21566_().m_24995_()) {
            this.m_6858_(this.m_21566_().m_24999_() >= 1.5);
        } else {
            this.m_6858_(false);
        }
        super.m_8024_();
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (AgeableMob)NaturalistEntityTypes.GIRAFFE.get().m_20615_((Level)serverLevel);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TAME_TICKS, (Object)0);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("TameTicks", this.getTameTicks());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setTameTicks(pCompound.m_128451_("TameTicks"));
    }

    public void setTameTicks(int ticks) {
        this.f_19804_.m_135381_(TAME_TICKS, (Object)ticks);
    }

    public int getTameTicks() {
        return (Integer)this.f_19804_.m_135370_(TAME_TICKS);
    }

    public boolean isTame() {
        return this.getTameTicks() > 0;
    }

    public boolean m_6094_() {
        return !this.m_20160_();
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.m_5776_() && this.getPrimaryPassenger() != null) {
            this.setTameTicks(Math.max(0, this.getTameTicks() - 1));
            if (!this.isTame()) {
                this.getPrimaryPassenger().m_8127_();
                this.m_5496_(SoundEvents.f_12093_, this.m_6121_(), this.m_6100_());
            }
        }
    }

    protected void doPlayerRide(Player player) {
        if (!this.f_19853_.f_46443_) {
            player.m_146922_(this.m_146908_());
            player.m_146926_(this.m_146909_());
            player.m_20329_((Entity)this);
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!this.m_6162_() && this.m_20160_()) {
            return super.m_6071_(player, hand);
        }
        if (!stack.m_41619_()) {
            if (this.m_6898_(stack)) {
                if (this.handleEating(player, stack)) {
                    if (!player.m_150110_().f_35937_) {
                        stack.m_41774_(1);
                    }
                } else {
                    this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12093_, this.m_5720_(), 1.0f, 1.0f + (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f);
                }
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        if (this.m_6162_()) {
            return super.m_6071_(player, hand);
        }
        if (this.isTame()) {
            this.doPlayerRide(player);
        }
        return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
    }

    protected boolean handleEating(Player player, ItemStack stack) {
        boolean shouldEat = false;
        float foodHealAmount = 0.0f;
        int ageUpAmount = 0;
        if (stack.m_150930_(Items.f_42129_)) {
            foodHealAmount = 20.0f;
            ageUpAmount = 180;
            if (!this.f_19853_.m_5776_() && this.m_146764_() == 0 && !this.m_27593_()) {
                shouldEat = true;
                this.m_27595_(player);
            }
        } else if (FOOD_ITEMS.test(stack)) {
            foodHealAmount = 2.0f;
            ageUpAmount = 20;
            if (!this.f_19853_.m_5776_()) {
                if (this.getTameTicks() > 0) {
                    this.f_19853_.m_7605_((Entity)this, (byte)6);
                } else {
                    shouldEat = true;
                    this.setTameTicks(600);
                    this.f_19853_.m_7605_((Entity)this, (byte)7);
                }
            }
        }
        if (this.m_21223_() < this.m_21233_() && foodHealAmount > 0.0f) {
            this.m_5634_(foodHealAmount);
            shouldEat = true;
        }
        if (this.m_6162_() && ageUpAmount > 0) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0.0, 0.0, 0.0);
            if (!this.f_19853_.f_46443_) {
                this.m_146758_(ageUpAmount);
            }
            shouldEat = true;
        }
        if (shouldEat) {
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11976_, this.m_5720_(), 1.0f, 1.0f + (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f);
            this.m_6674_(InteractionHand.MAIN_HAND);
            this.m_146850_(GameEvent.f_157806_);
        }
        return shouldEat;
    }

    public void m_7023_(Vec3 travelVector) {
        if (!this.m_6084_()) {
            return;
        }
        LivingEntity livingEntity = this.getPrimaryPassenger();
        if (!this.m_20160_() || livingEntity == null) {
            this.f_20887_ = 0.02f;
            super.m_7023_(travelVector);
            return;
        }
        this.m_146922_(livingEntity.m_146908_());
        this.f_19859_ = this.m_146908_();
        this.m_146926_(livingEntity.m_146909_() * 0.5f);
        this.m_19915_(this.m_146908_(), this.m_146909_());
        this.f_20885_ = this.f_20883_ = this.m_146908_();
        float f = livingEntity.f_20900_ * 0.5f;
        float g = livingEntity.f_20902_;
        this.f_20887_ = this.m_6113_() * 0.1f;
        if (this.m_6109_()) {
            this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
            super.m_7023_(new Vec3((double)f, travelVector.f_82480_, (double)g));
        } else if (livingEntity instanceof Player) {
            this.m_20256_(Vec3.f_82478_);
        }
        this.m_21043_((LivingEntity)this, false);
        this.m_146872_();
    }

    public boolean m_5807_() {
        return this.getPrimaryPassenger() != null;
    }

    public boolean m_7848_(Animal otherAnimal) {
        return !this.m_20160_() && !this.m_20159_() && !this.m_6162_() && super.m_7848_(otherAnimal);
    }

    protected boolean m_6107_() {
        return super.m_6107_() && this.m_20160_();
    }

    protected void spawnTamingParticles(boolean tamed) {
        SimpleParticleType particleOptions = tamed ? ParticleTypes.f_123750_ : ParticleTypes.f_123762_;
        for (int i = 0; i < 7; ++i) {
            double d = this.f_19796_.nextGaussian() * 0.02;
            double e = this.f_19796_.nextGaussian() * 0.02;
            double f = this.f_19796_.nextGaussian() * 0.02;
            this.f_19853_.m_7106_((ParticleOptions)particleOptions, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d, e, f);
        }
    }

    public void m_7822_(byte id) {
        if (id == 7) {
            this.spawnTamingParticles(true);
        } else if (id == 6) {
            this.spawnTamingParticles(false);
        } else {
            super.m_7822_(id);
        }
    }

    public void m_7332_(Entity passenger) {
        super.m_7332_(passenger);
        if (passenger instanceof Mob) {
            Mob mob = (Mob)passenger;
            this.f_20883_ = mob.f_20883_;
        }
        passenger.m_6034_(this.m_20185_(), this.m_20186_() + this.m_6048_() + passenger.m_6049_(), this.m_20189_());
        if (passenger instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)passenger;
            livingEntity.f_20883_ = this.f_20883_;
        }
    }

    public double m_6048_() {
        return (double)this.m_20206_() * 0.6;
    }

    public boolean m_6147_() {
        return false;
    }

    @Nullable
    public LivingEntity getPrimaryPassenger() {
        Entity entity = this.m_146895_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return livingEntity;
        }
        return null;
    }

    @Nullable
    private Vec3 getDismountLocationInDirection(Vec3 direction, LivingEntity passenger) {
        double d = this.m_20185_() + direction.f_82479_;
        double e = this.m_142469_().f_82289_;
        double f = this.m_20189_() + direction.f_82481_;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        block0: for (Pose pose : passenger.m_7431_()) {
            mutableBlockPos.m_122169_(d, e, f);
            double g = this.m_142469_().f_82292_ + 0.75;
            do {
                Vec3 vec3;
                AABB aABB;
                double h = this.f_19853_.m_45573_((BlockPos)mutableBlockPos);
                if ((double)mutableBlockPos.m_123342_() + h > g) continue block0;
                if (DismountHelper.m_38439_((double)h) && DismountHelper.m_38456_((CollisionGetter)this.f_19853_, (LivingEntity)passenger, (AABB)(aABB = passenger.m_21270_(pose)).m_82383_(vec3 = new Vec3(d, (double)mutableBlockPos.m_123342_() + h, f)))) {
                    passenger.m_20124_(pose);
                    return vec3;
                }
                mutableBlockPos.m_122173_(Direction.UP);
            } while ((double)mutableBlockPos.m_123342_() < g);
        }
        return null;
    }

    public Vec3 m_7688_(LivingEntity passenger) {
        Vec3 vec3 = AbstractHorse.m_19903_((double)this.m_20205_(), (double)passenger.m_20205_(), (float)(this.m_146908_() + (passenger.m_5737_() == HumanoidArm.RIGHT ? 90.0f : -90.0f)));
        Vec3 vec32 = this.getDismountLocationInDirection(vec3, passenger);
        if (vec32 != null) {
            return vec32;
        }
        Vec3 vec33 = AbstractHorse.m_19903_((double)this.m_20205_(), (double)passenger.m_20205_(), (float)(this.m_146908_() + (passenger.m_5737_() == HumanoidArm.LEFT ? 90.0f : -90.0f)));
        Vec3 vec34 = this.getDismountLocationInDirection(vec33, passenger);
        if (vec34 != null) {
            return vec34;
        }
        return this.m_20182_();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return NaturalistSoundEvents.GIRAFFE_AMBIENT.get();
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.m_20184_().m_165925_() > 1.0E-6) {
            if (this.m_20142_() || !this.m_20197_().isEmpty()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("giraffe.run", Boolean.valueOf(true)));
                event.getController().setAnimationSpeed(2.0);
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("giraffe.walk", Boolean.valueOf(true)));
                event.getController().setAnimationSpeed(1.0);
            }
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("giraffe.idle", Boolean.valueOf(true)));
            event.getController().setAnimationSpeed(1.0);
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState eatPredicate(AnimationEvent<E> event) {
        if (this.f_20911_ && event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().markNeedsReload();
            event.getController().setAnimation(new AnimationBuilder().addAnimation("giraffe.eat", Boolean.valueOf(false)));
            this.f_20911_ = false;
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.setResetSpeedInTicks(10.0);
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 10.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "eatController", 0.0f, this::eatPredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

