/*
 * Decompiled with CFR 0.152.
 */
package fuzs.stylisheffects.client.gui.effects;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.stylisheffects.StylishEffects;
import fuzs.stylisheffects.client.gui.effects.IEffectWidget;
import fuzs.stylisheffects.client.gui.effects.IHasRenderAreas;
import fuzs.stylisheffects.config.ClientConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraftforge.client.EffectRenderer;
import net.minecraftforge.client.RenderProperties;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractEffectRenderer
implements IEffectWidget,
IHasRenderAreas {
    protected static final ResourceLocation EFFECT_BACKGROUND = new ResourceLocation("stylisheffects", "textures/gui/mob_effect_background.png");
    private final EffectRendererType type;
    private GuiComponent screen;
    private int availableWidth;
    private int availableHeight;
    private int startX;
    private int startY;
    private ClientConfig.ScreenSide screenSide;
    protected List<MobEffectInstance> activeEffects;

    protected AbstractEffectRenderer(EffectRendererType type) {
        this.type = type;
    }

    public void setScreenDimensions(GuiComponent screen, int availableWidth, int availableHeight, int startX, int startY, ClientConfig.ScreenSide screenSide) {
        this.screen = screen;
        this.availableWidth = availableWidth;
        this.availableHeight = availableHeight;
        this.startX = startX;
        this.startY = startY;
        this.screenSide = screenSide;
        switch (this.type) {
            case HUD: {
                this.screenSide = this.screenSide.inverse();
                this.availableWidth -= ((ClientConfig.HudRendererConfig)this.config()).offsetX;
                this.availableHeight -= ((ClientConfig.HudRendererConfig)this.config()).offsetY;
                this.startX += (this.screenSide.right() ? 1 : -1) * ((ClientConfig.HudRendererConfig)this.config()).offsetX;
                this.startY += ((ClientConfig.HudRendererConfig)this.config()).offsetY;
                break;
            }
            case INVENTORY: {
                this.availableWidth -= ((ClientConfig.InventoryRendererConfig)this.config()).screenBorderDistance;
            }
        }
    }

    public final void setActiveEffects(Collection<MobEffectInstance> activeEffects) {
        if (activeEffects.isEmpty()) {
            this.activeEffects = null;
            return;
        }
        this.activeEffects = activeEffects.stream().filter(e -> !this.config().respectHideParticles || e.m_19575_()).filter(this.type::test).sorted().collect(Collectors.toList());
    }

    public final boolean isActive() {
        return this.activeEffects != null && !this.activeEffects.isEmpty();
    }

    public final boolean isValid() {
        return !this.config().allowFallback || this.getMaxRows() > 0 && this.getMaxColumns() > 0;
    }

    public Function<EffectRendererType, AbstractEffectRenderer> getFallbackRenderer() {
        return type -> null;
    }

    @Override
    public List<Rect2i> getRenderAreas() {
        if (this.isActive()) {
            return this.getEffectPositions(this.activeEffects).stream().map(Pair::getValue).map(pos -> new Rect2i(pos[0], pos[1], this.getWidth(), this.getHeight())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public abstract List<Pair<MobEffectInstance, int[]>> getEffectPositions(List<MobEffectInstance> var1);

    protected abstract int getTopOffset();

    protected int[] coordsToEffectPosition(int coordX, int coordY) {
        int[] renderPositions = new int[2];
        switch (this.screenSide) {
            case LEFT: {
                renderPositions[0] = this.startX - (this.getWidth() + 1) - (this.getWidth() + this.config().widgetSpaceX) * coordX;
                renderPositions[1] = this.startY + this.getTopOffset() + this.getAdjustedHeight() * coordY;
                break;
            }
            case RIGHT: {
                renderPositions[0] = this.startX + 1 + (this.getWidth() + this.config().widgetSpaceX) * coordX;
                renderPositions[1] = this.startY + this.getTopOffset() + this.getAdjustedHeight() * coordY;
            }
        }
        return renderPositions;
    }

    public void renderEffects(PoseStack matrixStack, Minecraft minecraft) {
        for (Pair<MobEffectInstance, int[]> entry : this.getEffectPositions(this.activeEffects)) {
            this.renderWidget(matrixStack, ((int[])entry.getValue())[0], ((int[])entry.getValue())[1], minecraft, (MobEffectInstance)entry.getKey());
        }
    }

    protected float getBlinkingAlpha(MobEffectInstance effectinstance) {
        if (!effectinstance.m_19571_() && effectinstance.m_19557_() <= 200) {
            int duration = 10 - effectinstance.m_19557_() / 20;
            return Mth.m_14036_((float)((float)effectinstance.m_19557_() / 10.0f / 5.0f * 0.5f), (float)0.0f, (float)0.5f) + Mth.m_14089_((float)((float)effectinstance.m_19557_() * (float)Math.PI / 5.0f)) * Mth.m_14036_((float)((float)duration / 10.0f * 0.25f), (float)0.0f, (float)0.25f);
        }
        return 1.0f;
    }

    private int getAvailableWidth() {
        return Math.min(this.availableWidth, this.config().maxColumns * (this.getWidth() + this.config().widgetSpaceX));
    }

    private int getAvailableHeight() {
        return Math.min(this.availableHeight, this.config().maxRows * (this.getHeight() + this.config().widgetSpaceY));
    }

    private int getMaxColumns() {
        return this.getAvailableWidth() / (this.getWidth() + this.config().widgetSpaceX);
    }

    public int getMaxClampedColumns() {
        return Mth.m_14045_((int)this.getMaxColumns(), (int)1, (int)this.config().maxColumns);
    }

    private int getAdjustedHeight() {
        if (this.config().overflowMode == ClientConfig.OverflowMode.CONDENSE && this.getRows() > this.getMaxClampedRows()) {
            return (this.getAvailableHeight() - this.getHeight()) / Math.max(1, this.getRows() - 1);
        }
        return this.getHeight() + this.config().widgetSpaceY;
    }

    private int getMaxRows() {
        return this.getAvailableHeight() / (this.getHeight() + this.config().widgetSpaceY);
    }

    public int getMaxClampedRows() {
        return Mth.m_14045_((int)this.getMaxRows(), (int)1, (int)this.config().maxRows);
    }

    public int getRows() {
        return this.splitByColumns(this.activeEffects.size());
    }

    protected int splitByColumns(int amountToSplit) {
        return (int)Math.ceil((float)amountToSplit / (float)this.getMaxClampedColumns());
    }

    protected ClientConfig.EffectRendererConfig config() {
        return switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case EffectRendererType.INVENTORY -> ((ClientConfig)StylishEffects.CONFIG.client()).inventoryRenderer();
            case EffectRendererType.HUD -> ((ClientConfig)StylishEffects.CONFIG.client()).hudRenderer();
        };
    }

    protected void drawCustomEffect(PoseStack matrixStack, int posX, int posY, MobEffectInstance effectinstance) {
        EffectRenderer effectRenderer = RenderProperties.getEffectRenderer((MobEffectInstance)effectinstance);
        if (this.screen instanceof EffectRenderingInventoryScreen) {
            effectRenderer.renderInventoryEffect(effectinstance, (EffectRenderingInventoryScreen)this.screen, matrixStack, posX, posY, (float)this.screen.m_93252_());
        } else if (this.screen instanceof Gui) {
            effectRenderer.renderHUDEffect(effectinstance, this.screen, matrixStack, posX, posY, (float)this.screen.m_93252_(), this.getBlinkingAlpha(effectinstance) * (float)this.config().widgetAlpha);
        }
    }

    protected Optional<MutableComponent> getEffectDuration(MobEffectInstance effectInstance, ClientConfig.LongDurationString longDurationString) {
        String effectDuration = MobEffectUtil.m_19581_((MobEffectInstance)effectInstance, (float)1.0f);
        if (effectDuration.equals("**:**")) {
            switch (longDurationString) {
                case INFINITY: {
                    return Optional.of(new TextComponent("\u221e"));
                }
                case NONE: {
                    return Optional.empty();
                }
            }
        }
        return Optional.of(new TextComponent(effectDuration));
    }

    public Optional<List<Component>> getHoveredEffectTooltip(int mouseX, int mouseY) {
        if (this.type == EffectRendererType.INVENTORY && ((ClientConfig)StylishEffects.CONFIG.client()).inventoryRenderer().hoveringTooltip) {
            return this.getHoveredEffect(mouseX, mouseY).map(effect -> this.makeEffectTooltip((MobEffectInstance)effect, ((ClientConfig)StylishEffects.CONFIG.client()).inventoryRenderer().tooltipDuration));
        }
        return Optional.empty();
    }

    public Optional<MobEffectInstance> getHoveredEffect(int mouseX, int mouseY) {
        for (Map.Entry entry : Lists.reverse(this.getEffectPositions(this.activeEffects))) {
            if (!this.isMouseOver(((int[])entry.getValue())[0], ((int[])entry.getValue())[1], mouseX, mouseY)) continue;
            return Optional.of((MobEffectInstance)entry.getKey());
        }
        return Optional.empty();
    }

    private boolean isMouseOver(int posX, int posY, int mouseX, int mouseY) {
        return mouseX >= posX && mouseX <= posX + this.getWidth() && mouseY >= posY && mouseY <= posY + this.getHeight();
    }

    protected List<Component> makeEffectTooltip(MobEffectInstance effectInstance, boolean withDuration) {
        ArrayList tooltip = Lists.newArrayList();
        String potionName = effectInstance.m_19544_().m_19481_();
        TranslatableComponent textComponent = new TranslatableComponent(potionName);
        if (effectInstance.m_19564_() >= 1 && effectInstance.m_19564_() <= 9) {
            textComponent.m_130946_(" ").m_7220_((Component)new TranslatableComponent("enchantment.level." + (effectInstance.m_19564_() + 1)));
        }
        String descriptionKey = "description." + potionName;
        if (Language.m_128107_().m_6722_(descriptionKey)) {
            if (withDuration) {
                textComponent.m_130946_(" ").m_7220_((Component)new TextComponent("(").m_130946_(MobEffectUtil.m_19581_((MobEffectInstance)effectInstance, (float)1.0f)).m_130946_(")").m_130940_(ChatFormatting.GRAY));
            }
            tooltip.add(textComponent);
            tooltip.add(new TranslatableComponent(descriptionKey).m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add(textComponent);
            if (withDuration) {
                tooltip.add(new TextComponent(MobEffectUtil.m_19581_((MobEffectInstance)effectInstance, (float)1.0f)).m_130940_(ChatFormatting.GRAY));
            }
        }
        return tooltip;
    }

    public static enum EffectRendererType {
        INVENTORY(EffectRenderer::shouldRender),
        HUD(EffectRenderer::shouldRenderHUD);

        private final BiPredicate<EffectRenderer, MobEffectInstance> filter;

        private EffectRendererType(BiPredicate<EffectRenderer, MobEffectInstance> filter) {
            this.filter = filter;
        }

        public boolean test(MobEffectInstance effectInstance) {
            EffectRenderer effectRenderer = RenderProperties.getEffectRenderer((MobEffectInstance)effectInstance);
            return this.filter.test(effectRenderer, effectInstance);
        }
    }
}

