/*
 * Decompiled with CFR 0.152.
 */
package fuzs.stylisheffects.client.gui.effects;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.stylisheffects.StylishEffects;
import fuzs.stylisheffects.client.gui.effects.AbstractEffectRenderer;
import fuzs.stylisheffects.client.gui.effects.ColorUtil;
import fuzs.stylisheffects.client.gui.effects.CompactEffectRenderer;
import fuzs.stylisheffects.config.ClientConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraftforge.client.RenderProperties;
import org.apache.commons.lang3.tuple.Pair;

public class VanillaEffectRenderer
extends AbstractEffectRenderer {
    public VanillaEffectRenderer(AbstractEffectRenderer.EffectRendererType type) {
        super(type);
    }

    @Override
    public int getWidth() {
        return 120;
    }

    @Override
    public int getHeight() {
        return 32;
    }

    @Override
    protected int getTopOffset() {
        return 0;
    }

    @Override
    public Function<AbstractEffectRenderer.EffectRendererType, AbstractEffectRenderer> getFallbackRenderer() {
        return CompactEffectRenderer::new;
    }

    @Override
    public List<Pair<MobEffectInstance, int[]>> getEffectPositions(List<MobEffectInstance> activeEffects) {
        int counter = 0;
        ArrayList effectToPos = Lists.newArrayList();
        for (MobEffectInstance effect : activeEffects) {
            int posX = counter % this.getMaxClampedColumns();
            int posY = counter / this.getMaxClampedColumns();
            ++counter;
            if (this.config().overflowMode == ClientConfig.OverflowMode.SKIP && posY >= this.getMaxClampedRows()) continue;
            effectToPos.add(Pair.of((Object)effect, (Object)this.coordsToEffectPosition(posX, posY)));
        }
        return effectToPos;
    }

    @Override
    public void renderWidget(PoseStack matrixStack, int posX, int posY, Minecraft minecraft, MobEffectInstance effectinstance) {
        RenderSystem.m_69478_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)EFFECT_BACKGROUND);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)this.config().widgetAlpha));
        GuiComponent.m_93133_((PoseStack)matrixStack, (int)posX, (int)posY, (float)0.0f, (float)(((ClientConfig)StylishEffects.CONFIG.client()).vanillaWidget().ambientBorder && effectinstance.m_19571_() ? (float)this.getHeight() : 0.0f), (int)this.getWidth(), (int)this.getHeight(), (int)256, (int)256);
        this.drawEffectSprite(matrixStack, posX, posY, minecraft, effectinstance);
        this.drawCustomEffect(matrixStack, posX, posY, effectinstance);
        this.drawEffectText(matrixStack, posX, posY, minecraft, effectinstance);
    }

    private void drawEffectSprite(PoseStack matrixStack, int posX, int posY, Minecraft minecraft, MobEffectInstance effectinstance) {
        MobEffectTextureManager potionspriteuploader = minecraft.m_91306_();
        TextureAtlasSprite textureatlassprite = potionspriteuploader.m_118732_(effectinstance.m_19544_());
        RenderSystem.m_157456_((int)0, (ResourceLocation)textureatlassprite.m_118414_().m_118330_());
        float blinkingAlpha = ((ClientConfig)StylishEffects.CONFIG.client()).vanillaWidget().blinkingAlpha ? this.getBlinkingAlpha(effectinstance) : 1.0f;
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)(blinkingAlpha * (float)this.config().widgetAlpha));
        GuiComponent.m_93200_((PoseStack)matrixStack, (int)(posX + 6), (int)(posY + 7), (int)0, (int)18, (int)18, (TextureAtlasSprite)textureatlassprite);
    }

    private void drawEffectText(PoseStack matrixStack, int posX, int posY, Minecraft minecraft, MobEffectInstance effectinstance) {
        if (RenderProperties.getEffectRenderer((MobEffectInstance)effectinstance).shouldRenderInvText(effectinstance)) {
            TranslatableComponent component = new TranslatableComponent(effectinstance.m_19544_().m_19481_());
            if (effectinstance.m_19564_() >= 1 && effectinstance.m_19564_() <= 9) {
                component.m_130946_(" ").m_7220_((Component)new TranslatableComponent("enchantment.level." + (effectinstance.m_19564_() + 1)));
            }
            int nameColor = ColorUtil.getEffectColor(((ClientConfig)StylishEffects.CONFIG.client()).vanillaWidget().nameColor, effectinstance);
            minecraft.f_91062_.m_92763_(matrixStack, (Component)component, (float)(posX + 10 + 18), (float)(posY + 7 + (!((ClientConfig)StylishEffects.CONFIG.client()).vanillaWidget().ambientDuration && effectinstance.m_19571_() ? 4 : 0)), (int)(this.config().widgetAlpha * 255.0) << 24 | nameColor);
            if (((ClientConfig)StylishEffects.CONFIG.client()).vanillaWidget().ambientDuration || !effectinstance.m_19571_()) {
                this.getEffectDuration(effectinstance, ((ClientConfig)StylishEffects.CONFIG.client()).vanillaWidget().longDurationString).ifPresent(duration -> {
                    int durationColor = ColorUtil.getEffectColor(((ClientConfig)StylishEffects.CONFIG.client()).vanillaWidget().durationColor, effectinstance);
                    minecraft.f_91062_.m_92763_(matrixStack, (Component)duration, (float)(posX + 10 + 18), (float)(posY + 7 + 10), (int)(this.config().widgetAlpha * 255.0) << 24 | durationColor);
                });
            }
        }
    }
}

