/*
 * Decompiled with CFR 0.152.
 */
package fuzs.stylisheffects.client.handler;

import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.puzzleslib.client.gui.screens.Screens;
import fuzs.stylisheffects.StylishEffects;
import fuzs.stylisheffects.client.gui.effects.AbstractEffectRenderer;
import fuzs.stylisheffects.client.gui.effects.CompactEffectRenderer;
import fuzs.stylisheffects.client.gui.effects.VanillaEffectRenderer;
import fuzs.stylisheffects.config.ClientConfig;
import fuzs.stylisheffects.mixin.client.accessor.AbstractContainerMenuAccessor;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.client.event.ContainerScreenEvent;
import net.minecraftforge.client.event.ScreenOpenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class EffectScreenHandler {
    public static final EffectScreenHandler INSTANCE = new EffectScreenHandler();
    @Nullable
    private AbstractEffectRenderer hudRenderer;

    private EffectScreenHandler() {
    }

    public void createHudRenderer() {
        this.hudRenderer = ((ClientConfig)StylishEffects.CONFIG.client()).hudRenderer().rendererType.create(AbstractEffectRenderer.EffectRendererType.HUD);
    }

    public void onRenderGameOverlayText(PoseStack poseStack, int screenWidth, int screenHeight) {
        AbstractEffectRenderer hudRenderer = this.hudRenderer;
        if (hudRenderer == null) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91080_ == null || !EffectScreenHandler.supportsEffectsDisplay(minecraft.f_91080_)) {
            hudRenderer.setActiveEffects(minecraft.f_91074_.m_21220_());
            if (hudRenderer.isActive()) {
                ClientConfig.ScreenSide screenSide = ((ClientConfig)StylishEffects.CONFIG.client()).hudRenderer().screenSide;
                hudRenderer.setScreenDimensions((GuiComponent)minecraft.f_91065_, screenWidth, screenHeight, screenSide.right() ? screenWidth : 0, 0, screenSide);
                hudRenderer.renderEffects(poseStack, minecraft);
            }
        }
    }

    @SubscribeEvent
    public void onScreenOpen(ScreenOpenEvent evt) {
        MenuType<?> type;
        if (evt.getScreen() instanceof AbstractContainerScreen && ((ClientConfig)StylishEffects.CONFIG.client()).inventoryRenderer().debugContainerTypes && (type = ((AbstractContainerMenuAccessor)((AbstractContainerScreen)evt.getScreen()).m_6262_()).getMenuType()) != null) {
            TextComponent component = new TextComponent(ForgeRegistries.CONTAINERS.getKey(type).toString());
            Minecraft.m_91087_().f_91065_.m_93076_().m_93785_((Component)new TranslatableComponent("debug.menu.opening", new Object[]{ComponentUtils.m_130748_((Component)component)}));
        }
    }

    @SubscribeEvent
    public void onDrawBackground(ContainerScreenEvent.DrawBackground evt) {
        AbstractContainerScreen screen = evt.getContainerScreen();
        AbstractEffectRenderer inventoryRenderer = EffectScreenHandler.createRendererOrFallback((Screen)screen);
        if (inventoryRenderer == null) {
            return;
        }
        if (inventoryRenderer.isActive()) {
            PoseStack poseStack = evt.getPoseStack();
            inventoryRenderer.renderEffects(poseStack, Screens.getMinecraft((Screen)screen));
            inventoryRenderer.getHoveredEffectTooltip(evt.getMouseX(), evt.getMouseY()).ifPresent(tooltip -> screen.m_96597_(poseStack, tooltip, evt.getMouseX(), evt.getMouseY()));
        }
    }

    private static boolean supportsEffectsDisplay(Screen screen) {
        MenuType<?> type;
        if (screen instanceof AbstractContainerScreen && (type = ((AbstractContainerMenuAccessor)((AbstractContainerScreen)screen).m_6262_()).getMenuType()) != null && ((ClientConfig)StylishEffects.CONFIG.client()).inventoryRenderer().menuBlacklist.contains(type)) {
            return false;
        }
        if (screen instanceof EffectRenderingInventoryScreen || ((ClientConfig)StylishEffects.CONFIG.client()).inventoryRenderer().effectsEverywhere && screen instanceof AbstractContainerScreen) {
            RecipeUpdateListener listener;
            if (screen instanceof RecipeUpdateListener && (listener = (RecipeUpdateListener)screen).m_5564_().m_100385_()) {
                return ((ClientConfig)StylishEffects.CONFIG.client()).inventoryRenderer().screenSide == ClientConfig.ScreenSide.RIGHT;
            }
            return true;
        }
        return false;
    }

    @Nullable
    public static AbstractEffectRenderer createRendererOrFallback(Screen screen) {
        EffectRenderer rendererType = ((ClientConfig)StylishEffects.CONFIG.client()).inventoryRenderer().rendererType;
        if (rendererType.isEnabled() && EffectScreenHandler.supportsEffectsDisplay(screen)) {
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            ClientConfig.ScreenSide screenSide = ((ClientConfig)StylishEffects.CONFIG.client()).inventoryRenderer().screenSide;
            Consumer<AbstractEffectRenderer> setScreenDimensions = renderer -> {
                int leftPos = Screens.getLeftPos((AbstractContainerScreen)containerScreen);
                renderer.setScreenDimensions((GuiComponent)containerScreen, !screenSide.right() ? leftPos : containerScreen.f_96543_ - (leftPos + Screens.getImageWidth((AbstractContainerScreen)containerScreen)), Screens.getImageHeight((AbstractContainerScreen)containerScreen), !screenSide.right() ? leftPos : leftPos + Screens.getImageWidth((AbstractContainerScreen)containerScreen), Screens.getTopPos((AbstractContainerScreen)containerScreen), screenSide);
            };
            AbstractEffectRenderer renderer2 = rendererType.create(AbstractEffectRenderer.EffectRendererType.INVENTORY);
            setScreenDimensions.accept(renderer2);
            while (!renderer2.isValid()) {
                if ((renderer2 = renderer2.getFallbackRenderer().apply(AbstractEffectRenderer.EffectRendererType.INVENTORY)) == null) {
                    return null;
                }
                setScreenDimensions.accept(renderer2);
            }
            renderer2.setActiveEffects(Screens.getMinecraft((Screen)screen).f_91074_.m_21220_());
            return renderer2;
        }
        return null;
    }

    public static enum EffectRenderer {
        NONE(type -> null),
        COMPACT(CompactEffectRenderer::new),
        VANILLA(VanillaEffectRenderer::new);

        private final Function<AbstractEffectRenderer.EffectRendererType, AbstractEffectRenderer> factory;

        private EffectRenderer(Function<AbstractEffectRenderer.EffectRendererType, AbstractEffectRenderer> factory) {
            this.factory = factory;
        }

        @Nonnull
        public AbstractEffectRenderer create(AbstractEffectRenderer.EffectRendererType type) {
            return this.factory.apply(type);
        }

        public boolean isEnabled() {
            return this != NONE;
        }
    }
}

