/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.entity;

import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.pathfinder.AmphibiousNodeEvaluator;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.phys.Vec3;

public class TropicalSlime
extends Slime {
    public static final EntityDataAccessor<CompoundTag> DATA_FISHS = SynchedEntityData.m_135353_(TropicalSlime.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    public static final String TAG_FISH_VARIANT = "FishVariant";
    public static final String TAG_FISH_LIST = "FishList";

    public TropicalSlime(EntityType<? extends Slime> p_33588_, Level p_33589_) {
        super(p_33588_, p_33589_);
        this.f_21342_ = new SlimeMoveControl(this);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FISHS, (Object)new CompoundTag());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new SlimeAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new SlimeRandomDirectionGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new SlimeKeepOnJumpingGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, p_33641_ -> Math.abs(p_33641_.m_20186_() - this.m_20186_()) <= 4.0));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected PathNavigation m_6037_(Level p_21480_) {
        return new TropicalPathNavigation(this, p_21480_);
    }

    public boolean m_6040_() {
        return true;
    }

    @Nullable
    public CompoundTag getFishData() {
        return (CompoundTag)this.f_19804_.m_135370_(DATA_FISHS);
    }

    @Nullable
    public ListTag getFishList() {
        if (this.getFishData() != null) {
            return (ListTag)this.getFishData().m_128423_(TAG_FISH_LIST);
        }
        return null;
    }

    protected void setFishData(CompoundTag p_36363_) {
        this.f_19804_.m_135381_(DATA_FISHS, (Object)p_36363_);
    }

    public CompoundTag writeFromBucketTag(CompoundTag p_149163_) {
        CompoundTag newTag = new CompoundTag();
        if (p_149163_ != null && p_149163_.m_128441_("BucketVariantTag")) {
            int i = p_149163_.m_128451_("BucketVariantTag");
            newTag.m_128405_(TAG_FISH_VARIANT, i);
        }
        return newTag;
    }

    public InteractionResult m_6071_(Player p_28941_, InteractionHand p_28942_) {
        ItemStack itemstack = p_28941_.m_21120_(p_28942_);
        if (itemstack.m_150930_(Items.f_42459_)) {
            CompoundTag tag = this.writeFromBucketTag(itemstack.m_41783_());
            if (this.getFishList() == null || !this.getFishList().isEmpty() && this.getFishList().size() < 4) {
                if (!tag.m_128456_()) {
                    this.addFishData(tag.m_128451_(TAG_FISH_VARIANT));
                } else {
                    int i = this.f_19796_.nextInt(2);
                    int j = this.f_19796_.nextInt(6);
                    int k = this.f_19796_.nextInt(15);
                    int l = this.f_19796_.nextInt(15);
                    this.addFishData(i | j << 8 | k << 16 | l << 24);
                }
            } else {
                return InteractionResult.FAIL;
            }
            ItemStack itemstack1 = new ItemStack((ItemLike)Items.f_42446_);
            ItemStack itemstack2 = ItemUtils.m_41817_((ItemStack)itemstack, (Player)p_28941_, (ItemStack)itemstack1, (boolean)false);
            p_28941_.m_21008_(p_28942_, itemstack2);
            SoundEvent soundevent = SoundEvents.f_11779_;
            this.m_5496_(soundevent, 1.0f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        if (itemstack.m_150930_(Items.f_42447_)) {
            ItemStack itemstack1 = new ItemStack((ItemLike)Items.f_42459_);
            if (this.releaseFish(itemstack1)) {
                ItemStack itemstack2 = ItemUtils.m_41817_((ItemStack)itemstack, (Player)p_28941_, (ItemStack)itemstack1, (boolean)false);
                p_28941_.m_21008_(p_28942_, itemstack2);
                SoundEvent soundevent = SoundEvents.f_11782_;
                this.m_5496_(soundevent, 1.0f, 1.0f);
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            return InteractionResult.FAIL;
        }
        return super.m_6071_(p_28941_, p_28942_);
    }

    protected void randomFishData() {
        int i = this.f_19796_.nextInt(2);
        int j = this.f_19796_.nextInt(6);
        int k = this.f_19796_.nextInt(15);
        int l = this.f_19796_.nextInt(15);
        this.addFishData(i | j << 8 | k << 16 | l << 24);
    }

    protected void addFishData(int variant) {
        CompoundTag fishTag = new CompoundTag();
        ListTag listnbt = new ListTag();
        if (this.getFishData() != null && (fishTag = this.getFishData()).m_128423_(TAG_FISH_LIST) != null) {
            listnbt = (ListTag)fishTag.m_128423_(TAG_FISH_LIST);
        }
        CompoundTag compoundnbt1 = new CompoundTag();
        compoundnbt1.m_128405_(TAG_FISH_VARIANT, variant);
        listnbt.add((Object)compoundnbt1);
        fishTag.m_128365_(TAG_FISH_LIST, (Tag)listnbt);
    }

    protected boolean releaseFish(ItemStack stack) {
        CompoundTag fishTag = this.getFishData();
        ListTag listnbt = new ListTag();
        if (fishTag != null && (fishTag = this.getFishData()).m_128423_(TAG_FISH_LIST) != null) {
            listnbt = (ListTag)fishTag.m_128423_(TAG_FISH_LIST);
        }
        if (!listnbt.isEmpty()) {
            int size = listnbt.size() - 1;
            stack.m_41784_().m_128405_("BucketVariantTag", ((CompoundTag)listnbt.get(size)).m_128451_(TAG_FISH_VARIANT));
            listnbt.remove(size);
            return true;
        }
        return false;
    }

    public void m_142687_(Entity.RemovalReason p_149847_) {
        super.m_142687_(p_149847_);
        CompoundTag compoundTag = this.getFishData();
        if (compoundTag != null && compoundTag.m_128423_(TAG_FISH_LIST) != null) {
            int i = this.m_33632_();
            ListTag listTag = (ListTag)compoundTag.m_128423_(TAG_FISH_LIST);
            float f = (float)i / 4.0f;
            for (int l = 0; l < listTag.size(); ++l) {
                float f1 = ((float)(l % 2) - 0.5f) * f;
                float f2 = ((float)(l / 2) - 0.5f) * f;
                TropicalFish fish = (TropicalFish)EntityType.f_20489_.m_20615_(this.f_19853_);
                if (this.m_21532_()) {
                    fish.m_21530_();
                }
                fish.m_30056_(((CompoundTag)listTag.get(l)).m_128451_(TAG_FISH_VARIANT));
                fish.m_20331_(this.m_20147_());
                fish.m_7678_(this.m_20185_() + (double)f1, this.m_20186_() + 0.5, this.m_20189_() + (double)f2, this.f_19796_.nextFloat() * 360.0f, 0.0f);
                this.f_19853_.m_7967_((Entity)fish);
            }
        }
    }

    public void m_7380_(CompoundTag p_33619_) {
        super.m_7380_(p_33619_);
        if (this.getFishData() != null) {
            p_33619_.m_128365_("FishData", (Tag)this.getFishData());
        }
    }

    public void m_7378_(CompoundTag p_33607_) {
        super.m_7378_(p_33607_);
        if (p_33607_.m_128423_("FishData") != null) {
            this.setFishData(p_33607_.m_128469_("FishData"));
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_30023_, DifficultyInstance p_30024_, MobSpawnType p_30025_, @Nullable SpawnGroupData p_30026_, @Nullable CompoundTag p_30027_) {
        p_30026_ = super.m_6518_(p_30023_, p_30024_, p_30025_, p_30026_, p_30027_);
        int size = Mth.m_14045_((int)this.m_33632_(), (int)1, (int)5);
        for (int i = 0; i < size; ++i) {
            this.randomFishData();
        }
        return p_30026_;
    }

    public static boolean checkTropicalSpawnRules(EntityType<TropicalSlime> p_32350_, ServerLevelAccessor p_32351_, MobSpawnType p_32352_, BlockPos p_32353_, Random p_32354_) {
        boolean flag;
        if (!p_32351_.m_6425_(p_32353_.m_7495_()).m_205070_(FluidTags.f_13131_)) {
            return false;
        }
        Holder holder = p_32351_.m_204166_(p_32353_);
        boolean bl = flag = p_32351_.m_46791_() != Difficulty.PEACEFUL && Monster.m_33008_((ServerLevelAccessor)p_32351_, (BlockPos)p_32353_, (Random)p_32354_) && (p_32352_ == MobSpawnType.SPAWNER || p_32351_.m_6425_(p_32353_).m_205070_(FluidTags.f_13131_));
        if (!holder.m_203565_(Biomes.f_48208_) && !holder.m_203565_(Biomes.f_48212_)) {
            return p_32354_.nextInt(40) == 0 && TropicalSlime.isDeepEnoughToSpawn((LevelAccessor)p_32351_, p_32353_) && flag;
        }
        return p_32354_.nextInt(15) == 0 && flag;
    }

    private static boolean isDeepEnoughToSpawn(LevelAccessor p_32367_, BlockPos p_32368_) {
        return p_32368_.m_123342_() < p_32367_.m_5736_() - 5;
    }

    float m_33642_() {
        float f = this.m_33633_() ? 1.4f : 0.8f;
        return ((this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.0f) * f;
    }

    public void m_7023_(Vec3 p_32394_) {
        if (this.m_6142_() && this.m_20069_()) {
            this.m_19920_(0.01f, p_32394_);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(p_32394_);
        }
    }

    static class SlimeMoveControl
    extends MoveControl {
        private float yRot;
        private int jumpDelay;
        private final TropicalSlime slime;
        private boolean isAggressive;

        public SlimeMoveControl(TropicalSlime p_33668_) {
            super((Mob)p_33668_);
            this.slime = p_33668_;
            this.yRot = 180.0f * p_33668_.m_146908_() / (float)Math.PI;
        }

        public void setDirection(float p_33673_, boolean p_33674_) {
            this.yRot = p_33673_;
            this.isAggressive = p_33674_;
        }

        public void setWantedY(double y) {
            this.f_24976_ = y;
        }

        public void setWantedMovement(double p_33671_) {
            this.f_24978_ = p_33671_;
            this.f_24981_ = MoveControl.Operation.MOVE_TO;
        }

        public void m_8126_() {
            this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), this.yRot, 90.0f));
            this.f_24974_.f_20885_ = this.f_24974_.m_146908_();
            this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
            if (this.f_24981_ != MoveControl.Operation.MOVE_TO) {
                this.f_24974_.m_21564_(0.0f);
            } else {
                this.f_24981_ = MoveControl.Operation.WAIT;
                if (this.slime.m_20069_() && !this.f_24974_.m_20096_()) {
                    float f1 = (float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_));
                    double d1 = this.f_24976_ - this.f_24974_.m_20186_();
                    if (Math.abs(d1) > (double)1.0E-5f) {
                        this.f_24974_.m_21567_(d1 > 0.0 ? f1 : -f1);
                    }
                    this.slime.m_7910_(Mth.m_14179_((float)0.125f, (float)this.slime.m_6113_(), (float)f1));
                } else if (this.f_24974_.m_20096_()) {
                    this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.slime.m_7549_();
                        if (this.isAggressive) {
                            this.jumpDelay /= 3;
                        }
                        this.slime.m_21569_().m_24901_();
                        if (this.slime.m_33634_()) {
                            this.slime.m_5496_(this.slime.m_7903_(), this.slime.m_6121_(), this.slime.m_33642_());
                        }
                    } else {
                        this.slime.f_20900_ = 0.0f;
                        this.slime.f_20902_ = 0.0f;
                        this.f_24974_.m_7910_(0.0f);
                    }
                } else {
                    this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                }
            }
        }
    }

    static class SlimeAttackGoal
    extends Goal {
        private final TropicalSlime slime;
        private int growTiredTimer;

        public SlimeAttackGoal(TropicalSlime p_33648_) {
            this.slime = p_33648_;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.slime.m_5448_();
            if (livingentity == null) {
                return false;
            }
            return !this.slime.m_6779_(livingentity) ? false : this.slime.m_21566_() instanceof SlimeMoveControl;
        }

        public void m_8056_() {
            this.growTiredTimer = SlimeAttackGoal.m_186073_((int)300);
            super.m_8056_();
        }

        public boolean m_8045_() {
            LivingEntity livingentity = this.slime.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!this.slime.m_6779_(livingentity)) {
                return false;
            }
            return --this.growTiredTimer > 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity livingentity = this.slime.m_5448_();
            if (livingentity != null) {
                this.slime.m_21391_((Entity)livingentity, 10.0f, 10.0f);
                ((SlimeMoveControl)this.slime.m_21566_()).setWantedY(livingentity.m_20186_());
            }
            ((SlimeMoveControl)this.slime.m_21566_()).setDirection(this.slime.m_146908_(), this.slime.m_7483_());
        }
    }

    static class SlimeRandomDirectionGoal
    extends Goal {
        private final TropicalSlime slime;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public SlimeRandomDirectionGoal(TropicalSlime p_33679_) {
            this.slime = p_33679_;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.slime.m_5448_() == null && (this.slime.m_20096_() || this.slime.m_20069_() || this.slime.m_20077_() || this.slime.m_21023_(MobEffects.f_19620_)) && this.slime.m_21566_() instanceof SlimeMoveControl;
        }

        public void m_8037_() {
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = this.m_183277_(40 + this.slime.m_21187_().nextInt(60));
                this.chosenDegrees = this.slime.m_21187_().nextInt(360);
            }
            ((SlimeMoveControl)this.slime.m_21566_()).setDirection(this.chosenDegrees, false);
        }
    }

    static class SlimeKeepOnJumpingGoal
    extends Goal {
        private final Slime slime;

        public SlimeKeepOnJumpingGoal(Slime p_33660_) {
            this.slime = p_33660_;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !this.slime.m_20159_();
        }

        public void m_8037_() {
            ((SlimeMoveControl)this.slime.m_21566_()).setWantedMovement(1.0);
        }
    }

    static class TropicalPathNavigation
    extends WaterBoundPathNavigation {
        TropicalPathNavigation(TropicalSlime p_30294_, Level p_30295_) {
            super((Mob)p_30294_, p_30295_);
        }

        protected boolean m_7632_() {
            return true;
        }

        protected PathFinder m_5532_(int p_30298_) {
            this.f_26508_ = new AmphibiousNodeEvaluator(false);
            return new PathFinder(this.f_26508_, p_30298_);
        }

        public boolean m_6342_(BlockPos p_30300_) {
            return !this.f_26495_.m_8055_(p_30300_.m_7495_()).m_60795_();
        }
    }
}

