/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.mixin;

import baguchan.earthmobsmod.api.IMuddy;
import baguchan.earthmobsmod.api.IOnMud;
import baguchan.earthmobsmod.api.ISheared;
import baguchan.earthmobsmod.util.DyeUtil;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.EatBlockGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.IForgeShearable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Pig.class})
public abstract class PigMixin
extends Animal
implements IMuddy,
IForgeShearable,
ISheared {
    private static final EntityDataAccessor<Boolean> DATA_MUDDY_ID = SynchedEntityData.m_135353_(Pig.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Byte> DATA_DYE_ID = SynchedEntityData.m_135353_(Pig.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final Map<DyeColor, ItemLike> ITEM_BY_DYE = (Map)Util.m_137469_((Object)Maps.newEnumMap(DyeColor.class), p_29841_ -> {
        p_29841_.put(DyeColor.WHITE, Items.f_42535_);
        p_29841_.put(DyeColor.ORANGE, Items.f_42536_);
        p_29841_.put(DyeColor.MAGENTA, Items.f_42537_);
        p_29841_.put(DyeColor.LIGHT_BLUE, Items.f_42538_);
        p_29841_.put(DyeColor.YELLOW, Items.f_42539_);
        p_29841_.put(DyeColor.LIME, Items.f_42540_);
        p_29841_.put(DyeColor.PINK, Items.f_42489_);
        p_29841_.put(DyeColor.GRAY, Items.f_42490_);
        p_29841_.put(DyeColor.LIGHT_GRAY, Items.f_42491_);
        p_29841_.put(DyeColor.CYAN, Items.f_42492_);
        p_29841_.put(DyeColor.PURPLE, Items.f_42493_);
        p_29841_.put(DyeColor.BLUE, Items.f_42494_);
        p_29841_.put(DyeColor.BROWN, Items.f_42495_);
        p_29841_.put(DyeColor.GREEN, Items.f_42496_);
        p_29841_.put(DyeColor.RED, Items.f_42497_);
        p_29841_.put(DyeColor.BLACK, Items.f_42498_);
    });
    private int eatAnimationTick;
    private EatBlockGoal eatBlockGoal;
    private boolean inMud;
    private boolean isShaking;
    private float shakeAnim;
    private float shakeAnimO;

    protected PigMixin(EntityType<? extends Animal> p_27557_, Level p_27558_) {
        super(p_27557_, p_27558_);
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    protected void defineSynchedData(CallbackInfo callbackInfo) {
        this.f_19804_.m_135372_(DATA_MUDDY_ID, (Object)false);
        this.f_19804_.m_135372_(DATA_DYE_ID, (Object)0);
    }

    @Override
    public boolean isMuddy() {
        return (Boolean)this.f_19804_.m_135370_(DATA_MUDDY_ID);
    }

    @Override
    public void setMuddy(boolean playing) {
        this.f_19804_.m_135381_(DATA_MUDDY_ID, (Object)playing);
    }

    @Override
    public float getBodyRollAngle(float p_30433_, float p_30434_) {
        float f = (Mth.m_14179_((float)p_30433_, (float)this.shakeAnimO, (float)this.shakeAnim) + p_30434_) / 1.8f;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return Mth.m_14031_((float)(f * (float)Math.PI)) * Mth.m_14031_((float)(f * (float)Math.PI * 11.0f)) * 0.15f * (float)Math.PI;
    }

    @Override
    public boolean isSheared() {
        return ((Byte)this.f_19804_.m_135370_(DATA_DYE_ID) & 0x10) != 0;
    }

    @Override
    public void setSheared(boolean p_29879_) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_DYE_ID);
        if (p_29879_) {
            this.f_19804_.m_135381_(DATA_DYE_ID, (Object)((byte)(b0 | 0x10)));
        } else {
            this.f_19804_.m_135381_(DATA_DYE_ID, (Object)((byte)(b0 & 0xFFFFFFEF)));
        }
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.m_41053_((int)((Byte)this.f_19804_.m_135370_(DATA_DYE_ID) & 0xF));
    }

    @Override
    public void setColor(DyeColor p_29856_) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_DYE_ID);
        this.f_19804_.m_135381_(DATA_DYE_ID, (Object)((byte)(b0 & 0xF0 | p_29856_.m_41060_() & 0xF)));
    }

    public void m_8119_() {
        block8: {
            block11: {
                block10: {
                    block9: {
                        super.m_8119_();
                        if (!this.m_6084_() || !(this instanceof IOnMud)) break block8;
                        if (!((IOnMud)((Object)this)).isOnMud() || this.isMuddy() && !this.isSheared() || this.isShaking) break block9;
                        this.isShaking = true;
                        this.inMud = true;
                        break block8;
                    }
                    if (!this.m_20071_() || !this.isMuddy() || this.isShaking) break block10;
                    this.isShaking = true;
                    this.inMud = false;
                    break block8;
                }
                if (this.inMud || !this.isShaking) break block11;
                if (this.shakeAnim == 0.0f) {
                    this.m_5496_(SoundEvents.f_12623_, this.m_6121_(), (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.0f);
                    this.m_146850_(GameEvent.f_157787_);
                }
                this.shakeAnimO = this.shakeAnim;
                this.shakeAnim += 0.05f;
                if (this.shakeAnimO >= 2.0f) {
                    this.inMud = false;
                    this.isShaking = false;
                    this.shakeAnimO = 0.0f;
                    this.shakeAnim = 0.0f;
                    this.setMuddy(false);
                }
                if (!(this.shakeAnim > 0.4f)) break block8;
                float f = (float)this.m_20186_();
                int i = (int)(Mth.m_14031_((float)((this.shakeAnim - 0.4f) * (float)Math.PI)) * 7.0f);
                Vec3 vec3 = this.m_20184_();
                for (int j = 0; j < i; ++j) {
                    float f1 = (this.f_19796_.nextFloat() * 2.0f - 1.0f) * this.m_20205_() * 0.5f;
                    float f2 = (this.f_19796_.nextFloat() * 2.0f - 1.0f) * this.m_20205_() * 0.5f;
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_() + (double)f1, (double)(f + 0.8f), this.m_20189_() + (double)f2, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                }
                break block8;
            }
            if (this.inMud && this.isShaking) {
                if (this.shakeAnim == 0.0f) {
                    this.m_5496_(SoundEvents.f_12623_, this.m_6121_(), (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.0f);
                    this.m_146850_(GameEvent.f_157787_);
                }
                this.shakeAnimO = this.shakeAnim;
                this.shakeAnim += 0.05f;
                if (this.shakeAnimO >= 2.0f) {
                    this.inMud = false;
                    this.isShaking = false;
                    this.shakeAnimO = 0.0f;
                    this.shakeAnim = 0.0f;
                    this.setMuddy(true);
                    this.setSheared(false);
                    this.setColor(DyeUtil.getRandomColor(this.f_19796_));
                }
                if (this.shakeAnim > 0.4f) {
                    float f = (float)this.m_20186_();
                    int i = (int)(Mth.m_14031_((float)((this.shakeAnim - 0.4f) * (float)Math.PI)) * 7.0f);
                    Vec3 vec3 = this.m_20184_();
                    for (int j = 0; j < i; ++j) {
                        float f1 = (this.f_19796_.nextFloat() * 2.0f - 1.0f) * this.m_20205_() * 0.5f;
                        float f2 = (this.f_19796_.nextFloat() * 2.0f - 1.0f) * this.m_20205_() * 0.5f;
                        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_() + (double)f1, (double)(f + 0.8f), this.m_20189_() + (double)f2, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                    }
                }
            }
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    public void addAdditionalSaveData(CompoundTag p_27587_, CallbackInfo callbackInfo) {
        p_27587_.m_128379_("Muddy", this.isMuddy());
        p_27587_.m_128379_("Sheared", this.isSheared());
        p_27587_.m_128344_("Color", (byte)this.getColor().m_41060_());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    public void readAdditionalSaveData(CompoundTag p_27576_, CallbackInfo callbackInfo) {
        this.setMuddy(p_27576_.m_128471_("Muddy"));
        this.setSheared(p_27576_.m_128471_("Sheared"));
        this.setColor(DyeColor.m_41053_((int)p_27576_.m_128445_("Color")));
    }

    public boolean isShearable(@Nonnull ItemStack item, Level world, BlockPos pos) {
        return this.m_6084_() && !this.isSheared() && !this.m_6162_() && this.isMuddy();
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nullable Player player, @Nonnull ItemStack item, Level world, BlockPos pos, int fortune) {
        world.m_6269_(null, (Entity)this, SoundEvents.f_12344_, player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS, 1.0f, 1.0f);
        this.m_146852_(GameEvent.f_157781_, (Entity)player);
        if (!world.f_46443_) {
            this.setSheared(true);
            int i = 1 + this.f_19796_.nextInt(3);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (int j = 0; j < i; ++j) {
                items.add(new ItemStack(ITEM_BY_DYE.get(this.getColor())));
            }
            return items;
        }
        return Collections.emptyList();
    }
}

