/*
 * Decompiled with CFR 0.152.
 */
package tcb.spiderstpo.mixins;

import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tcb.spiderstpo.common.Config;
import tcb.spiderstpo.common.ModTags;
import tcb.spiderstpo.common.entity.goal.BetterLeapAtTargetGoal;
import tcb.spiderstpo.common.entity.mob.IClimberEntity;
import tcb.spiderstpo.common.entity.mob.IMobEntityRegisterGoalsHook;

@Mixin(value={Spider.class}, priority=1001)
public abstract class BetterSpiderEntityMixin
extends Monster
implements IClimberEntity,
IMobEntityRegisterGoalsHook {
    private static final UUID FOLLOW_RANGE_INCREASE_ID = UUID.fromString("9e815957-3a8e-4b65-afbc-eba39d2a06b4");
    private static final AttributeModifier FOLLOW_RANGE_INCREASE = new AttributeModifier(FOLLOW_RANGE_INCREASE_ID, "Spiders 2.0 follow range increase", 8.0, AttributeModifier.Operation.ADDITION);
    private boolean pathFinderDebugPreview;

    private BetterSpiderEntityMixin(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
    }

    @Inject(method={"<init>*"}, at={@At(value="RETURN")})
    private void onConstructed(CallbackInfo ci) {
        this.m_21051_(Attributes.f_22277_).m_22125_(FOLLOW_RANGE_INCREASE);
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="HEAD")})
    private void onRegisterData(CallbackInfo ci) {
        this.pathFinderDebugPreview = (Boolean)Config.PATH_FINDER_DEBUG_PREVIEW.get();
    }

    @Redirect(method={"registerGoals()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/goal/GoalSelector;addGoal(ILnet/minecraft/world/entity/ai/goal/Goal;)V"))
    private void onAddGoal(GoalSelector selector, int priority, Goal task) {
        if (task instanceof LeapAtTargetGoal) {
            selector.m_25352_(3, new BetterLeapAtTargetGoal<BetterSpiderEntityMixin>(this, 0.4f));
        } else if (task instanceof TargetGoal) {
            selector.m_25352_(2, (Goal)((TargetGoal)task).m_26146_(200));
        } else {
            selector.m_25352_(priority, task);
        }
    }

    @Override
    public boolean shouldTrackPathingTargets() {
        return this.pathFinderDebugPreview;
    }

    @Override
    public boolean canClimbOnBlock(BlockState state, BlockPos pos) {
        return !state.m_204336_(ModTags.NON_CLIMBABLE);
    }

    @Override
    public float getBlockSlipperiness(BlockPos pos) {
        BlockState offsetState = this.f_19853_.m_8055_(pos);
        float slipperiness = offsetState.m_60734_().getFriction(offsetState, (LevelReader)this.f_19853_, pos, (Entity)this) * 0.91f;
        if (offsetState.m_204336_(ModTags.NON_CLIMBABLE)) {
            slipperiness = 1.0f - (1.0f - slipperiness) * 0.25f;
        }
        return slipperiness;
    }

    @Override
    public float getPathingMalus(BlockGetter cache, Mob entity, BlockPathTypes nodeType, BlockPos pos, Vec3i direction, Predicate<Direction> sides) {
        if (direction.m_123342_() != 0) {
            boolean hasClimbableNeigbor = false;
            BlockPos.MutableBlockPos offsetPos = new BlockPos.MutableBlockPos();
            for (Direction offset : Direction.values()) {
                if (!sides.test(offset)) continue;
                offsetPos.m_122178_(pos.m_123341_() + offset.m_122429_(), pos.m_123342_() + offset.m_122430_(), pos.m_123343_() + offset.m_122431_());
                BlockState state = cache.m_8055_((BlockPos)offsetPos);
                if (!this.canClimbOnBlock(state, (BlockPos)offsetPos)) continue;
                hasClimbableNeigbor = true;
            }
            if (!hasClimbableNeigbor) {
                return -1.0f;
            }
        }
        return entity.m_21439_(nodeType);
    }
}

