/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easymagic.world.inventory;

import com.google.common.collect.Lists;
import fuzs.easymagic.EasyMagic;
import fuzs.easymagic.config.ServerConfig;
import fuzs.easymagic.mixin.accessor.EnchantmentMenuAccessor;
import fuzs.easymagic.mixin.accessor.PlayerAccessor;
import fuzs.easymagic.network.message.S2CEnchantingDataMessage;
import fuzs.easymagic.registry.ModRegistry;
import fuzs.puzzleslib.network.message.Message;
import fuzs.puzzleslib.util.PuzzlesUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.EnchantmentTableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModEnchantmentMenu
extends EnchantmentMenu
implements ContainerListener {
    private final Container enchantSlots;
    private final ContainerLevelAccess access;
    private final Player player;
    private final Random random;
    private final DataSlot enchantmentSeed;

    public ModEnchantmentMenu(int id, Inventory playerInventory) {
        this(id, playerInventory, (Container)new SimpleContainer(2), ContainerLevelAccess.f_39287_);
    }

    public ModEnchantmentMenu(int id, Inventory playerInventory, Container inventory, ContainerLevelAccess worldPosCallable) {
        super(id, playerInventory, worldPosCallable);
        this.enchantSlots = inventory;
        this.access = worldPosCallable;
        this.player = playerInventory.f_35978_;
        this.random = ((EnchantmentMenuAccessor)((Object)this)).getRandom();
        this.enchantmentSeed = ((EnchantmentMenuAccessor)((Object)this)).getEnchantmentSeed();
        ((EnchantmentMenuAccessor)((Object)this)).setEnchantSlots(inventory);
        this.f_38839_.set(0, (Object)((Slot)PuzzlesUtil.make((Object)((Object)new EnchantableSlot(inventory, 0, 15, 47)), slot -> {
            slot.f_40219_ = 0;
        })));
        this.f_38839_.set(1, (Object)((Slot)PuzzlesUtil.make((Object)((Object)new LapisSlot(inventory, 1, 35, 47)), slot -> {
            slot.f_40219_ = 1;
        })));
        this.m_38893_(this);
    }

    public MenuType<?> m_6772_() {
        return (MenuType)ModRegistry.ENCHANTMENT_MENU_TYPE.get();
    }

    public void m_6199_(Container inventory) {
        if (inventory == this.enchantSlots) {
            ItemStack enchantedItem = inventory.m_8020_(0);
            if (!enchantedItem.m_41619_() && enchantedItem.m_41792_()) {
                this.access.m_39292_((world, pos) -> {
                    int power = ((ServerConfig)EasyMagic.CONFIG.server()).maxPower == 0 ? 15 : this.getEnchantingPower((Level)world, (BlockPos)pos) * 15 / ((ServerConfig)EasyMagic.CONFIG.server()).maxPower;
                    this.random.setSeed(this.enchantmentSeed.m_6501_());
                    this.updateLevels(enchantedItem, (Level)world, (BlockPos)pos, power);
                    this.createClues(enchantedItem);
                    this.m_38946_();
                    this.sendEnchantingData(enchantedItem);
                });
            } else {
                this.resetLevelsAndClues();
            }
        }
    }

    public void m_7934_(AbstractContainerMenu abstractContainerMenu, int i, ItemStack itemStack) {
        if (abstractContainerMenu == this) {
            this.access.m_39292_((Level2, BlockPos2) -> {
                if (i == 0 && !itemStack.m_41619_() && ((ServerConfig)EasyMagic.CONFIG.server()).rerollEnchantments == ServerConfig.ReRollEnchantments.FREE) {
                    this.reRollEnchantments(false);
                }
                if (i >= 0 && i < 2) {
                    this.m_6199_(this.enchantSlots);
                }
            });
        }
    }

    private void reRollEnchantments(boolean setPlayerSeed) {
        this.enchantmentSeed.m_6422_(this.player.m_21187_().nextInt());
        if (setPlayerSeed) {
            ((PlayerAccessor)this.player).setEnchantmentSeed(this.enchantmentSeed.m_6501_());
        }
    }

    public void m_142153_(AbstractContainerMenu abstractContainerMenu, int i, int j) {
    }

    private void resetLevelsAndClues() {
        for (int i = 0; i < 3; ++i) {
            this.f_39446_[i] = 0;
            this.f_39447_[i] = -1;
            this.f_39448_[i] = -1;
        }
    }

    private void updateLevels(ItemStack itemstack, Level world, BlockPos pos, int power) {
        for (int i1 = 0; i1 < 3; ++i1) {
            this.f_39446_[i1] = EnchantmentHelper.m_44872_((Random)this.random, (int)i1, (int)power, (ItemStack)itemstack);
            if (this.f_39446_[i1] >= i1 + 1) continue;
            this.f_39446_[i1] = 0;
        }
    }

    private void createClues(ItemStack itemstack) {
        for (int j1 = 0; j1 < 3; ++j1) {
            List<EnchantmentInstance> list;
            if (this.f_39446_[j1] <= 0 || (list = this.createEnchantmentInstance(itemstack, j1)) == null || list.isEmpty()) continue;
            EnchantmentInstance enchantmentdata = list.get(this.random.nextInt(list.size()));
            this.f_39447_[j1] = ((ForgeRegistry)ForgeRegistries.ENCHANTMENTS).getID((IForgeRegistryEntry)enchantmentdata.f_44947_);
            this.f_39448_[j1] = enchantmentdata.f_44948_;
        }
    }

    private List<EnchantmentInstance> createEnchantmentInstance(ItemStack enchantedItem, int enchantSlot) {
        return ((EnchantmentMenuAccessor)((Object)this)).callGetEnchantmentList(enchantedItem, enchantSlot, this.f_39446_[enchantSlot]);
    }

    private List<EnchantmentInstance> getEnchantmentHint(ItemStack enchantedItem, int enchantSlot, ServerConfig.ShowEnchantments showEnchantments) {
        return switch (showEnchantments) {
            default -> throw new IncompatibleClassChangeError();
            case ServerConfig.ShowEnchantments.NONE -> Lists.newArrayList();
            case ServerConfig.ShowEnchantments.SINGLE -> {
                List<EnchantmentInstance> enchantmentData = this.createEnchantmentInstance(enchantedItem, enchantSlot);
                if (enchantmentData.isEmpty()) {
                    yield Lists.newArrayList();
                }
                yield Lists.newArrayList((Object[])new EnchantmentInstance[]{enchantmentData.get(this.random.nextInt(enchantmentData.size()))});
            }
            case ServerConfig.ShowEnchantments.ALL -> this.createEnchantmentInstance(enchantedItem, enchantSlot);
        };
    }

    private void sendEnchantingData(ItemStack enchantedItem) {
        ServerConfig.ShowEnchantments showEnchantments = ((ServerConfig)EasyMagic.CONFIG.server()).showEnchantments;
        List<EnchantmentInstance> firstSlotData = this.getEnchantmentHint(enchantedItem, 0, showEnchantments);
        List<EnchantmentInstance> secondSlotData = this.getEnchantmentHint(enchantedItem, 1, showEnchantments);
        List<EnchantmentInstance> thirdSlotData = this.getEnchantmentHint(enchantedItem, 2, showEnchantments);
        EasyMagic.NETWORK.sendTo((Message)new S2CEnchantingDataMessage(this.f_38840_, firstSlotData, secondSlotData, thirdSlotData), (ServerPlayer)this.player);
    }

    private int getEnchantingPower(Level level, BlockPos pos) {
        float j = 0.0f;
        for (BlockPos blockpos : EnchantmentTableBlock.f_207902_) {
            if (!EnchantmentTableBlock.m_207909_((Level)level, (BlockPos)pos, (BlockPos)blockpos)) continue;
            j += ModEnchantmentMenu.getEnchantPowerBonus(level.m_8055_(pos.m_141952_((Vec3i)blockpos)), level, pos.m_141952_((Vec3i)blockpos));
        }
        return (int)j;
    }

    public static boolean isBlockEmpty(Level world, BlockPos pos) {
        if (((ServerConfig)EasyMagic.CONFIG.server()).lenientBookshelves) {
            return world.m_8055_(pos).m_60812_((BlockGetter)world, pos).m_83281_();
        }
        return world.m_46859_(pos);
    }

    public static float getEnchantPowerBonus(BlockState state, Level level, BlockPos pos) {
        return state.getEnchantPowerBonus((LevelReader)level, pos);
    }

    public boolean m_6366_(Player player, int data) {
        if (data == 4) {
            ItemStack itemstack;
            if (((ServerConfig)EasyMagic.CONFIG.server()).rerollEnchantments == ServerConfig.ReRollEnchantments.WITH_COST && ((itemstack = this.enchantSlots.m_8020_(1)).m_41613_() >= ((ServerConfig)EasyMagic.CONFIG.server()).rerollLapisCost && player.f_36078_ >= ((ServerConfig)EasyMagic.CONFIG.server()).rerollLevelCost || player.m_150110_().f_35937_)) {
                this.access.m_39292_((level, pos) -> {
                    this.reRollEnchantments(true);
                    if (!player.m_150110_().f_35937_) {
                        if (((ServerConfig)EasyMagic.CONFIG.server()).rerollLapisCost > 0) {
                            itemstack.m_41774_(((ServerConfig)EasyMagic.CONFIG.server()).rerollLapisCost);
                            if (itemstack.m_41619_()) {
                                this.enchantSlots.m_6836_(1, ItemStack.f_41583_);
                            }
                        }
                        if (((ServerConfig)EasyMagic.CONFIG.server()).rerollLevelCost > 0) {
                            player.m_6749_(-((ServerConfig)EasyMagic.CONFIG.server()).rerollLevelCost);
                        }
                    }
                    this.enchantSlots.m_6596_();
                    this.m_6199_(this.enchantSlots);
                    level.m_5594_(null, pos, SoundEvents.f_11887_, SoundSource.BLOCKS, 1.0f, level.f_46441_.nextFloat() * 0.1f + 0.9f);
                });
                return true;
            }
            return false;
        }
        return super.m_6366_(player, data);
    }

    public boolean m_6875_(Player playerIn) {
        return this.enchantSlots.m_6542_(playerIn);
    }

    public void m_6877_(Player playerIn) {
        ItemStack itemstack;
        if (playerIn instanceof ServerPlayer && !(itemstack = this.m_142621_()).m_41619_()) {
            if (playerIn.m_6084_() && !((ServerPlayer)playerIn).m_9232_()) {
                playerIn.m_150109_().m_150079_(itemstack);
            } else {
                playerIn.m_36176_(itemstack, false);
            }
            this.m_142503_(ItemStack.f_41583_);
        }
    }

    private static class EnchantableSlot
    extends Slot {
        public EnchantableSlot(Container inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public boolean m_5857_(ItemStack stack) {
            if (((ServerConfig)EasyMagic.CONFIG.server()).filterTable) {
                return stack.m_41792_() || stack.m_41720_() instanceof BookItem && !this.m_6657_();
            }
            return true;
        }

        public int m_6641_() {
            return 1;
        }
    }

    private static class LapisSlot
    extends Slot {
        public LapisSlot(Container inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public boolean m_5857_(ItemStack stack) {
            return stack.m_204117_(Tags.Items.ENCHANTING_FUELS);
        }
    }
}

