/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.tr7zw.notenoughanimations.RotationLock;
import dev.tr7zw.notenoughanimations.config.Config;
import dev.tr7zw.notenoughanimations.config.ConfigUpgrader;
import dev.tr7zw.notenoughanimations.config.CustomConfigScreen;
import dev.tr7zw.notenoughanimations.logic.AnimationProvider;
import dev.tr7zw.notenoughanimations.logic.HeldItemHandler;
import dev.tr7zw.notenoughanimations.logic.PlayerTransformer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import net.minecraft.client.Option;
import net.minecraft.client.gui.screens.Screen;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class NEAnimationsLoader {
    public static final Logger LOGGER = LogManager.getLogger((String)"NotEnoughAnimations");
    public static NEAnimationsLoader INSTANCE;
    public static Config config;
    private final File settingsFile = new File("config", "notenoughanimations.json");
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public PlayerTransformer playerTransformer;
    public HeldItemHandler heldItemHandler;
    public AnimationProvider animationProvider;

    public void onEnable() {
        INSTANCE = this;
        if (this.settingsFile.exists()) {
            try {
                config = (Config)this.gson.fromJson(new String(Files.readAllBytes(this.settingsFile.toPath()), StandardCharsets.UTF_8), Config.class);
            }
            catch (Exception ex) {
                System.out.println("Error while loading config! Creating a new one!");
                ex.printStackTrace();
            }
        }
        if (config == null) {
            config = new Config();
            this.writeConfig();
        } else if (ConfigUpgrader.upgradeConfig(config)) {
            this.writeConfig();
        }
        this.enable();
    }

    private void enable() {
        this.playerTransformer = new PlayerTransformer();
        this.heldItemHandler = new HeldItemHandler();
        this.animationProvider = new AnimationProvider();
    }

    public void writeConfig() {
        if (this.settingsFile.exists()) {
            this.settingsFile.delete();
        }
        try {
            Files.write(this.settingsFile.toPath(), this.gson.toJson((Object)config).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public Screen createConfigScreen(Screen parent) {
        CustomConfigScreen screen = new CustomConfigScreen(parent, "text.nea.title"){

            @Override
            public void initialize() {
                ArrayList<Object> options = new ArrayList<Object>();
                options.add(this.getOnOffOption("text.nea.enable.animationsmoothing", () -> NEAnimationsLoader.config.enableAnimationSmoothing, b -> {
                    NEAnimationsLoader.config.enableAnimationSmoothing = b;
                }));
                options.add(this.getDoubleOption("text.nea.smoothingSpeed", 10.0f, 30.0f, 0.1f, () -> NEAnimationsLoader.config.animationSmoothingSpeed, i -> {
                    NEAnimationsLoader.config.animationSmoothingSpeed = i.floatValue();
                }));
                options.add(this.getOnOffOption("text.nea.enable.inworldmaprendering", () -> NEAnimationsLoader.config.enableInWorldMapRendering, b -> {
                    NEAnimationsLoader.config.enableInWorldMapRendering = b;
                }));
                options.add(this.getOnOffOption("text.nea.enable.offhandhiding", () -> NEAnimationsLoader.config.enableOffhandHiding, b -> {
                    NEAnimationsLoader.config.enableOffhandHiding = b;
                }));
                options.add(this.getOnOffOption("text.nea.enable.rotationlocking", () -> NEAnimationsLoader.config.enableRotationLocking, b -> {
                    NEAnimationsLoader.config.enableRotationLocking = b;
                }));
                options.add(this.getOnOffOption("text.nea.enable.ladderanimation", () -> NEAnimationsLoader.config.enableLadderAnimation, b -> {
                    NEAnimationsLoader.config.enableLadderAnimation = b;
                }));
                options.add(this.getOnOffOption("text.nea.enable.rotatetoladder", () -> NEAnimationsLoader.config.enableRotateToLadder, b -> {
                    NEAnimationsLoader.config.enableRotateToLadder = b;
                }));
                options.add(this.getDoubleOption("text.nea.ladderAnimationAmplifier", 0.1f, 0.5f, 0.01f, () -> NEAnimationsLoader.config.ladderAnimationAmplifier, i -> {
                    NEAnimationsLoader.config.ladderAnimationAmplifier = i.floatValue();
                }));
                options.add(this.getDoubleOption("text.nea.ladderAnimationArmHeight", 1.0f, 3.0f, 0.1f, () -> NEAnimationsLoader.config.ladderAnimationArmHeight, i -> {
                    NEAnimationsLoader.config.ladderAnimationArmHeight = i.floatValue();
                }));
                options.add(this.getDoubleOption("text.nea.ladderAnimationArmSpeed", 1.0f, 4.0f, 0.1f, () -> NEAnimationsLoader.config.ladderAnimationArmSpeed, i -> {
                    NEAnimationsLoader.config.ladderAnimationArmSpeed = i.floatValue();
                }));
                options.add(this.getOnOffOption("text.nea.enable.crawling", () -> NEAnimationsLoader.config.enableCrawlingAnimation, b -> {
                    NEAnimationsLoader.config.enableCrawlingAnimation = b;
                }));
                options.add(this.getOnOffOption("text.nea.enable.eatdringanimation", () -> NEAnimationsLoader.config.enableEatDrinkAnimation, b -> {
                    NEAnimationsLoader.config.enableEatDrinkAnimation = b;
                }));
                options.add(this.getOnOffOption("text.nea.enable.rowboatanimation", () -> NEAnimationsLoader.config.enableRowBoatAnimation, b -> {
                    NEAnimationsLoader.config.enableRowBoatAnimation = b;
                }));
                options.add(this.getOnOffOption("text.nea.enable.horseanimation", () -> NEAnimationsLoader.config.enableHorseAnimation, b -> {
                    NEAnimationsLoader.config.enableHorseAnimation = b;
                }));
                options.add(this.getOnOffOption("text.nea.enable.dontholditemsinbed", () -> NEAnimationsLoader.config.dontHoldItemsInBed, b -> {
                    NEAnimationsLoader.config.dontHoldItemsInBed = b;
                }));
                options.add(this.getOnOffOption("text.nea.enable.freezearmsinbed", () -> NEAnimationsLoader.config.freezeArmsInBed, b -> {
                    NEAnimationsLoader.config.freezeArmsInBed = b;
                }));
                options.add(this.getEnumOption("text.nea.rotationlock", RotationLock.class, () -> NEAnimationsLoader.config.rotationLock, b -> {
                    NEAnimationsLoader.config.rotationLock = b;
                }));
                options.add(this.getOnOffOption("text.nea.enable.showlastusedsword", () -> NEAnimationsLoader.config.showLastUsedSword, b -> {
                    NEAnimationsLoader.config.showLastUsedSword = b;
                }));
                options.add(this.getOnOffOption("text.nea.enable.holdupallitems", () -> NEAnimationsLoader.config.holdUpAllItems, b -> {
                    NEAnimationsLoader.config.holdUpAllItems = b;
                }));
                options.add(this.getOnOffOption("text.nea.enable.itemSwapAnimation", () -> NEAnimationsLoader.config.itemSwapAnimation, b -> {
                    NEAnimationsLoader.config.itemSwapAnimation = b;
                }));
                options.add(this.getOnOffOption("text.nea.enable.tweakElytraAnimation", () -> NEAnimationsLoader.config.tweakElytraAnimation, b -> {
                    NEAnimationsLoader.config.tweakElytraAnimation = b;
                }));
                options.add(this.getOnOffOption("text.nea.enable.petAnimation", () -> NEAnimationsLoader.config.petAnimation, b -> {
                    NEAnimationsLoader.config.petAnimation = b;
                }));
                options.add(this.getOnOffOption("text.nea.enable.fallingAnimation", () -> NEAnimationsLoader.config.fallingAnimation, b -> {
                    NEAnimationsLoader.config.fallingAnimation = b;
                }));
                options.add(this.getOnOffOption("text.nea.enable.freezingAnimation", () -> NEAnimationsLoader.config.freezingAnimation, b -> {
                    NEAnimationsLoader.config.freezingAnimation = b;
                }));
                options.add(this.getOnOffOption("text.nea.enable.huggingAnimation", () -> NEAnimationsLoader.config.huggingAnimation, b -> {
                    NEAnimationsLoader.config.huggingAnimation = b;
                }));
                options.add(this.getOnOffOption("text.nea.enable.narutoRunning", () -> NEAnimationsLoader.config.narutoRunning, b -> {
                    NEAnimationsLoader.config.narutoRunning = b;
                }));
                options.add(this.getOnOffOption("text.nea.enable.enableInWorldBookRendering", () -> NEAnimationsLoader.config.enableInWorldBookRendering, b -> {
                    NEAnimationsLoader.config.enableInWorldBookRendering = b;
                }));
                this.getOptions().m_94476_(options.toArray(new Option[0]));
            }

            @Override
            public void save() {
                NEAnimationsLoader.this.writeConfig();
                NEAnimationsLoader.this.animationProvider.refreshEnabledAnimations();
            }
        };
        return screen;
    }
}

