/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.data_handler;

import com.legacy.structure_gel.api.data_handler.handlers.DataHandler;
import com.legacy.structure_gel.api.data_handler.parsing.DataMap;
import com.legacy.structure_gel.api.data_handler.parsing.DataParser;
import com.legacy.structure_gel.api.events.RegisterDataHandlerTypeEvent;
import com.legacy.structure_gel.api.registry.SGRegistry;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.data_handler.handlers.BlockStateHandler;
import com.legacy.structure_gel.core.data_handler.handlers.ChestHandler;
import com.legacy.structure_gel.core.data_handler.handlers.ConfiguredFeatureHandler;
import com.legacy.structure_gel.core.data_handler.handlers.DynamicSpawnerHandler;
import com.legacy.structure_gel.core.data_handler.handlers.EntityHandler;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;

public class DataHandlerType<T extends DataHandler<T>> {
    public static final SGRegistry<ResourceLocation, DataHandlerType<?>> REGISTRY = new SGRegistry(StructureGelMod.locate("data_handler_type"), () -> null, RegisterDataHandlerTypeEvent::new);
    public static final DataHandlerType<ChestHandler> CHEST = DataHandlerType.register(new DataHandlerType<ChestHandler>(StructureGelMod.locate("chest"), ChestHandler::new, ChestHandler::parser));
    public static final DataHandlerType<EntityHandler> ENTITY = DataHandlerType.register(new DataHandlerType<EntityHandler>(StructureGelMod.locate("entity"), EntityHandler::new, EntityHandler::parser));
    public static final DataHandlerType<DynamicSpawnerHandler> DYNAMIC_SPAWNER = DataHandlerType.register(new DataHandlerType<DynamicSpawnerHandler>(StructureGelMod.locate("dynamic_spawner"), DynamicSpawnerHandler::new, DynamicSpawnerHandler::parser));
    public static final DataHandlerType<BlockStateHandler> BLOCK_STATE = DataHandlerType.register(new DataHandlerType<BlockStateHandler>(StructureGelMod.locate("block_state"), BlockStateHandler::new, BlockStateHandler::parser));
    public static final DataHandlerType<ConfiguredFeatureHandler> CONFIGURED_FEATURE = DataHandlerType.register(new DataHandlerType<ConfiguredFeatureHandler>(StructureGelMod.locate("configured_feature"), ConfiguredFeatureHandler::new, ConfiguredFeatureHandler::parser));
    private final ResourceLocation registryName;
    private final Function<DataMap, T> factory;
    private final Supplier<DataParser> dataParser;

    public DataHandlerType(ResourceLocation registryName, Function<DataMap, T> factory, Supplier<DataParser> dataParser) {
        this.factory = factory;
        this.dataParser = dataParser;
        this.registryName = registryName;
    }

    public T create(DataMap dataMap) {
        return (T)((DataHandler)this.factory.apply(dataMap));
    }

    public DataParser getDataParser() {
        return this.dataParser.get();
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public static <T extends DataHandler<T>> DataHandlerType<T> register(DataHandlerType<T> dataHandlerType) {
        return REGISTRY.register(dataHandlerType.getRegistryName(), dataHandlerType);
    }
}

