/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core;

import com.legacy.structure_gel.core.SGAccessor;
import com.legacy.structure_gel.core.SGConfig;
import com.legacy.structure_gel.core.SGProxy;
import com.legacy.structure_gel.core.client.ClientProxy;
import com.legacy.structure_gel.core.util.Internal;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="structure_gel")
@Internal
public class StructureGelMod {
    public static final String MODID = "structure_gel";
    private static final Logger LOGGER = LogManager.getLogger((String)"ModdingLegacy/structure_gel");
    private static boolean loggerEnabled = true;
    public static SGProxy proxy = new SGProxy();
    public static boolean isLootrLoaded = false;

    public StructureGelMod() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SGConfig.COMMON_SPEC);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            proxy = new ClientProxy();
            ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)SGConfig.CLIENT_SPEC);
        });
        SGAccessor.init();
    }

    private static void log(Level level, Object message, Object ... params) {
        if (loggerEnabled) {
            LOGGER.log(level, "[Structure Gel] " + message, params);
        }
    }

    public static void log(Object message, Object ... params) {
        StructureGelMod.log(Level.INFO, message, params);
    }

    public static void logDebug(Object message, Object ... params) {
        StructureGelMod.log(SGConfig.COMMON.consoleDebug() ? Level.INFO : Level.DEBUG, message, params);
    }

    public static void logError(Object message, Object ... params) {
        StructureGelMod.log(Level.ERROR, message, params);
    }

    public static void logWarn(Object message, Object ... params) {
        StructureGelMod.log(Level.WARN, message, params);
    }

    public static void logFatal(Object message, Object ... params) {
        StructureGelMod.log(Level.FATAL, message, params);
    }

    public static void configDebug(Object message, Object ... params) {
        if (SGConfig.COMMON.consoleDebug()) {
            StructureGelMod.log(message, params);
        }
    }

    public static void disableLogger() {
        loggerEnabled = false;
    }

    public static void enableLogger() {
        loggerEnabled = true;
    }

    public static ResourceLocation locate(String key) {
        return new ResourceLocation(MODID, key);
    }
}

