/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.block_entity;

import com.legacy.structure_gel.api.data_handler.DataHandlerType;
import com.legacy.structure_gel.api.data_handler.handlers.DataHandler;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.block_entity.SGBlockEntity;
import com.legacy.structure_gel.core.registry.SGBlockEntities;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;

public class DataHandlerBlockEntity
extends SGBlockEntity {
    public static final String TYPE_KEY = "type";
    public static final String ENTRIES_KEY = "entries";
    private ResourceLocation dataHandlerType = null;
    private Map<String, String> dataEntries = new HashMap<String, String>();

    public DataHandlerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SGBlockEntities.DATA_HANDLER.get(), pos, state);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.dataHandlerType != null) {
            tag.m_128359_(TYPE_KEY, this.dataHandlerType.toString());
        }
        CompoundTag dataTag = new CompoundTag();
        for (Map.Entry<String, String> entry : this.dataEntries.entrySet()) {
            dataTag.m_128359_(entry.getKey(), entry.getValue());
        }
        tag.m_128365_(ENTRIES_KEY, (Tag)dataTag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.dataHandlerType = DataHandlerBlockEntity.readType(tag);
        this.dataEntries = DataHandlerBlockEntity.readDataEntries(tag);
    }

    @Nullable
    public static ResourceLocation readType(CompoundTag tag) {
        if (tag.m_128425_(TYPE_KEY, 8)) {
            return new ResourceLocation(tag.m_128461_(TYPE_KEY));
        }
        return null;
    }

    public static Map<String, String> readDataEntries(CompoundTag tag) {
        HashMap<String, String> entries = new HashMap<String, String>();
        CompoundTag dataTag = tag.m_128469_(ENTRIES_KEY);
        for (String key : dataTag.m_128431_()) {
            entries.put(key, dataTag.m_128461_(key));
        }
        return entries;
    }

    public static void handle(BlockState dataHandler, ResourceLocation typeName, Map<String, String> dataEntries, BlockPos pos, WorldGenLevel level, Random rand, BoundingBox bounds, StructurePiece piece, boolean alwaysGenerate) {
        DataHandler<?> handler = DataHandlerBlockEntity.deserializeHandler(typeName, dataEntries, pos);
        if (handler != null) {
            try {
                handler.handleAll(dataHandler, pos, level, rand, bounds, piece, alwaysGenerate);
            }
            catch (Exception e) {
                StructureGelMod.logError("Failed to handle DataHandlerBlockEntity", e);
            }
        }
    }

    @Nullable
    private static DataHandler<?> deserializeHandler(ResourceLocation typeName, Map<String, String> dataEntries, BlockPos pos) {
        try {
            if (typeName != null) {
                DataHandlerType<?> type = DataHandlerType.REGISTRY.get(typeName);
                if (type != null) {
                    return type.create(type.getDataParser().parse(dataEntries));
                }
                StructureGelMod.logWarn("{} is not a registered DataHandlerType", typeName);
            } else {
                StructureGelMod.logWarn("\type\" was null for the DataHandlerBlockEntity at {}", pos);
            }
        }
        catch (Exception e) {
            StructureGelMod.logError("Couldn't deserialize DataHandler from {}", pos);
            StructureGelMod.logError(e, new Object[0]);
        }
        return null;
    }

    @Nullable
    public ResourceLocation getDataHandlerType() {
        return this.dataHandlerType;
    }

    public void setDataHandlerType(@Nullable ResourceLocation dataHandlerType) {
        this.dataHandlerType = dataHandlerType;
    }

    public Map<String, String> getDataEntries() {
        return this.dataEntries;
    }

    public void setDataEntries(Map<String, String> dataEntries) {
        this.dataEntries = dataEntries;
    }
}

