/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.network;

import com.legacy.structure_gel.core.item.building_tool.BuildingToolItem;
import com.legacy.structure_gel.core.registry.SGItems;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public record MiddleClickBuildingToolPacket(InteractionHand hand, @Nullable BlockPos pos) {
    public static void encoder(MiddleClickBuildingToolPacket packet, FriendlyByteBuf buff) {
        buff.writeBoolean(packet.hand == InteractionHand.MAIN_HAND);
        buff.writeBoolean(packet.pos != null);
        if (packet.pos != null) {
            buff.m_130064_(packet.pos);
        }
    }

    public static MiddleClickBuildingToolPacket decoder(FriendlyByteBuf buff) {
        InteractionHand hand = buff.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        boolean isPosPresent = buff.readBoolean();
        BlockPos pos = isPosPresent ? buff.m_130135_() : null;
        return new MiddleClickBuildingToolPacket(hand, pos);
    }

    public static void handler(MiddleClickBuildingToolPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)context.get()).getSender();
            ItemStack stack = sender.m_21120_(packet.hand);
            if (stack.m_150930_((Item)SGItems.BUILDING_TOOL.get())) {
                ((BuildingToolItem)((Object)((Object)SGItems.BUILDING_TOOL.get()))).onMiddleClick(stack, (Player)sender, packet.pos);
                sender.m_6674_(packet.hand);
            }
        });
        context.get().setPacketHandled(true);
    }
}

