/*
 * Decompiled with CFR 0.152.
 */
package dev.kosmx.playerAnim.core.data.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.kosmx.playerAnim.core.data.AnimationFormat;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Ease;
import dev.kosmx.playerAnim.core.util.Easing;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GeckoLibSerializer {
    public static List<KeyframeAnimation> serialize(JsonObject node) {
        return GeckoLibSerializer.readAnimations(node.get("animations").getAsJsonObject());
    }

    private static List<KeyframeAnimation> readAnimations(JsonObject jsonEmotes) {
        ArrayList<KeyframeAnimation> emotes = new ArrayList<KeyframeAnimation>();
        jsonEmotes.entrySet().forEach(stringJsonElementEntry -> {
            KeyframeAnimation.AnimationBuilder builder = new KeyframeAnimation.AnimationBuilder(AnimationFormat.JSON_MC_ANIM);
            String name = (String)stringJsonElementEntry.getKey();
            JsonObject node = ((JsonElement)stringJsonElementEntry.getValue()).getAsJsonObject();
            builder.name = name;
            if (node.has("animation_length")) {
                builder.endTick = (int)Math.ceil(node.get("animation_length").getAsFloat() * 20.0f);
                if (node.has("loop")) {
                    boolean bl = builder.isLooped = node.get("loop").getAsJsonPrimitive().isBoolean() && node.get("loop").getAsBoolean();
                    if (!builder.isLooped && node.get("loop").getAsJsonPrimitive().isString() && node.get("loop").getAsString().equals("hold_on_last_frame")) {
                        builder.isLooped = true;
                        builder.returnTick = builder.endTick;
                    } else {
                        --builder.endTick;
                    }
                }
                builder.fullyEnableParts();
                builder.optimizeEmote();
                GeckoLibSerializer.keyframeSerializer(builder, node.get("bones").getAsJsonObject());
            } else if (node.has("loop") && node.get("loop").getAsBoolean()) {
                builder.stopTick = 1;
                builder.endTick = 1;
                builder.isLooped = true;
                builder.returnTick = 0;
                GeckoLibSerializer.keyframeSerializer(builder, node.get("bones").getAsJsonObject());
            } else {
                throw new JsonParseException("Could not recognise GeckoLib animation: " + name);
            }
            emotes.add(builder.build());
        });
        return emotes;
    }

    private static void keyframeSerializer(KeyframeAnimation.AnimationBuilder emoteData, JsonObject node) {
        for (Map.Entry entry : node.entrySet()) {
            GeckoLibSerializer.readBone(emoteData.getOrCreatePart(GeckoLibSerializer.snake2Camel((String)entry.getKey())), ((JsonElement)entry.getValue()).getAsJsonObject(), emoteData);
        }
    }

    private static void readBone(KeyframeAnimation.StateCollection stateCollection, JsonObject node, KeyframeAnimation.AnimationBuilder emoteData) {
        if (node.has("rotation")) {
            JsonElement jsonRotation = node.get("rotation");
            if (jsonRotation.isJsonArray()) {
                GeckoLibSerializer.readCollection(GeckoLibSerializer.getRots(stateCollection), 0, Ease.LINEAR, jsonRotation.getAsJsonArray(), emoteData, false);
            } else {
                jsonRotation.getAsJsonObject().entrySet().forEach(entry -> {
                    if (((String)entry.getKey()).equals("vector")) {
                        GeckoLibSerializer.readCollection(GeckoLibSerializer.getRots(stateCollection), 0, Ease.LINEAR, ((JsonElement)entry.getValue()).getAsJsonArray(), emoteData, false);
                    } else {
                        int tick = (int)(Float.parseFloat((String)entry.getKey()) * 20.0f);
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            GeckoLibSerializer.readCollection(GeckoLibSerializer.getRots(stateCollection), tick, Ease.CONSTANT, ((JsonElement)entry.getValue()).getAsJsonArray(), emoteData, false);
                        } else {
                            GeckoLibSerializer.readDataAtTick(((JsonElement)entry.getValue()).getAsJsonObject(), stateCollection, tick, emoteData, false);
                        }
                    }
                });
            }
        }
        if (node.has("position")) {
            JsonElement jsonPosition = node.get("position");
            if (jsonPosition.isJsonArray()) {
                GeckoLibSerializer.readCollection(GeckoLibSerializer.getOffs(stateCollection), 0, Ease.LINEAR, jsonPosition.getAsJsonArray(), emoteData, true);
            } else {
                jsonPosition.getAsJsonObject().entrySet().forEach(entry -> {
                    if (((String)entry.getKey()).equals("vector")) {
                        GeckoLibSerializer.readCollection(GeckoLibSerializer.getOffs(stateCollection), 0, Ease.LINEAR, ((JsonElement)entry.getValue()).getAsJsonArray(), emoteData, true);
                    } else {
                        int tick = (int)(Float.parseFloat((String)entry.getKey()) * 20.0f);
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            GeckoLibSerializer.readCollection(GeckoLibSerializer.getOffs(stateCollection), tick, Ease.LINEAR, ((JsonElement)entry.getValue()).getAsJsonArray(), emoteData, true);
                        } else {
                            GeckoLibSerializer.readDataAtTick(((JsonElement)entry.getValue()).getAsJsonObject(), stateCollection, tick, emoteData, true);
                        }
                    }
                });
            }
        }
    }

    private static void readDataAtTick(JsonObject currentNode, KeyframeAnimation.StateCollection stateCollection, int tick, KeyframeAnimation.AnimationBuilder emoteData, boolean isPos) {
        KeyframeAnimation.StateCollection.State[] targetVec;
        Ease ease = Ease.LINEAR;
        if (currentNode.has("lerp_mode")) {
            String lerp = currentNode.get("lerp_mode").getAsString();
            ease = lerp.equals("catmullrom") ? Ease.INOUTSINE : Easing.easeFromString(lerp);
        }
        KeyframeAnimation.StateCollection.State[] stateArray = targetVec = isPos ? GeckoLibSerializer.getOffs(stateCollection) : GeckoLibSerializer.getRots(stateCollection);
        if (currentNode.has("easing")) {
            ease = Easing.easeFromString(currentNode.get("easing").getAsString());
        }
        if (currentNode.has("pre")) {
            GeckoLibSerializer.readCollection(targetVec, tick, ease, GeckoLibSerializer.getVector(currentNode.get("pre")), emoteData, isPos);
        }
        if (currentNode.has("vector")) {
            GeckoLibSerializer.readCollection(targetVec, tick, ease, currentNode.get("vector").getAsJsonArray(), emoteData, isPos);
        }
        if (currentNode.has("post")) {
            GeckoLibSerializer.readCollection(targetVec, tick, ease, GeckoLibSerializer.getVector(currentNode.get("post")), emoteData, isPos);
        }
    }

    public static JsonArray getVector(JsonElement element) {
        if (element.isJsonArray()) {
            return element.getAsJsonArray();
        }
        return ((JsonObject)element).get("vector").getAsJsonArray();
    }

    private static void readCollection(KeyframeAnimation.StateCollection.State[] a, int tick, Ease ease, JsonArray array, KeyframeAnimation.AnimationBuilder emoteData, boolean isPos) {
        if (a.length != 3) {
            throw new ArrayStoreException("wrong array length");
        }
        for (int i = 0; i < 3; ++i) {
            float value = array.get(i).getAsFloat();
            if (isPos) {
                if (a[0] == emoteData.body.x) {
                    value /= 16.0f;
                    if (i == 0) {
                        value = -value;
                    }
                } else if (i == 1) {
                    value = -value;
                }
            } else if (a[0] == emoteData.body.pitch && i != 2) {
                value = -value;
            }
            a[i].addKeyFrame(tick, value += a[i].defaultValue, ease, 0, true);
        }
    }

    public static String snake2Camel(String original) {
        StringBuilder builder = new StringBuilder();
        StringReader reader = new StringReader(original);
        boolean upperNext = false;
        try {
            int c;
            while ((c = reader.read()) != -1) {
                if (c == 95) {
                    upperNext = true;
                    continue;
                }
                if (upperNext) {
                    builder.appendCodePoint(Character.toUpperCase(c));
                } else {
                    builder.appendCodePoint(c);
                }
                upperNext = false;
            }
        }
        catch (IOException ignore) {
            return original;
        }
        return builder.toString();
    }

    private static KeyframeAnimation.StateCollection.State[] getRots(KeyframeAnimation.StateCollection stateCollection) {
        return new KeyframeAnimation.StateCollection.State[]{stateCollection.pitch, stateCollection.yaw, stateCollection.roll};
    }

    private static KeyframeAnimation.StateCollection.State[] getOffs(KeyframeAnimation.StateCollection stateCollection) {
        return new KeyframeAnimation.StateCollection.State[]{stateCollection.x, stateCollection.y, stateCollection.z};
    }
}

