/*
 * Decompiled with CFR 0.152.
 */
package dev.kosmx.playerAnim.mixin;

import dev.kosmx.playerAnim.core.impl.AnimationProcessor;
import dev.kosmx.playerAnim.core.util.SetableSupplier;
import dev.kosmx.playerAnim.impl.IAnimatedPlayer;
import dev.kosmx.playerAnim.impl.IMutableModel;
import dev.kosmx.playerAnim.impl.IPlayerModel;
import dev.kosmx.playerAnim.impl.IUpperPartHelper;
import dev.kosmx.playerAnim.impl.animation.AnimationApplier;
import dev.kosmx.playerAnim.impl.animation.IBendHelper;
import java.util.function.Function;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerModel.class}, priority=2000)
public class PlayerModelMixin<T extends LivingEntity>
extends HumanoidModel<T>
implements IPlayerModel {
    @Shadow
    @Final
    public ModelPart f_103378_;
    @Shadow
    @Final
    public ModelPart f_103375_;
    @Shadow
    @Final
    public ModelPart f_103374_;
    @Shadow
    @Final
    public ModelPart f_103377_;
    @Shadow
    @Final
    public ModelPart f_103376_;
    @Unique
    private final SetableSupplier<AnimationProcessor> emoteSupplier = new SetableSupplier();
    @Unique
    private boolean firstPersonNext = false;

    public PlayerModelMixin(ModelPart modelPart, Function<ResourceLocation, RenderType> function) {
        super(modelPart, function);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void initBendableStuff(ModelPart modelPart, boolean bl, CallbackInfo ci) {
        IMutableModel thisWithMixin = (IMutableModel)((Object)this);
        this.emoteSupplier.set(null);
        thisWithMixin.setEmoteSupplier(this.emoteSupplier);
        this.addBendMutator(this.f_103378_, Direction.DOWN);
        this.addBendMutator(this.f_103377_, Direction.UP);
        this.addBendMutator(this.f_103375_, Direction.UP);
        this.addBendMutator(this.f_103376_, Direction.UP);
        this.addBendMutator(this.f_103374_, Direction.UP);
        ((IUpperPartHelper)this.f_103375_).setUpperPart(true);
        ((IUpperPartHelper)this.f_103374_).setUpperPart(true);
    }

    @Unique
    private void addBendMutator(ModelPart part, Direction d) {
        IBendHelper.INSTANCE.initBend(part, d);
    }

    @Unique
    private void setDefaultPivot() {
        this.f_102814_.m_104227_(1.9f, 12.0f, 0.0f);
        this.f_102813_.m_104227_(-1.9f, 12.0f, 0.0f);
        this.f_102808_.m_104227_(0.0f, 0.0f, 0.0f);
        this.f_102811_.f_104202_ = 0.0f;
        this.f_102811_.f_104200_ = -5.0f;
        this.f_102812_.f_104202_ = 0.0f;
        this.f_102812_.f_104200_ = 5.0f;
        this.f_102810_.f_104203_ = 0.0f;
        this.f_102813_.f_104202_ = 0.1f;
        this.f_102814_.f_104202_ = 0.1f;
        this.f_102813_.f_104201_ = 12.0f;
        this.f_102814_.f_104201_ = 12.0f;
        this.f_102808_.f_104201_ = 0.0f;
        this.f_102808_.f_104205_ = 0.0f;
        this.f_102810_.f_104201_ = 0.0f;
        this.f_102810_.f_104200_ = 0.0f;
        this.f_102810_.f_104202_ = 0.0f;
        this.f_102810_.f_104204_ = 0.0f;
        this.f_102810_.f_104205_ = 0.0f;
    }

    @Inject(method={"setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V"}, at={@At(value="HEAD")})
    private void setDefaultBeforeRender(T livingEntity, float f, float g, float h, float i, float j, CallbackInfo ci) {
        this.setDefaultPivot();
    }

    @Inject(method={"setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/model/geom/ModelPart;copyFrom(Lnet/minecraft/client/model/geom/ModelPart;)V", ordinal=0)})
    private void setEmote(T livingEntity, float f, float g, float h, float i, float j, CallbackInfo ci) {
        if (!this.firstPersonNext && livingEntity instanceof AbstractClientPlayer && ((IAnimatedPlayer)livingEntity).getAnimation().isActive()) {
            AnimationApplier emote = ((IAnimatedPlayer)livingEntity).getAnimation();
            this.emoteSupplier.set(emote);
            emote.updatePart("head", this.f_102808_);
            this.f_102809_.m_104315_(this.f_102808_);
            emote.updatePart("leftArm", this.f_102812_);
            emote.updatePart("rightArm", this.f_102811_);
            emote.updatePart("leftLeg", this.f_102814_);
            emote.updatePart("rightLeg", this.f_102813_);
            emote.updatePart("torso", this.f_102810_);
        } else {
            this.firstPersonNext = false;
            this.emoteSupplier.set(null);
            PlayerModelMixin.resetBend(this.f_102810_);
            PlayerModelMixin.resetBend(this.f_102812_);
            PlayerModelMixin.resetBend(this.f_102811_);
            PlayerModelMixin.resetBend(this.f_102814_);
            PlayerModelMixin.resetBend(this.f_102813_);
        }
    }

    @Unique
    private static void resetBend(ModelPart part) {
        IBendHelper.INSTANCE.bend(part, null);
    }

    @Override
    public void playerAnimator_prepForFirstPersonRender() {
        this.firstPersonNext = true;
    }
}

