#define MAT_ID_OPAQUE 1
#define MAT_ID_GRASS 2
#define MAT_ID_LEAVES 3
#define MAT_ID_HAND 4
#define MAT_ID_ENTITY_PLAYER 5
#define MAT_ID_WATER 6
#define MAT_ID_STAINED_GLASS 7
#define MAT_ID_ICE 8
#define MAT_ID_TORCH 30
#define MAT_ID_CANDLE 31
#define MAT_ID_END_ROD 32
#define MAT_ID_GLOW_LICHEN 33
#define MAT_ID_SEA_PICKLE 34
#define MAT_ID_LAVA 35
#define MAT_ID_GLOWSTONE 36
#define MAT_ID_FIRE 37
#define MAT_ID_GLOW_BERRIES 38
#define MAT_ID_LIT_FURNACE 39
#define MAT_ID_DYNAMIC_ENTITY 40



struct MaterialMask
{
	float sky;
	float opaque;
	float grass;
	float leaves;
	float hand;
	float entityPlayer;
	float water;
	float stainedGlass;
	float ice;
	float torch;
	float candle;
	float endRod;
	float glowLichen;
	float seaPickle;
	float lava;
	float glowstone;
	float fire;
	float glowBerries;
	float litFurnace;
	float dynamicEntity;
};


float GetMaterialMask(const in int ID, in float matID) 
{
	//Catch last part of sky
	if (matID > 254.0f) 
	{
		matID = 0.0f;
	}

	if (matID == ID) 
	{
		return 1.0f;
	} 
	else 
	{
		return 0.0f;
	}
}

MaterialMask CalculateMasks(float materialID, vec2 coord)
{
	MaterialMask GTJIHvOSbK;

	materialID *= 255.0;

	// if (isEyeInWater > 0)
	// {
	// 	// GTJIHvOSbK.sky = 0.0f;
	// }
	// else
	{
		GTJIHvOSbK.sky = 0.0;
		if (texture2D(depthtex1, coord.st).x > 0.999999)
		{
			GTJIHvOSbK.sky = 1.0;
		}
	}
		//GTJIHvOSbK.sky = GetMaterialMask(0, materialID);
		//GTJIHvOSbK.sky = texture2D(depthtex1, texcoord).x > 0.999999 ? 1.0 : 0.0;



	GTJIHvOSbK.opaque 		= GetMaterialMask(MAT_ID_OPAQUE, materialID);
	GTJIHvOSbK.grass 			= GetMaterialMask(MAT_ID_GRASS, materialID);
	GTJIHvOSbK.leaves 		= GetMaterialMask(MAT_ID_LEAVES, materialID);
	GTJIHvOSbK.hand 			= GetMaterialMask(MAT_ID_HAND, materialID);
	GTJIHvOSbK.entityPlayer 	= GetMaterialMask(MAT_ID_ENTITY_PLAYER, materialID);
	GTJIHvOSbK.water 			= GetMaterialMask(MAT_ID_WATER, materialID);
	GTJIHvOSbK.stainedGlass	= GetMaterialMask(MAT_ID_STAINED_GLASS, materialID);
	GTJIHvOSbK.ice 			= GetMaterialMask(MAT_ID_ICE, materialID);
	GTJIHvOSbK.torch 			= GetMaterialMask(MAT_ID_TORCH, materialID);
	GTJIHvOSbK.candle 		= GetMaterialMask(MAT_ID_CANDLE, materialID);
	GTJIHvOSbK.endRod 		= GetMaterialMask(MAT_ID_END_ROD, materialID);
	GTJIHvOSbK.glowLichen 	= GetMaterialMask(MAT_ID_GLOW_LICHEN, materialID);
	GTJIHvOSbK.seaPickle 		= GetMaterialMask(MAT_ID_SEA_PICKLE, materialID);
	GTJIHvOSbK.lava 			= GetMaterialMask(MAT_ID_LAVA, materialID);
	GTJIHvOSbK.glowstone 		= GetMaterialMask(MAT_ID_GLOWSTONE, materialID);
	GTJIHvOSbK.fire 			= GetMaterialMask(MAT_ID_FIRE, materialID);
	GTJIHvOSbK.glowBerries 	= GetMaterialMask(MAT_ID_GLOW_BERRIES, materialID);
	GTJIHvOSbK.litFurnace 	= GetMaterialMask(MAT_ID_LIT_FURNACE, materialID);
	GTJIHvOSbK.dynamicEntity 	= GetMaterialMask(MAT_ID_DYNAMIC_ENTITY, materialID);

	return GTJIHvOSbK;
}
