/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.gl.versioned;

import com.jozufozu.flywheel.backend.gl.buffer.GlBufferType;
import com.jozufozu.flywheel.backend.gl.versioned.GlVersioned;
import org.lwjgl.opengl.ARBBufferStorage;
import org.lwjgl.opengl.GL44;
import org.lwjgl.opengl.GLCapabilities;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum BufferStorage implements GlVersioned
{
    GL44CORE{

        @Override
        public boolean supported(GLCapabilities caps) {
            return caps.OpenGL44;
        }

        @Override
        public void bufferStorage(GlBufferType target, long size, int flags) {
            GL44.glBufferStorage((int)target.glEnum, (long)size, (int)flags);
        }
    }
    ,
    ARB{

        @Override
        public boolean supported(GLCapabilities caps) {
            return caps.GL_ARB_buffer_storage;
        }

        @Override
        public void bufferStorage(GlBufferType target, long size, int flags) {
            ARBBufferStorage.glBufferStorage((int)target.glEnum, (long)size, (int)flags);
        }
    }
    ,
    UNSUPPORTED{

        @Override
        public boolean supported(GLCapabilities caps) {
            return true;
        }

        @Override
        public void bufferStorage(GlBufferType target, long size, int flags) {
            throw new UnsupportedOperationException();
        }
    };


    public abstract void bufferStorage(GlBufferType var1, long var2, int var4);
}

