/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betteroceanmonuments.mixin;

import com.yungnickyoung.minecraft.betteroceanmonuments.mixin.accessor.ProjectileAccessor;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractArrow.class})
public abstract class PersistentTridentMixin
extends Entity {
    private static final ResourceLocation monumentResourceLocation = new ResourceLocation("betteroceanmonuments", "ocean_monument");

    public PersistentTridentMixin(EntityType<?> $$0, Level $$1) {
        super($$0, $$1);
    }

    @Inject(method={"tickDespawn"}, at={@At(value="HEAD")}, cancellable=true)
    protected void preventTridentDespawning(CallbackInfo ci) {
        if (this.f_19853_ instanceof ServerLevel && this.isTrident((Object)this) && this.getOwner((Object)this).equals("e624cdc1-c238-4dde-9f22-1f76b5123ce8")) {
            ResourceKey monumentKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122882_, (ResourceLocation)monumentResourceLocation);
            StructureStart structureStart = ((ServerLevel)this.f_19853_).m_8595_().m_207791_(this.m_142538_(), monumentKey);
            if (structureStart.m_73603_()) {
                ci.cancel();
            }
        }
    }

    private boolean isTrident(Object object) {
        return object instanceof ThrownTrident;
    }

    private String getOwner(Object object) {
        Projectile projectile;
        if (object instanceof Projectile && ((ProjectileAccessor)(projectile = (Projectile)object)).getOwnerUUID() != null) {
            return ((ProjectileAccessor)projectile).getOwnerUUID().toString();
        }
        return "";
    }
}

