/*
 * Decompiled with CFR 0.152.
 */
package dev.sapphic.armorsoundtweak;

import com.google.common.base.Suppliers;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.client.ConfigGuiHandler;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public final class EquipmentConfig {
    private final Slots slots;
    private final Sounds sounds;

    private EquipmentConfig(ForgeConfigSpec.Builder builder) {
        this.slots = new Slots(builder);
        builder.comment("The types of equip sounds to be played for equipment").push("sounds");
        this.sounds = new Sounds(builder);
        builder.pop();
    }

    static Supplier<EquipmentConfig> lazy() {
        return Suppliers.memoize(() -> {
            ForgeConfigSpec.Builder configBuilder = new ForgeConfigSpec.Builder();
            EquipmentConfig config = new EquipmentConfig(configBuilder);
            ModLoadingContext context = ModLoadingContext.get();
            context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)configBuilder.build(), "armorsoundtweak.toml");
            if (ModList.get().isLoaded("cloth-config")) {
                context.registerExtensionPoint(ConfigGuiHandler.ConfigGuiFactory.class, () -> new ConfigGuiHandler.ConfigGuiFactory((BiFunction)new ScreenFactory(config)));
            }
            return config;
        });
    }

    public boolean allowsArmor() {
        return (Boolean)this.slots.armor.get();
    }

    public boolean allowsCurios() {
        return (Boolean)this.slots.curios.get();
    }

    public Sounds sounds() {
        return this.sounds;
    }

    public static final class Slots {
        private final ForgeConfigSpec.BooleanValue armor;
        private final ForgeConfigSpec.BooleanValue curios;

        Slots(ForgeConfigSpec.Builder builder) {
            this.armor = builder.define("armor", true);
            this.curios = builder.define("curios", true);
        }
    }

    public static final class Sounds {
        private final ForgeConfigSpec.BooleanValue armor;
        private final ForgeConfigSpec.BooleanValue elytra;
        private final ForgeConfigSpec.BooleanValue skulls;
        private final ForgeConfigSpec.BooleanValue pumpkins;
        private final ForgeConfigSpec.BooleanValue anything;

        Sounds(ForgeConfigSpec.Builder builder) {
            this.armor = builder.define("armor", true);
            this.elytra = builder.define("elytra", true);
            this.skulls = builder.define("skulls", false);
            this.pumpkins = builder.define("pumpkins", false);
            this.anything = builder.define("anything", false);
        }

        public boolean hasArmor() {
            return (Boolean)this.armor.get();
        }

        public boolean hasElytra() {
            return (Boolean)this.elytra.get();
        }

        public boolean hasSkulls() {
            return (Boolean)this.skulls.get();
        }

        public boolean hasPumpkins() {
            return (Boolean)this.pumpkins.get();
        }

        public boolean hasAnything() {
            return (Boolean)this.anything.get();
        }
    }

    private static final class ScreenFactory
    implements BiFunction<Minecraft, Screen, Screen> {
        private final EquipmentConfig config;

        private ScreenFactory(EquipmentConfig config) {
            this.config = config;
        }

        private static ConfigCategory category(ConfigBuilder config, String name) {
            return config.getOrCreateCategory((Component)new TranslatableComponent("armorsoundtweak.config." + name));
        }

        private static BooleanListEntry bool(ConfigEntryBuilder builder, String name, ForgeConfigSpec.BooleanValue value, boolean defaultValue) {
            return builder.startBooleanToggle((Component)new TranslatableComponent("armorsoundtweak.config." + name), ((Boolean)value.get()).booleanValue()).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.BooleanValue)value).set(arg_0)).setDefaultValue(defaultValue).build();
        }

        @Override
        public Screen apply(Minecraft minecraft, Screen screen) {
            ConfigBuilder config = ConfigBuilder.create().setTitle((Component)new TranslatableComponent("armorsoundtweak.config"));
            ConfigEntryBuilder entries = config.entryBuilder();
            Slots slots = this.config.slots;
            ScreenFactory.category(config, "slots").addEntry((AbstractConfigListEntry)ScreenFactory.bool(entries, "slots.curios", slots.curios, true)).addEntry((AbstractConfigListEntry)ScreenFactory.bool(entries, "slots.armor", slots.armor, true));
            Sounds sounds = this.config.sounds;
            ScreenFactory.category(config, "sounds").addEntry((AbstractConfigListEntry)ScreenFactory.bool(entries, "sounds.armor", sounds.armor, true)).addEntry((AbstractConfigListEntry)ScreenFactory.bool(entries, "sounds.elytra", sounds.elytra, true)).addEntry((AbstractConfigListEntry)ScreenFactory.bool(entries, "sounds.skulls", sounds.skulls, false)).addEntry((AbstractConfigListEntry)ScreenFactory.bool(entries, "sounds.pumpkins", sounds.pumpkins, false)).addEntry((AbstractConfigListEntry)ScreenFactory.bool(entries, "sounds.anything", sounds.anything, false));
            return config.build();
        }
    }
}

