/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.legendarytooltips;

import com.anthonyhilyard.legendarytooltips.LegendaryTooltipsConfig;
import com.anthonyhilyard.legendarytooltips.Loader;
import com.anthonyhilyard.legendarytooltips.render.TooltipDecor;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import org.apache.commons.lang3.exception.ExceptionUtils;

public final class FrameResourceParser
implements ResourceManagerReloadListener {
    public static final FrameResourceParser INSTANCE = new FrameResourceParser();

    private FrameResourceParser() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void m_6213_(ResourceManager resourceManager) {
        try {
            for (Resource resource : resourceManager.m_7396_(new ResourceLocation("legendarytooltips", "frame_definitions.json"))) {
                try {
                    InputStream inputStream = resource.m_6679_();
                    try {
                        JsonObject rootObject = GsonHelper.m_13861_((Reader)new InputStreamReader(inputStream), (boolean)true);
                        if (!rootObject.has("definitions")) continue;
                        JsonArray definitions = GsonHelper.m_13933_((JsonObject)rootObject, (String)"definitions");
                        for (int i = 0; i < definitions.size(); ++i) {
                            Object parsedImage;
                            JsonObject definitionObject = GsonHelper.m_13918_((JsonElement)definitions.get(i), (String)String.format("definitions[%d]", i));
                            String image = TooltipDecor.DEFAULT_BORDERS.toString();
                            int index = 0;
                            int priority = 0;
                            HashMap<String, TextColor> colors = new HashMap<String, TextColor>(Map.of("startColor", LegendaryTooltipsConfig.DEFAULT_START_COLOR, "endColor", LegendaryTooltipsConfig.DEFAULT_END_COLOR, "bgColor", LegendaryTooltipsConfig.DEFAULT_BG_COLOR));
                            ArrayList<String> selectors = new ArrayList<String>();
                            for (JsonElement selectorElement : GsonHelper.m_13933_((JsonObject)definitionObject, (String)"selectors")) {
                                selectors.add(GsonHelper.m_13805_((JsonElement)selectorElement, (String)"selector"));
                            }
                            if (definitionObject.has("image") && ResourceLocation.m_135830_((String)(parsedImage = GsonHelper.m_13906_((JsonObject)definitionObject, (String)"image")))) {
                                image = parsedImage;
                            }
                            if (definitionObject.has("index")) {
                                index = GsonHelper.m_13927_((JsonObject)definitionObject, (String)"index");
                            }
                            if (definitionObject.has("priority")) {
                                priority = GsonHelper.m_13927_((JsonObject)definitionObject, (String)"priority");
                            }
                            parsedImage = colors.keySet().iterator();
                            while (parsedImage.hasNext()) {
                                String colorKey = (String)parsedImage.next();
                                if (!definitionObject.has(colorKey)) continue;
                                TextColor parsedColor = null;
                                if (GsonHelper.m_13813_((JsonObject)definitionObject, (String)colorKey)) {
                                    parsedColor = LegendaryTooltipsConfig.getColor(GsonHelper.m_13906_((JsonObject)definitionObject, (String)colorKey));
                                } else if (GsonHelper.m_144762_((JsonObject)definitionObject, (String)colorKey)) {
                                    parsedColor = LegendaryTooltipsConfig.getColor(GsonHelper.m_13921_((JsonObject)definitionObject, (String)colorKey));
                                }
                                if (parsedColor == null) continue;
                                colors.put(colorKey, parsedColor);
                            }
                            LegendaryTooltipsConfig.FrameDefinition definition = new LegendaryTooltipsConfig.FrameDefinition(new ResourceLocation(image), index, ((TextColor)colors.get("startColor")).m_131265_(), ((TextColor)colors.get("endColor")).m_131265_(), ((TextColor)colors.get("bgColor")).m_131265_(), LegendaryTooltipsConfig.FrameSource.DATA, priority);
                            LegendaryTooltipsConfig.INSTANCE.addFrameDefinition(definition, selectors);
                        }
                    }
                    finally {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                }
                catch (Exception e) {
                    throw e;
                    return;
                }
            }
        }
        catch (Exception e) {
            Loader.LOGGER.warn("An error occurred while parsing frame definitions data:\n {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
    }
}

