/*
 * Decompiled with CFR 0.152.
 */
package com.daderpduck.seamless_loading_screen;

import com.daderpduck.seamless_loading_screen.ScreenshotLoader;
import com.daderpduck.seamless_loading_screen.config.Config;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;

public class ScreenshotRenderer {
    public static void renderScreenshot(double screenHeight, double screenWidth, float alpha) {
        Minecraft mc = Minecraft.m_91087_();
        float imageRatio = ScreenshotLoader.getImageRatio();
        float windowRatio = (float)mc.m_91268_().m_85441_() / (float)mc.m_91268_().m_85442_();
        float offset = 1.0f - windowRatio / imageRatio;
        RenderSystem.m_69465_();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)ScreenshotLoader.SCREENSHOT);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_5483_(0.0, screenHeight, 0.0).m_7421_(offset / 2.0f, 1.0f).m_5752_();
        bufferBuilder.m_5483_(screenWidth, screenHeight, 0.0).m_7421_(1.0f - offset / 2.0f, 1.0f).m_5752_();
        bufferBuilder.m_5483_(screenWidth, 0.0, 0.0).m_7421_(1.0f - offset / 2.0f, 0.0f).m_5752_();
        bufferBuilder.m_5483_(0.0, 0.0, 0.0).m_7421_(offset / 2.0f, 0.0f).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69461_();
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69482_();
    }

    public static class Fader {
        private static float elapsedTime = 0.0f;

        public static void tick(float partialTicks) {
            elapsedTime += partialTicks;
        }

        public static float getFadeTime() {
            return ((Integer)Config.FadeTime.get()).intValue();
        }

        public static float getHoldTime() {
            return ((Integer)Config.HoldTime.get()).intValue();
        }

        public static float getAlpha() {
            if (Fader.getFadeTime() == 0.0f) {
                return elapsedTime < Fader.getHoldTime() ? 1.0f : 0.0f;
            }
            return Math.min(1.0f - (elapsedTime - Fader.getHoldTime()) / Fader.getFadeTime(), 1.0f);
        }

        public static boolean isHolding() {
            return elapsedTime <= Fader.getHoldTime();
        }

        public static boolean isFading() {
            return elapsedTime != 0.0f && elapsedTime < Fader.getFadeTime() + Fader.getHoldTime();
        }

        public static void reset() {
            elapsedTime = 0.0f;
        }
    }
}

