/*
 * Decompiled with CFR 0.152.
 */
package com.daderpduck.seamless_loading_screen;

import com.daderpduck.seamless_loading_screen.ScreenshotLoader;
import com.daderpduck.seamless_loading_screen.SeamlessLoadingScreen;
import com.daderpduck.seamless_loading_screen.config.Config;
import com.daderpduck.seamless_loading_screen.events.OFFpsDrawEvent;
import com.daderpduck.seamless_loading_screen.events.OFLagometerEvent;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import org.apache.commons.io.FilenameUtils;

public class ScreenshotTaker
extends Screen {
    private static boolean takingScreenshot = false;
    private static boolean saveScreenshot = true;
    private static boolean hideGUI;
    private static final List<Consumer<Minecraft>> consumers;
    private final Consumer<RenderGameOverlayEvent.Pre> cancelOverlayListener = this::cancelGuiOverlay;
    private final Consumer<OFFpsDrawEvent> drawFpsListener = this::cancelFpsDraw;
    private final Consumer<OFLagometerEvent> lagometerListener = this::cancelLagometer;

    protected ScreenshotTaker() {
        super((Component)new TranslatableComponent("connect.joining"));
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGHEST, this.cancelOverlayListener);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGHEST, this.drawFpsListener);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGHEST, this.lagometerListener);
    }

    public static void takeScreenshot() {
        SeamlessLoadingScreen.LOGGER.info("Taking screenshot (takingScreenshot: {}, saveScreenshot: {})", (Object)takingScreenshot, (Object)saveScreenshot);
        Minecraft mc = Minecraft.m_91087_();
        if (!takingScreenshot && mc.f_91073_ != null) {
            takingScreenshot = true;
            hideGUI = mc.f_91066_.f_92062_;
            mc.f_91066_.f_92062_ = true;
            Config.ScreenshotResolution resolution = (Config.ScreenshotResolution)((Object)Config.Resolution.get());
            if (resolution != Config.ScreenshotResolution.NATIVE) {
                ScreenshotTaker.resizeScreen(mc, resolution.width, resolution.height);
            }
            mc.m_91152_((Screen)new ScreenshotTaker());
        }
    }

    public static void takeScreenshot(Consumer<Minecraft> consumer) {
        consumers.add(consumer);
        ScreenshotTaker.takeScreenshot();
    }

    public static void shouldSaveScreenshot(boolean b) {
        saveScreenshot = b;
    }

    private static void resizeScreen(Minecraft mc, int width, int height) {
        Window window = mc.m_91268_();
        window.m_166450_(width);
        window.m_166452_(height);
        mc.m_5741_();
    }

    public void m_6305_(@Nonnull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (!takingScreenshot) {
            return;
        }
        Minecraft mc = this.f_96541_;
        if (mc == null) {
            return;
        }
        this.writeScreenshot();
        if (((Boolean)Config.UpdateWorldIcon.get()).booleanValue()) {
            ScreenshotTaker.tryCreateWorldIcon(mc);
        }
        mc.f_91066_.f_92062_ = hideGUI;
        takingScreenshot = false;
        if (Config.Resolution.get() != Config.ScreenshotResolution.NATIVE) {
            ScreenshotTaker.resizeScreen(mc, mc.m_91268_().m_85443_(), mc.m_91268_().m_85444_());
        }
        MinecraftForge.EVENT_BUS.unregister(this.cancelOverlayListener);
        MinecraftForge.EVENT_BUS.unregister(this.drawFpsListener);
        MinecraftForge.EVENT_BUS.unregister(this.lagometerListener);
        for (Consumer<Minecraft> consumer : consumers) {
            consumer.accept(mc);
        }
        consumers.clear();
    }

    private void writeScreenshot() {
        if (!saveScreenshot) {
            return;
        }
        if (ScreenshotLoader.getCurrentScreenshotPath() == null) {
            SeamlessLoadingScreen.LOGGER.error("Screenshot path is null!");
            return;
        }
        Minecraft mc = this.f_96541_;
        if (mc == null) {
            return;
        }
        try (NativeImage screenshotImage = Screenshot.m_92279_((RenderTarget)mc.m_91385_());){
            Path screenshotPath = ScreenshotLoader.getCurrentScreenshotPath();
            SeamlessLoadingScreen.LOGGER.info("Saving screenshot at {}", (Object)screenshotPath);
            AsynchronousFileChannel channel = AsynchronousFileChannel.open(screenshotPath, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            channel.write(ByteBuffer.wrap(screenshotImage.m_85121_()), 0L);
            if (((Boolean)Config.ArchiveScreenshots.get()).booleanValue()) {
                String fileName = FilenameUtils.removeExtension((String)screenshotPath.getFileName().toString());
                Path archivePath = Paths.get(Minecraft.m_91087_().f_91069_.getPath(), "screenshots/worlds/archive/" + fileName + "_" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + ".png");
                AsynchronousFileChannel archiveChannel = AsynchronousFileChannel.open(archivePath, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                archiveChannel.write(ByteBuffer.wrap(screenshotImage.m_85121_()), 0L);
            }
        }
        catch (IOException e) {
            SeamlessLoadingScreen.LOGGER.error("Failed to save screenshot", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void tryCreateWorldIcon(Minecraft mc) {
        if (mc.m_91090_() && mc.m_91092_() != null && mc.m_91092_().m_182649_().isPresent()) {
            NativeImage nativeimage = Screenshot.m_92279_((RenderTarget)mc.m_91385_());
            int i = nativeimage.m_84982_();
            int j = nativeimage.m_85084_();
            int k = 0;
            int l = 0;
            if (i > j) {
                k = (i - j) / 2;
                i = j;
            } else {
                l = (j - i) / 2;
                j = i;
            }
            try (NativeImage nativeimage1 = new NativeImage(64, 64, false);){
                nativeimage.m_85034_(k, l, i, j, nativeimage1);
                AsynchronousFileChannel channel = AsynchronousFileChannel.open((Path)mc.m_91092_().m_182649_().get(), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                channel.write(ByteBuffer.wrap(nativeimage1.m_85121_()), 0L);
            }
            catch (IOException ioexception) {
                SeamlessLoadingScreen.LOGGER.warn("Couldn't save auto screenshot", (Throwable)ioexception);
            }
            finally {
                nativeimage.close();
            }
        }
    }

    private void cancelGuiOverlay(RenderGameOverlayEvent.Pre event) {
        if (takingScreenshot) {
            event.setCanceled(true);
        }
    }

    private void cancelFpsDraw(OFFpsDrawEvent event) {
        if (takingScreenshot) {
            event.setCanceled(true);
        }
    }

    private void cancelLagometer(OFLagometerEvent event) {
        if (takingScreenshot) {
            event.setCanceled(true);
        }
    }

    static {
        consumers = new ArrayList<Consumer<Minecraft>>();
    }
}

